/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.utils;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.Actionparameter;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;

public class MenuExport {
    private static final Logger log = LoggerFactory.getLogger(MenuExport.class);
    private final HierarchicalMenuItem targetMenu;
    private final Document document;

    private void addElementToDocument(Element rootElement, HierarchicalMenuItem parentMenu) {
        rootElement.addAttribute("order", parentMenu.getOrder().toString());
        rootElement.addAttribute("name", parentMenu.getName());
        Element cmactionElement = rootElement.addElement("TABLE_CMACTION");
        cmactionElement.addAttribute("code", parentMenu.getCmaction().getCmactioncode().toString());
        cmactionElement.addAttribute("name", parentMenu.getCmaction().getCmactionname());
        if (parentMenu.getCmaction().getCommandcode() != null) {
            Element commandElement = cmactionElement.addElement("TABLE_COMMAND");
            commandElement.addAttribute("code", parentMenu.getCmaction().getCommand().getCommandcode().toString());
            commandElement.addAttribute("name", parentMenu.getCmaction().getCommand().getCommandname());
            commandElement.addAttribute("description", parentMenu.getCmaction().getCommand().getDescription());
        }
        for (Actionparameter parameter : parentMenu.getActionParameters()) {
            Element parameterElement = cmactionElement.addElement("TABLE_PARAMETER");
            parameterElement.addAttribute("code", parameter.getActionparametercode().toString());
            parameterElement.addAttribute("order", parameter.getParameterorder().toString());
            parameterElement.addAttribute("value", parameter.getParametervalue());
        }
        if (parentMenu.getMenu() != null) {
            Element menuElement = rootElement.addElement("TABLE_MENU");
            menuElement.addAttribute("code", parentMenu.getMenu().getMenucode().toString());
            menuElement.addAttribute("name", parentMenu.getMenu().getMenuname());
        }
        if (parentMenu.getMenuitem() != null) {
            Element menuitemElement = rootElement.addElement("TABLE_MENUITEM");
            menuitemElement.addAttribute("code", parentMenu.getMenuitem().getMenuitemcode().toString());
            menuitemElement.addAttribute("order", parentMenu.getMenuitem().getMenuitemorder().toString());
        }
    }

    private void parse(Element rootElement, HierarchicalMenuItem parentMenu) {
        Element newElement;
        this.addElementToDocument(rootElement, parentMenu);
        for (HierarchicalMenuItem menu : parentMenu.getMenues()) {
            newElement = rootElement.addElement("TREE_MENU");
            this.parse(newElement, menu);
        }
        for (HierarchicalMenuItem action : parentMenu.getActions()) {
            newElement = rootElement.addElement("TREE_ACTION");
            this.parse(newElement, action);
        }
    }

    public MenuExport(HierarchicalMenuItem targetMenu) {
        this.targetMenu = targetMenu;
        this.document = DocumentHelper.createDocument();
    }

    public void export(String fileName) {
        Element element = this.document.addElement("TREE_MENU");
        this.parse(element, this.targetMenu);
        try {
            XMLWriter xmlWriter = new XMLWriter((Writer)new FileWriter(fileName));
            xmlWriter.write(this.document);
            xmlWriter.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

