/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.examples;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.widgets.figures.IntensityGraphFigure;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IntensityGraphExample {
    private static int count = 0;
    private static final int DataHeight = 1024;
    private static final int DataWidth = 1280;

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(300, 250);
        shell.open();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        final IntensityGraphFigure intensityGraph = new IntensityGraphFigure();
        final short[] simuData = new short[0x280000];
        final short[] data = new short[0x140000];
        int seed = count++;
        int i = 0;
        while (i < 1024) {
            int j = 0;
            while (j < 1280) {
                int x = j - 1280;
                int y = i - 1024;
                int p = (int)Math.sqrt(x * x + y * y);
                simuData[i * 1280 + j] = (short)(Math.sin((double)(p * 2) * Math.PI / 1280.0 + (double)seed * Math.PI / 100.0) * 100.0);
                ++j;
            }
            ++i;
        }
        intensityGraph.setMax(100.0);
        intensityGraph.setMin(-100.0);
        intensityGraph.setDataHeight(1024);
        intensityGraph.setDataWidth(1280);
        intensityGraph.setColorMap(new ColorMap(ColorMap.PredefinedColorMap.JET, true, true));
        intensityGraph.addROI("ROI 1", new IntensityGraphFigure.IROIListener(){

            @Override
            public void roiUpdated(int xIndex, int yIndex, int width, int height) {
                System.out.println("Region of Interest: (" + xIndex + ", " + yIndex + ", " + width + ", " + height + ")");
            }
        }, null);
        lws.setContents((IFigure)intensityGraph);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                System.arraycopy(simuData, count % 1280, data, 0, 0x140000);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        count = count + 1;
                        intensityGraph.setDataArray(simuData);
                    }
                });
            }
        }, 100L, 10L, TimeUnit.MILLISECONDS);
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        future.cancel(true);
        scheduler.shutdown();
    }
}

