/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.MiddleServerInfo;

public class MiddleServersRestClient {
    private static final String MIDDLE_SERVERS_URL = "middleServers";
    private final RestInvokerManager restInvokerManager;

    public MiddleServersRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public Long countMiddleServers() {
        return this.restInvokerManager.getRestInvoker().invokeGet("middleServers/count", Long.class);
    }

    public Boolean existsMiddleServer(String code) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("middleServers/{0}/exists", code), Boolean.class);
    }

    public List<MiddleServerInfo> getMiddleServers() {
        ParameterizedTypeReference<List<MiddleServerInfo>> returnTypeRef = new ParameterizedTypeReference<List<MiddleServerInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(MIDDLE_SERVERS_URL, returnTypeRef);
    }

    public List<MiddleServerInfo> getMiddleServersByGroupId(String groupId) {
        ParameterizedTypeReference<List<MiddleServerInfo>> returnTypeRef = new ParameterizedTypeReference<List<MiddleServerInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("middleServers?groupId={0}", groupId), returnTypeRef);
    }

    public List<MiddleServerInfo> getMiddleServersByTagId(String tagId) {
        ParameterizedTypeReference<List<MiddleServerInfo>> returnTypeRef = new ParameterizedTypeReference<List<MiddleServerInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("middleServers?tagId={0}", tagId), returnTypeRef);
    }

    public List<MiddleServerInfo> getMiddleServersByClusterId(String clusterId) {
        ParameterizedTypeReference<List<MiddleServerInfo>> returnTypeRef = new ParameterizedTypeReference<List<MiddleServerInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("middleServers?clusterId={0}", clusterId), returnTypeRef);
    }

    public MiddleServerInfo getMiddleServer(String code) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("middleServers/{0}", code), MiddleServerInfo.class);
    }

    public MiddleServerInfo getMiddleServerByIp(String ip) {
        if (ip == null) {
            throw new IllegalArgumentException("ip can't be null");
        }
        String hostName = ip.replace('.', '-');
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("middleServers/ip/{0}", hostName), MiddleServerInfo.class);
    }
}

