/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.User;

public class UsersRestClient {
    private static final String USERS_URL = "users";
    private final RestInvokerManager restInvokerManager;

    public UsersRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public WebUser login(User authUser) {
        return this.restInvokerManager.getRestInvoker().invokePost("login", authUser, WebUser.class);
    }

    public List<User> getUsersList() {
        ParameterizedTypeReference<List<User>> returnTypeRef = new ParameterizedTypeReference<List<User>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(USERS_URL, returnTypeRef);
    }

    public User getUser(String username) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("users/{0}", username), User.class);
    }

    public void addUser(User newUser) {
        this.restInvokerManager.getRestInvoker().invokePost(USERS_URL, newUser);
    }

    public void updateUser(User correctUser) {
        this.restInvokerManager.getRestInvoker().invokePut(USERS_URL, correctUser);
    }

    public void removeUser(String username) {
        this.restInvokerManager.getRestInvoker().invokeDelete(RestInvoker.urlBuild("users/{0}", username));
    }
}

