/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.notify;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.mihalis.opal.notify.NotifierColors;

public class NotifierColorsFactory {
    private NotifierColorsFactory() {
    }

    static NotifierColors getColorsForTheme(NotifierTheme notifierTheme) {
        NotifierColors notifierColors = new NotifierColors();
        switch (notifierTheme) {
            case BLUE_THEME: {
                notifierColors.textColor = new Color((Device)Display.getDefault(), 4, 64, 140);
                notifierColors.titleColor = Display.getDefault().getSystemColor(2);
                notifierColors.borderColor = new Color((Device)Display.getDefault(), 153, 188, 232);
                notifierColors.leftColor = new Color((Device)Display.getDefault(), 210, 225, 244);
                notifierColors.rightColor = new Color((Device)Display.getDefault(), 182, 207, 238);
                break;
            }
            case GRAY_THEME: {
                notifierColors.textColor = Display.getDefault().getSystemColor(2);
                notifierColors.titleColor = Display.getDefault().getSystemColor(4);
                notifierColors.borderColor = new Color((Device)Display.getDefault(), 208, 208, 208);
                notifierColors.leftColor = new Color((Device)Display.getDefault(), 255, 255, 255);
                notifierColors.rightColor = new Color((Device)Display.getDefault(), 208, 208, 208);
                break;
            }
            default: {
                notifierColors.textColor = Display.getDefault().getSystemColor(2);
                notifierColors.titleColor = Display.getDefault().getSystemColor(2);
                notifierColors.borderColor = new Color((Device)Display.getDefault(), 218, 178, 85);
                notifierColors.leftColor = new Color((Device)Display.getDefault(), 220, 220, 160);
                notifierColors.rightColor = new Color((Device)Display.getDefault(), 255, 255, 191);
            }
        }
        return notifierColors;
    }

    public static enum NotifierTheme {
        YELLOW_THEME,
        GRAY_THEME,
        BLUE_THEME;

    }
}

