/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.prefs.Preferences;
import org.eclipse.nebula.widgets.ganttchart.AbstractSettings;
import org.eclipse.nebula.widgets.ganttchart.ColorCache;
import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.nebula.widgets.ganttchart.GanttPhase;
import org.eclipse.nebula.widgets.ganttchart.GanttSection;
import org.eclipse.nebula.widgets.ganttchart.GanttSpecialDateRange;
import org.eclipse.nebula.widgets.ganttchart.IColorManager;
import org.eclipse.nebula.widgets.ganttchart.IGanttEventListener;
import org.eclipse.nebula.widgets.ganttchart.themes.ColorThemeGrayBlue;
import org.eclipse.nebula.widgets.ganttchart.themes.ColorThemeHighContrastBlack;
import org.eclipse.nebula.widgets.ganttchart.themes.ColorThemeSilver;
import org.eclipse.nebula.widgets.ganttchart.themes.ColorThemeWindowsBlue;
import org.eclipse.nebula.widgets.ganttchart.undoredo.UndoRedoListenerAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class GanttTester {
    private GanttChart _ganttChart;
    private GanttComposite _ganttComposite;
    private final ViewForm _vfChart;
    private Text _timerText;
    private Button _bUseSections;
    private Button _bUseSectionsRight;
    private Button _bUseSectionsLeft;
    private Button _bDrawHorizontalLines;
    private Button _bIncreaseDates;
    private Button _bCreate;
    private Button _bCreatePlannedDates;
    private Button _bUndo;
    private Button _bRedo;
    private Button _bRandomEventLength;
    private Button _bConnectEvents;
    private Button _bRandomColors;
    private Button _bRandomEventColors;
    private Button _bDNDLimits;
    private Button _bRandomPercentCompletes;
    private Button _bGanttPhases;
    private Button _bSpecialDateRange;
    private Button _bRandomRowHeights;
    private Button _bRandomEventVLoc;
    private Button _bRandomEventTextHLocation;
    private Button _bRandomEventTextVLocation;
    private Button _bUseDDay;
    private Button _bLockHeader;
    private Button _bMoveOnlyLaterLinkedEvents;
    private Button _bClear;
    private Button _bRedraw;
    private Button _bHeavyRedraw;
    private Button _bSaveFull;
    private Button _bRandomImage;
    private Combo _vDNDCombo;
    private Combo _eventCountCombo;
    private Combo _themeCombo;
    private Combo _scrollCombo;
    private Combo _selCombo;
    private Combo _localeCombo;
    private Spinner _sMaxSections;
    private Spinner _sConnectionCountNumber;
    private Button _bEnableAutoScroll;
    private Button _bEventResizing;
    private Button _bEventDND;
    private Button _bAdjustForLetters;
    private Combo _bConnectionLineStyle;
    private Button _bShowArrows;
    private Button _bShowBoldScopeText;
    private Button _bShowGradientEventBars;
    private Button _bShowOnlyDependenciesForSelectedItems;
    private Button _bShowTooltips;
    private Button _bShowAdvancedTooltips;
    private Button _bEnableZooming;
    private Button _bShowZoomLevelBox;
    private Button _bAllowBlankAreaDragAndDropToMoveDates;
    private Button _bAllowVerticalBlankDnd;
    private Button _bFlipBlankAreaDragDirection;
    private Button _bDrawSelectionMarkerAroundSelectedEvent;
    private Button _bAllowCheckpointResizing;
    private Button _bStartCalendarOnFirstDayOfWeek;
    private Button _bDrawFullPercentageBar;
    private Button _bDrawLockedDateMarks;
    private Button _bShowDateTipsOnScrolling;
    private Button _bZoomToMousePointerDateOnWheelZooming;
    private Button _bScaleImageToDay;
    private Button _bAllowArrowKeysToMoveChart;
    private Button _bCreateSpecialRangesWithAllowNoEvents;
    private Table _tEventLog;
    private Listener _undoRedoListener;
    private Preferences _prefs = Preferences.systemNodeForPackage(GanttTester.class);
    private static final String KEY = "prefKey";

    public static void main(String[] args) {
        new GanttTester();
    }

    public GanttTester() {
        Display display = Display.getDefault();
        Monitor m = display.getMonitors()[0];
        Shell shell = new Shell(display);
        shell.setText("GanttChart Test Application");
        shell.setLayout((Layout)new FillLayout());
        SashForm sfVSplit = new SashForm((Composite)shell, 512);
        SashForm sfHSplit = new SashForm((Composite)sfVSplit, 256);
        ViewForm vfBottom = new ViewForm((Composite)sfVSplit, 0);
        this._vfChart = new ViewForm((Composite)sfHSplit, 0);
        ViewForm rightForm = new ViewForm((Composite)sfHSplit, 0);
        final ScrolledComposite sc = new ScrolledComposite((Composite)rightForm, 768);
        rightForm.setContent((Control)sc);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.getVerticalBar().setPageIncrement(150);
        final Composite rightComposite = new Composite((Composite)sc, 0);
        GridLayout gl = new GridLayout();
        gl.marginLeft = 0;
        gl.marginTop = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        rightComposite.setLayout((Layout)gl);
        sc.setContent((Control)rightComposite);
        rightComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                sc.setMinSize(rightComposite.computeSize(-1, -1));
            }
        });
        sfVSplit.setWeights(new int[]{91, 9});
        sfHSplit.setWeights(new int[]{70, 30});
        this._ganttChart = new GanttChart((Composite)this._vfChart, 2);
        this._vfChart.setContent((Control)this._ganttChart);
        this._ganttComposite = this._ganttChart.getGanttComposite();
        TabFolder tfRight = new TabFolder(rightComposite, 2048);
        TabItem tiGeneral = new TabItem(tfRight, 0);
        tiGeneral.setText("Creation");
        TabItem tiAdvanced = new TabItem(tfRight, 0);
        tiAdvanced.setText("Advanced");
        TabItem tiEventLog = new TabItem(tfRight, 0);
        tiEventLog.setText("Event Log");
        Composite bottom = new Composite(rightComposite, 0);
        bottom.setLayout((Layout)new GridLayout());
        this.createCreateButtons(bottom);
        vfBottom.setContent((Control)this.createBottom((Composite)vfBottom));
        tiGeneral.setControl((Control)this.createCreationTab((Composite)tfRight));
        tiAdvanced.setControl((Control)this.createAdvancedTab((Composite)tfRight));
        tiEventLog.setControl((Control)this.createEventLogTab((Composite)tfRight));
        shell.setMaximized(true);
        shell.setLocation(new Point(m.getClientArea().x, 0));
        sc.setMinSize(rightComposite.computeSize(-1, -1));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.removeListener(1, this._undoRedoListener);
        shell.dispose();
    }

    private Composite createEventLogTab(Composite parent) {
        final ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.getHorizontalBar().setPageIncrement(100);
        sc.getVerticalBar().setPageIncrement(100);
        final Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, true));
        sc.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                sc.setMinSize(comp.computeSize(-1, -1));
            }
        });
        Group group = new Group(comp, 0);
        group.setText("Event Log");
        group.setLayout((Layout)new FillLayout());
        group.setLayoutData((Object)new GridData(1808));
        this._tEventLog = new Table((Composite)group, 68354);
        this._tEventLog.setBackground(ColorCache.getWhite());
        Menu m = new Menu((Control)this._tEventLog);
        MenuItem mClear = new MenuItem(m, 0);
        mClear.setText("Clear Log");
        mClear.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttTester.this._tEventLog.removeAll();
            }
        });
        this._tEventLog.setMenu(m);
        return sc;
    }

    private Composite createAdvancedTab(Composite parent) {
        final ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.getHorizontalBar().setPageIncrement(100);
        sc.getVerticalBar().setPageIncrement(100);
        final Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, true));
        sc.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                sc.setMinSize(comp.computeSize(-1, -1));
            }
        });
        Group group = new Group(comp, 0);
        group.setText("Advanced");
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(768));
        GridData oneRow = new GridData(768);
        oneRow.horizontalSpan = 2;
        oneRow.grabExcessHorizontalSpace = true;
        this._bEnableAutoScroll = new Button((Composite)group, 32);
        this._bEnableAutoScroll.setText("Enable Auto Scroll");
        this._bEnableAutoScroll.setToolTipText("Causes chart to auto scroll when using DND. On by default.");
        this._bEnableAutoScroll.setSelection(true);
        this._bEnableAutoScroll.setLayoutData((Object)oneRow);
        this._bEnableAutoScroll.setData(KEY, (Object)"enableAutoScroll");
        this.prefLoad((Control)this._bEnableAutoScroll);
        this.prefHook((Control)this._bEnableAutoScroll);
        this._bEventResizing = new Button((Composite)group, 32);
        this._bEventResizing.setText("Allow Event Resizing");
        this._bEventResizing.setToolTipText("Allows for resizing of events. On by default.");
        this._bEventResizing.setSelection(true);
        this._bEventResizing.setLayoutData((Object)oneRow);
        this._bEventResizing.setData(KEY, (Object)"bEventResizing");
        this.prefLoad((Control)this._bEventResizing);
        this.prefHook((Control)this._bEventResizing);
        this._bEventDND = new Button((Composite)group, 32);
        this._bEventDND.setText("Allow Event Drag n Drop (DND)");
        this._bEventDND.setToolTipText("Allows for dragging of events. On by default.");
        this._bEventDND.setSelection(true);
        this._bEventDND.setLayoutData((Object)oneRow);
        this._bEventDND.setData(KEY, (Object)"bEventDND");
        this.prefLoad((Control)this._bEventDND);
        this.prefHook((Control)this._bEventDND);
        this._bAdjustForLetters = new Button((Composite)group, 32);
        this._bAdjustForLetters.setText("Adjust Spacing For Letters");
        this._bAdjustForLetters.setToolTipText("When letters are drawn anywhere in the header they are auto-adjusted to fit in nicely. On by default.");
        this._bAdjustForLetters.setSelection(true);
        this._bAdjustForLetters.setLayoutData((Object)oneRow);
        this._bAdjustForLetters.setData(KEY, (Object)"bAdjustForLetters");
        this.prefLoad((Control)this._bAdjustForLetters);
        this.prefHook((Control)this._bAdjustForLetters);
        Label lConn = new Label((Composite)group, 0);
        lConn.setText("Connecting Line Style");
        this._bConnectionLineStyle = new Combo((Composite)group, 8);
        this._bConnectionLineStyle.add("Right to Left");
        this._bConnectionLineStyle.add("Right to Top");
        this._bConnectionLineStyle.add("MS Project Style");
        this._bConnectionLineStyle.add("Birds Path");
        this._bConnectionLineStyle.select(2);
        this._bConnectionLineStyle.setData(KEY, (Object)"bConnectionLineStyle");
        this._bConnectionLineStyle.setToolTipText("How the connecting line is drawn. Default is MS Project Style");
        this.prefLoad((Control)this._bConnectionLineStyle);
        this.prefHook((Control)this._bConnectionLineStyle);
        this._bShowArrows = new Button((Composite)group, 32);
        this._bShowArrows.setText("Show Arrows");
        this._bShowArrows.setToolTipText("Arrowheads on/off. Default is on.");
        this._bShowArrows.setSelection(true);
        this._bShowArrows.setLayoutData((Object)oneRow);
        this._bShowArrows.setData(KEY, (Object)"bShowArrows");
        this.prefLoad((Control)this._bShowArrows);
        this.prefHook((Control)this._bShowArrows);
        this._bShowBoldScopeText = new Button((Composite)group, 32);
        this._bShowBoldScopeText.setText("Show Bold Scope Text");
        this._bShowBoldScopeText.setToolTipText("Scope Text is Bold. Default is on.");
        this._bShowBoldScopeText.setSelection(true);
        this._bShowBoldScopeText.setLayoutData((Object)oneRow);
        this._bShowBoldScopeText.setData(KEY, (Object)"bShowBoldScopeText");
        this.prefLoad((Control)this._bShowBoldScopeText);
        this.prefHook((Control)this._bShowBoldScopeText);
        this._bShowGradientEventBars = new Button((Composite)group, 32);
        this._bShowGradientEventBars.setText("Show Gradient Event Bars");
        this._bShowGradientEventBars.setToolTipText("Gradient Events On/Off. Default is on. (If off only 1 color is used)");
        this._bShowGradientEventBars.setSelection(true);
        this._bShowGradientEventBars.setLayoutData((Object)oneRow);
        this._bShowGradientEventBars.setData(KEY, (Object)"bShowGradientEventBars");
        this.prefLoad((Control)this._bShowGradientEventBars);
        this.prefHook((Control)this._bShowGradientEventBars);
        this._bShowOnlyDependenciesForSelectedItems = new Button((Composite)group, 32);
        this._bShowOnlyDependenciesForSelectedItems.setText("Show Only Dependencies for Selected Items");
        this._bShowOnlyDependenciesForSelectedItems.setToolTipText("Shows only dependency arrows when items are selected and the selected event has connections/dependencies to other events. Default is off.");
        this._bShowOnlyDependenciesForSelectedItems.setSelection(false);
        this._bShowOnlyDependenciesForSelectedItems.setLayoutData((Object)oneRow);
        this._bShowOnlyDependenciesForSelectedItems.setData(KEY, (Object)"bShowOnlyDependenciesForSelectedItems");
        this.prefLoad((Control)this._bShowOnlyDependenciesForSelectedItems);
        this.prefHook((Control)this._bShowOnlyDependenciesForSelectedItems);
        this._bShowTooltips = new Button((Composite)group, 32);
        this._bShowTooltips.setText("Show Tooltips");
        this._bShowTooltips.setToolTipText("Tooltips on/off. Default is on.");
        this._bShowTooltips.setSelection(true);
        this._bShowTooltips.setLayoutData((Object)oneRow);
        this._bShowTooltips.setData(KEY, (Object)"bShowTooltips");
        this.prefLoad((Control)this._bShowTooltips);
        this.prefHook((Control)this._bShowTooltips);
        this._bShowAdvancedTooltips = new Button((Composite)group, 32);
        this._bShowAdvancedTooltips.setText("Use Advanced Tooltips");
        this._bShowAdvancedTooltips.setToolTipText("Advanced Tooltips on/off. Default is on.");
        this._bShowAdvancedTooltips.setSelection(true);
        this._bShowAdvancedTooltips.setLayoutData((Object)oneRow);
        this._bShowAdvancedTooltips.setData(KEY, (Object)"bShowAdvancedTooltips");
        this.prefLoad((Control)this._bShowAdvancedTooltips);
        this.prefHook((Control)this._bShowAdvancedTooltips);
        this._bEnableZooming = new Button((Composite)group, 32);
        this._bEnableZooming.setText("Enable Zooming");
        this._bEnableZooming.setToolTipText("Whether chart can be zoomed / zoomed out. Default is on.");
        this._bEnableZooming.setSelection(true);
        this._bEnableZooming.setLayoutData((Object)oneRow);
        this._bEnableZooming.setData(KEY, (Object)"bEnableZooming");
        this.prefLoad((Control)this._bEnableZooming);
        this.prefHook((Control)this._bEnableZooming);
        this._bShowZoomLevelBox = new Button((Composite)group, 32);
        this._bShowZoomLevelBox.setText("Show Zoom-Level Box When Zooming");
        this._bShowZoomLevelBox.setToolTipText("Box that shows what zoom level is currently being zoomed to on/off. Default is on.");
        this._bShowZoomLevelBox.setSelection(true);
        this._bShowZoomLevelBox.setLayoutData((Object)oneRow);
        this._bShowZoomLevelBox.setData(KEY, (Object)"bShowZoomLevelBox");
        this.prefLoad((Control)this._bShowZoomLevelBox);
        this.prefHook((Control)this._bShowZoomLevelBox);
        this._bZoomToMousePointerDateOnWheelZooming = new Button((Composite)group, 32);
        this._bZoomToMousePointerDateOnWheelZooming.setText("Zoom In/Out To Mouse Pointer");
        this._bZoomToMousePointerDateOnWheelZooming.setToolTipText("When zooming the chart will try to keep the focus on the date where the mouse pointer is when the zoom happens. Default is on.");
        this._bZoomToMousePointerDateOnWheelZooming.setSelection(true);
        this._bZoomToMousePointerDateOnWheelZooming.setLayoutData((Object)oneRow);
        this._bZoomToMousePointerDateOnWheelZooming.setData(KEY, (Object)"bZoomToMousePointerDateOnWheelZooming");
        this.prefLoad((Control)this._bZoomToMousePointerDateOnWheelZooming);
        this.prefHook((Control)this._bZoomToMousePointerDateOnWheelZooming);
        this._bAllowBlankAreaDragAndDropToMoveDates = new Button((Composite)group, 32);
        this._bAllowBlankAreaDragAndDropToMoveDates.setText("Allow Horizontal Blank Area DND to Move Chart");
        this._bAllowBlankAreaDragAndDropToMoveDates.setToolTipText("When you grab a blank area of the chart and drag it, the chart will move in the drag direction horizontally. Default is on.");
        this._bAllowBlankAreaDragAndDropToMoveDates.setSelection(true);
        this._bAllowBlankAreaDragAndDropToMoveDates.setLayoutData((Object)oneRow);
        this._bAllowBlankAreaDragAndDropToMoveDates.setData(KEY, (Object)"bAllowBlankAreaDragAndDropToMoveDates");
        this.prefLoad((Control)this._bAllowBlankAreaDragAndDropToMoveDates);
        this.prefHook((Control)this._bAllowBlankAreaDragAndDropToMoveDates);
        this._bAllowVerticalBlankDnd = new Button((Composite)group, 32);
        this._bAllowVerticalBlankDnd.setText("Allow Vertical Blank Area DND to Move Chart)");
        this._bAllowVerticalBlankDnd.setToolTipText("When you grab a blank area of the chart and drag it, the chart will move in the drag direction vertically. Default is off.");
        this._bAllowVerticalBlankDnd.setSelection(false);
        this._bAllowVerticalBlankDnd.setLayoutData((Object)oneRow);
        this._bAllowVerticalBlankDnd.setData(KEY, (Object)"bAllowVerticalBlankDnd");
        this.prefLoad((Control)this._bAllowVerticalBlankDnd);
        this.prefHook((Control)this._bAllowVerticalBlankDnd);
        this._bFlipBlankAreaDragDirection = new Button((Composite)group, 32);
        this._bFlipBlankAreaDragDirection.setText("Flip Blank Area DND Direction");
        this._bFlipBlankAreaDragDirection.setToolTipText("This will invert the X-axis of the direction the chart is scrolling when blank-area drag and dropping (natural to most people). Default is on.");
        this._bFlipBlankAreaDragDirection.setSelection(true);
        this._bFlipBlankAreaDragDirection.setLayoutData((Object)oneRow);
        this._bFlipBlankAreaDragDirection.setData(KEY, (Object)"bFlipBlankAreaDragDirection");
        this.prefLoad((Control)this._bFlipBlankAreaDragDirection);
        this.prefHook((Control)this._bFlipBlankAreaDragDirection);
        this._bDrawSelectionMarkerAroundSelectedEvent = new Button((Composite)group, 32);
        this._bDrawSelectionMarkerAroundSelectedEvent.setText("Draw Selection Marker Around Selected Events");
        this._bDrawSelectionMarkerAroundSelectedEvent.setToolTipText("This will draw a selection marker (dotted line) around selected events. Default is on.");
        this._bDrawSelectionMarkerAroundSelectedEvent.setSelection(true);
        this._bDrawSelectionMarkerAroundSelectedEvent.setLayoutData((Object)oneRow);
        this._bDrawSelectionMarkerAroundSelectedEvent.setData(KEY, (Object)"bDrawSelectionMarkerAroundSelectedEvent");
        this.prefLoad((Control)this._bDrawSelectionMarkerAroundSelectedEvent);
        this.prefHook((Control)this._bDrawSelectionMarkerAroundSelectedEvent);
        this._bAllowCheckpointResizing = new Button((Composite)group, 32);
        this._bAllowCheckpointResizing.setText("Allow Checkpoint Resizing");
        this._bAllowCheckpointResizing.setToolTipText("This will allow for resizing of events marked as checkpoints. Default is false.");
        this._bAllowCheckpointResizing.setSelection(false);
        this._bAllowCheckpointResizing.setLayoutData((Object)oneRow);
        this._bAllowCheckpointResizing.setData(KEY, (Object)"bAllowCheckpointResizing");
        this.prefLoad((Control)this._bAllowCheckpointResizing);
        this.prefHook((Control)this._bAllowCheckpointResizing);
        this._bStartCalendarOnFirstDayOfWeek = new Button((Composite)group, 32);
        this._bStartCalendarOnFirstDayOfWeek.setText("Start Calendar on First Day of Week");
        this._bStartCalendarOnFirstDayOfWeek.setToolTipText("This will force calendar to start on the first day of the week of whatever the root calendar is. Default is false.");
        this._bStartCalendarOnFirstDayOfWeek.setSelection(false);
        this._bStartCalendarOnFirstDayOfWeek.setLayoutData((Object)oneRow);
        this._bStartCalendarOnFirstDayOfWeek.setData(KEY, (Object)"bStartCalendarOnFirstDayOfWeek");
        this.prefLoad((Control)this._bStartCalendarOnFirstDayOfWeek);
        this.prefHook((Control)this._bStartCalendarOnFirstDayOfWeek);
        this._bDrawFullPercentageBar = new Button((Composite)group, 32);
        this._bDrawFullPercentageBar.setText("Draw Full Percentage Bar");
        this._bDrawFullPercentageBar.setToolTipText("Percentage bar is filled in beyond the percentage complete value (assuming it's less than 100%) to fill out the entire event. Default is on.");
        this._bDrawFullPercentageBar.setSelection(true);
        this._bDrawFullPercentageBar.setLayoutData((Object)oneRow);
        this._bDrawFullPercentageBar.setData(KEY, (Object)"bDrawFullPercentageBar");
        this.prefLoad((Control)this._bDrawFullPercentageBar);
        this.prefHook((Control)this._bDrawFullPercentageBar);
        this._bDrawLockedDateMarks = new Button((Composite)group, 32);
        this._bDrawLockedDateMarks.setText("Draw Locked Date Marks");
        this._bDrawLockedDateMarks.setToolTipText("Whether locked date-range events (min / max dates) draw a bounding area or markers showing where the span starts/ends. Default is on.");
        this._bDrawLockedDateMarks.setSelection(true);
        this._bDrawLockedDateMarks.setLayoutData((Object)oneRow);
        this._bDrawLockedDateMarks.setData(KEY, (Object)"bDrawLockedDateMarks");
        this.prefLoad((Control)this._bDrawLockedDateMarks);
        this.prefHook((Control)this._bDrawLockedDateMarks);
        this._bShowDateTipsOnScrolling = new Button((Composite)group, 32);
        this._bShowDateTipsOnScrolling.setText("Show Date Tips on Scrolling");
        this._bShowDateTipsOnScrolling.setToolTipText("Whether date tips (tooltips) are shown when scrolling around to indicate what dates the user is viewing. Default is on.");
        this._bShowDateTipsOnScrolling.setSelection(true);
        this._bShowDateTipsOnScrolling.setLayoutData((Object)oneRow);
        this._bShowDateTipsOnScrolling.setData(KEY, (Object)"bShowDateTipsOnScrolling");
        this.prefLoad((Control)this._bShowDateTipsOnScrolling);
        this.prefHook((Control)this._bShowDateTipsOnScrolling);
        this._bScaleImageToDay = new Button((Composite)group, 32);
        this._bScaleImageToDay.setText("Scale Images To (Minimum) Width Of One Day");
        this._bScaleImageToDay.setToolTipText("Whether images should be scaled to the width of one day or if they can exceed one day. Default is on.");
        this._bScaleImageToDay.setSelection(true);
        this._bScaleImageToDay.setLayoutData((Object)oneRow);
        this._bScaleImageToDay.setData(KEY, (Object)"bScaleImageToDay");
        this.prefLoad((Control)this._bScaleImageToDay);
        this.prefHook((Control)this._bScaleImageToDay);
        this._bAllowArrowKeysToMoveChart = new Button((Composite)group, 32);
        this._bAllowArrowKeysToMoveChart.setText("Allow Arrow Keys To Scroll Chart");
        this._bAllowArrowKeysToMoveChart.setToolTipText("Whether arrow keys can scroll the chart left/right/up/down (like navigating with scrollbars). Default is off.");
        this._bAllowArrowKeysToMoveChart.setSelection(false);
        this._bAllowArrowKeysToMoveChart.setLayoutData((Object)oneRow);
        this._bAllowArrowKeysToMoveChart.setData(KEY, (Object)"bAllowArrowKeysToMoveChart");
        this.prefLoad((Control)this._bAllowArrowKeysToMoveChart);
        this.prefHook((Control)this._bAllowArrowKeysToMoveChart);
        this._bCreateSpecialRangesWithAllowNoEvents = new Button((Composite)group, 32);
        this._bCreateSpecialRangesWithAllowNoEvents.setText("Don't Allow Events on Special Date Ranges");
        this._bCreateSpecialRangesWithAllowNoEvents.setToolTipText("Whether special date ranges will not allow drag and drop or resizing over them. Default is off.");
        this._bCreateSpecialRangesWithAllowNoEvents.setSelection(false);
        this._bCreateSpecialRangesWithAllowNoEvents.setLayoutData((Object)oneRow);
        this._bCreateSpecialRangesWithAllowNoEvents.setData(KEY, (Object)"bCreateSpecialRangesWithAllowNoEvents");
        this.prefLoad((Control)this._bCreateSpecialRangesWithAllowNoEvents);
        this.prefHook((Control)this._bCreateSpecialRangesWithAllowNoEvents);
        return sc;
    }

    private Composite createCreationTab(Composite parent) {
        final ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.getHorizontalBar().setPageIncrement(100);
        sc.getVerticalBar().setPageIncrement(100);
        final Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, true));
        sc.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                sc.setMinSize(comp.computeSize(-1, -1));
            }
        });
        Group gGeneral = new Group(comp, 0);
        gGeneral.setText("General");
        gGeneral.setLayout((Layout)new GridLayout(2, true));
        gGeneral.setLayoutData((Object)new GridData(768));
        Label lEvents = new Label((Composite)gGeneral, 0);
        lEvents.setText("Number of Events");
        this._eventCountCombo = new Combo((Composite)gGeneral, 0);
        this._eventCountCombo.add("2");
        this._eventCountCombo.add("10");
        this._eventCountCombo.add("20");
        this._eventCountCombo.add("50");
        this._eventCountCombo.add("100");
        this._eventCountCombo.add("300");
        this._eventCountCombo.add("600");
        this._eventCountCombo.add("1000");
        this._eventCountCombo.add("2000");
        this._eventCountCombo.add("3000");
        this._eventCountCombo.add("4000");
        this._eventCountCombo.add("5000");
        this._eventCountCombo.select(3);
        this._eventCountCombo.setToolTipText("Number of events to create");
        this._eventCountCombo.setLayoutData((Object)new GridData(768));
        this._eventCountCombo.setData(KEY, (Object)"eventCountCombo");
        this.prefLoad((Control)this._eventCountCombo);
        this.prefHook((Control)this._eventCountCombo);
        Label lTheme = new Label((Composite)gGeneral, 0);
        lTheme.setText("Color Theme");
        this._themeCombo = new Combo((Composite)gGeneral, 8);
        this._themeCombo.add("Blue");
        this._themeCombo.add("Silver");
        this._themeCombo.add("Gray Blue");
        this._themeCombo.add("High Contrast (Black)");
        this._themeCombo.select(0);
        this._themeCombo.setData(KEY, (Object)"themeCombo");
        this.prefLoad((Control)this._themeCombo);
        this.prefHook((Control)this._themeCombo);
        Label lLocale = new Label((Composite)gGeneral, 0);
        lLocale.setText("Locale");
        this._localeCombo = new Combo((Composite)gGeneral, 8);
        Locale[] all = Locale.getAvailableLocales();
        int sel = 0;
        for (int i = 0; i < all.length; ++i) {
            this._localeCombo.add(all[i].toString());
            if (!all[i].equals(Locale.getDefault())) continue;
            sel = i;
        }
        this._localeCombo.select(sel);
        this._localeCombo.setData(KEY, (Object)"localeCombo");
        this.prefLoad((Control)this._localeCombo);
        this.prefHook((Control)this._localeCombo);
        Group gLeft = new Group(comp, 0);
        gLeft.setLayout((Layout)new GridLayout(1, true));
        gLeft.setText("Styles and Options");
        gLeft.setLayoutData((Object)new GridData(768));
        Composite flagComp1 = new Composite((Composite)gLeft, 0);
        GridLayout gl1 = new GridLayout(1, true);
        gl1.marginWidth = 0;
        flagComp1.setLayout((Layout)gl1);
        this._scrollCombo = new Combo(flagComp1, 8);
        this._scrollCombo.add("No H Scrollbar (H_SCROLL_NONE)");
        this._scrollCombo.add("Fixed H Scrollbar (H_SCROLL_FIXED)");
        this._scrollCombo.add("Infinite H Scrollbar (H_SCROLL_INFINITE)");
        this._scrollCombo.select(1);
        this._scrollCombo.setData(KEY, (Object)"scrollCombo");
        this.prefLoad((Control)this._scrollCombo);
        this.prefHook((Control)this._scrollCombo);
        this._selCombo = new Combo(flagComp1, 8);
        this._selCombo.add("Single select (SWT.SINGLE)");
        this._selCombo.add("Multi select (SWT.MULTI)");
        this._selCombo.select(1);
        this._selCombo.setData(KEY, (Object)"selCombo");
        this.prefLoad((Control)this._selCombo);
        this.prefHook((Control)this._selCombo);
        this._vDNDCombo = new Combo(flagComp1, 8);
        this._vDNDCombo.add("Vertical DND - Off");
        this._vDNDCombo.add("Vertical DND - Any");
        this._vDNDCombo.add("Vertical DND - Between Sections Only");
        this._vDNDCombo.select(1);
        this._vDNDCombo.setData(KEY, (Object)"vDNDCombo");
        this.prefLoad((Control)this._vDNDCombo);
        this.prefHook((Control)this._vDNDCombo);
        this._bIncreaseDates = new Button((Composite)gLeft, 32);
        this._bIncreaseDates.setText("Increase Dates");
        this._bIncreaseDates.setSelection(true);
        this._bIncreaseDates.setToolTipText("Automatically increases the date for each subesquently created event");
        this._bIncreaseDates.setData(KEY, (Object)"bIncreaseDates");
        this.prefLoad((Control)this._bIncreaseDates);
        this.prefHook((Control)this._bIncreaseDates);
        this._bCreatePlannedDates = new Button((Composite)gLeft, 32);
        this._bCreatePlannedDates.setText("Create Planned Dates");
        this._bCreatePlannedDates.setSelection(true);
        this._bCreatePlannedDates.setToolTipText("Creates planned dates for each event");
        this._bCreatePlannedDates.setData(KEY, (Object)"bCreatePlannedDates");
        this.prefLoad((Control)this._bCreatePlannedDates);
        this.prefHook((Control)this._bCreatePlannedDates);
        this._bDrawHorizontalLines = new Button((Composite)gLeft, 32);
        this._bDrawHorizontalLines.setText("Draw Horizontal Event Divider Lines");
        this._bDrawHorizontalLines.setToolTipText("Draws horizontal lines between events at the location of the height of the row where the event lives");
        this._bDrawHorizontalLines.setData(KEY, (Object)"bDrawHorizontalLines");
        this.prefLoad((Control)this._bDrawHorizontalLines);
        this.prefHook((Control)this._bDrawHorizontalLines);
        Group sections = new Group((Composite)gLeft, 0);
        sections.setText("Use GanttSections");
        GridLayout sectionLayout = new GridLayout(2, true);
        sections.setLayout((Layout)sectionLayout);
        this._bUseSections = new Button((Composite)sections, 32);
        this._bUseSections.setText("Use GanttSections");
        this._bUseSections.setData(KEY, (Object)"bUseSections");
        this._bUseSections.setSelection(true);
        this.prefLoad((Control)this._bUseSections);
        this.prefHook((Control)this._bUseSections);
        GridData oneRow = new GridData();
        oneRow.horizontalSpan = 2;
        this._bUseSections.setLayoutData((Object)oneRow);
        this._bUseSectionsLeft = new Button((Composite)sections, 16);
        this._bUseSectionsLeft.setText("Left Side");
        this._bUseSectionsLeft.setToolTipText("Creates the section bar on the left");
        this._bUseSectionsLeft.setSelection(true);
        this._bUseSectionsLeft.setData(KEY, (Object)"bUseSectionsLeft");
        this.prefLoad((Control)this._bUseSectionsLeft);
        this.prefHook((Control)this._bUseSectionsLeft);
        this._bUseSectionsRight = new Button((Composite)sections, 16);
        this._bUseSectionsRight.setText("Right Side");
        this._bUseSectionsRight.setToolTipText("Creates the section bar on the right");
        this._bUseSectionsRight.setData(KEY, (Object)"bUseSectionsRight");
        this.prefLoad((Control)this._bUseSectionsRight);
        this.prefHook((Control)this._bUseSectionsRight);
        Label lMaxSections = new Label((Composite)gLeft, 16384);
        lMaxSections.setText("Max number of sections (0 = infinite)");
        this._sMaxSections = new Spinner((Composite)gLeft, 2048);
        this._bRandomEventLength = new Button((Composite)gLeft, 32);
        this._bRandomEventLength.setText("Random event length (+2-10 days)");
        this._bRandomEventLength.setToolTipText("Makes events take a random length");
        this._bRandomEventLength.setData(KEY, (Object)"bRandomEventLength");
        this.prefLoad((Control)this._bRandomEventLength);
        this.prefHook((Control)this._bRandomEventLength);
        this._bConnectEvents = new Button((Composite)gLeft, 32);
        this._bConnectEvents.setText("Connect events");
        this._bConnectEvents.setSelection(true);
        this._bConnectEvents.setText("Connects events up to the number defined in the spinner below");
        this._bConnectEvents.setData(KEY, (Object)"bConnectEvents");
        this.prefLoad((Control)this._bConnectEvents);
        this.prefHook((Control)this._bConnectEvents);
        this._sConnectionCountNumber = new Spinner((Composite)gLeft, 2048);
        this._sConnectionCountNumber.setSelection(50);
        this._sConnectionCountNumber.setMaximum(10000);
        this._sConnectionCountNumber.setToolTipText("Number of events that should be connected\n(Very large numbers is not suggested)");
        this._sConnectionCountNumber.setData(KEY, (Object)"sConnectionCountNumber");
        this.prefLoad((Control)this._sConnectionCountNumber);
        this.prefHook((Control)this._sConnectionCountNumber);
        this._bRandomColors = new Button((Composite)gLeft, 32);
        this._bRandomColors.setText("Random Connection Colors");
        this._bRandomColors.setToolTipText("Uses random colors for connecting events");
        this._bRandomColors.setData(KEY, (Object)"bRandomColors");
        this.prefLoad((Control)this._bRandomColors);
        this.prefHook((Control)this._bRandomColors);
        this._bRandomEventColors = new Button((Composite)gLeft, 32);
        this._bRandomEventColors.setText("Random Event Colors");
        this._bRandomEventColors.setToolTipText("Uses random colors for filling events");
        this._bRandomEventColors.setData(KEY, (Object)"bRandomEventColors");
        this.prefLoad((Control)this._bRandomEventColors);
        this.prefHook((Control)this._bRandomEventColors);
        this._bDNDLimits = new Button((Composite)gLeft, 32);
        this._bDNDLimits.setText("Random Date Range Limitations");
        this._bDNDLimits.setSelection(true);
        this._bDNDLimits.setToolTipText("Creates limits that dates cannot be resized/dragged beyond");
        this._bDNDLimits.setData(KEY, (Object)"bDNDLimits");
        this.prefLoad((Control)this._bDNDLimits);
        this.prefHook((Control)this._bDNDLimits);
        this._bRandomPercentCompletes = new Button((Composite)gLeft, 32);
        this._bRandomPercentCompletes.setText("Random Percent Completes");
        this._bRandomPercentCompletes.setToolTipText("Creates random percent completes from 0 to 100 on each event");
        this._bRandomPercentCompletes.setSelection(true);
        this._bRandomPercentCompletes.setData(KEY, (Object)"bRandomPercentCompletes");
        this.prefLoad((Control)this._bRandomPercentCompletes);
        this.prefHook((Control)this._bRandomPercentCompletes);
        this._bGanttPhases = new Button((Composite)gLeft, 32);
        this._bGanttPhases.setText("Gantt Phases");
        this._bGanttPhases.setToolTipText("Creates some GanttPhase examples");
        this._bGanttPhases.setSelection(true);
        this._bGanttPhases.setData(KEY, (Object)"bGanttPhases");
        this.prefLoad((Control)this._bGanttPhases);
        this.prefHook((Control)this._bGanttPhases);
        this._bSpecialDateRange = new Button((Composite)gLeft, 32);
        this._bSpecialDateRange.setText("Special Date Range (random colors)");
        this._bSpecialDateRange.setToolTipText("Creates one Special Date Range as Example (with random colors)");
        this._bSpecialDateRange.setSelection(false);
        this._bSpecialDateRange.setData(KEY, (Object)"bSpecialDateRange");
        this.prefLoad((Control)this._bSpecialDateRange);
        this.prefHook((Control)this._bSpecialDateRange);
        this._bRandomImage = new Button((Composite)gLeft, 32);
        this._bRandomImage.setText("Random Images");
        this._bRandomImage.setToolTipText("Create some events with image");
        this._bRandomImage.setSelection(false);
        this._bRandomImage.setData(KEY, (Object)"bRandomImage");
        this.prefLoad((Control)this._bRandomImage);
        this.prefHook((Control)this._bRandomImage);
        Group internal = new Group((Composite)gLeft, 32);
        internal.setLayout((Layout)new GridLayout(1, false));
        this._bRandomRowHeights = new Button((Composite)internal, 32);
        this._bRandomRowHeights.setText("Random Row Heights (rowHeight to 100)");
        this._bRandomRowHeights.setToolTipText("Creates random row heights for each event between the range of [defaultEventHeight] to 100");
        this._bRandomRowHeights.setData(KEY, (Object)"bRandomRowHeights");
        this.prefLoad((Control)this._bRandomRowHeights);
        this.prefHook((Control)this._bRandomRowHeights);
        this._bRandomEventVLoc = new Button((Composite)internal, 32);
        this._bRandomEventVLoc.setText("Random Event Vertical Location");
        this._bRandomEventVLoc.setToolTipText("Creates random location for each event one of (SWT.TOP, SWT.CENTER, SWT.BOTTOM)");
        this._bRandomEventVLoc.setEnabled(false);
        this._bRandomEventVLoc.setData(KEY, (Object)"bRandomEventVLoc");
        this.prefLoad((Control)this._bRandomEventVLoc);
        this.prefHook((Control)this._bRandomEventVLoc);
        this._bRandomEventTextHLocation = new Button((Composite)internal, 32);
        this._bRandomEventTextHLocation.setText("Random Event Horizontal Text Location");
        this._bRandomEventTextHLocation.setToolTipText("Creates random event Text location for each event one of (SWT.LEFT, SWT.CENTER, SWT.RIGHT)");
        this._bRandomEventTextHLocation.setEnabled(false);
        this._bRandomEventTextHLocation.setData(KEY, (Object)"bRandomEventTextHLocation");
        this.prefLoad((Control)this._bRandomEventTextHLocation);
        this.prefHook((Control)this._bRandomEventTextHLocation);
        this._bRandomEventTextVLocation = new Button((Composite)internal, 32);
        this._bRandomEventTextVLocation.setText("Random Event Vertical Text Location");
        this._bRandomEventTextVLocation.setToolTipText("Creates random event Text location for each event one of (SWT.TOP, SWT.CENTER, SWT.BOTTOM)");
        this._bRandomEventTextVLocation.setEnabled(false);
        this._bRandomEventTextVLocation.setData(KEY, (Object)"bRandomEventTextVLocation");
        this.prefLoad((Control)this._bRandomEventTextVLocation);
        this.prefHook((Control)this._bRandomEventTextVLocation);
        this._bRandomRowHeights.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttTester.this._bRandomEventVLoc.setEnabled(GanttTester.this._bRandomRowHeights.getSelection());
                GanttTester.this._bRandomEventTextHLocation.setEnabled(GanttTester.this._bRandomRowHeights.getSelection());
                GanttTester.this._bRandomEventTextVLocation.setEnabled(GanttTester.this._bRandomRowHeights.getSelection());
            }
        });
        this._bUseDDay = new Button((Composite)gLeft, 32);
        this._bUseDDay.setText("D-Day chart");
        this._bUseDDay.setData(KEY, (Object)"bUseDDay");
        this.prefLoad((Control)this._bUseDDay);
        this.prefHook((Control)this._bUseDDay);
        this._bLockHeader = new Button((Composite)gLeft, 32);
        this._bLockHeader.setText("Lock Header");
        this._bLockHeader.setToolTipText("Locks the header so that it is always shown regardless of vertical scroll");
        this._bLockHeader.setData(KEY, (Object)"bLockHeader");
        this.prefLoad((Control)this._bLockHeader);
        this.prefHook((Control)this._bLockHeader);
        this._bMoveOnlyLaterLinkedEvents = new Button((Composite)gLeft, 32);
        this._bMoveOnlyLaterLinkedEvents.setSelection(true);
        this._bMoveOnlyLaterLinkedEvents.setText("Move/Resize Only 'Older' Linked Events");
        this._bMoveOnlyLaterLinkedEvents.setToolTipText("When moving/resizing linked events, this flag ensures that only older events than the ones being dragged are moved/resized");
        this._bMoveOnlyLaterLinkedEvents.setData(KEY, (Object)"bMoveOnlyLaterLinkedEvents");
        this.prefLoad((Control)this._bMoveOnlyLaterLinkedEvents);
        this.prefHook((Control)this._bMoveOnlyLaterLinkedEvents);
        this._bConnectEvents.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttTester.this._sConnectionCountNumber.setEnabled(GanttTester.this._bConnectEvents.getSelection());
                GanttTester.this._bRandomColors.setEnabled(GanttTester.this._bConnectEvents.getSelection());
            }
        });
        Group timerGroup = new Group(comp, 0);
        timerGroup.setLayout((Layout)new GridLayout(1, true));
        timerGroup.setLayoutData((Object)new GridData(768));
        timerGroup.setText("Redraw Stats");
        this._timerText = new Text((Composite)timerGroup, 2056);
        this._timerText.setBackground(Display.getDefault().getSystemColor(25));
        this._timerText.setLayoutData((Object)new GridData(768));
        this._undoRedoListener = new Listener(){

            public void handleEvent(Event event) {
                if ((event.stateMask & SWT.MOD1) != 0 && (event.keyCode == 122 || event.keyCode == 90)) {
                    GanttTester.this._ganttComposite.getUndoRedoManager().undo();
                }
                if ((event.stateMask & SWT.MOD1) != 0 && (event.keyCode == 121 || event.keyCode == 89)) {
                    GanttTester.this._ganttComposite.getUndoRedoManager().redo();
                }
            }
        };
        Display.getDefault().addFilter(1, this._undoRedoListener);
        return sc;
    }

    private void createButtonClicked() {
        long time1 = System.currentTimeMillis();
        this._ganttComposite.getVerticalBar().setPageIncrement(200);
        this._ganttComposite.getUndoRedoManager().clear();
        int numberEvents = 0;
        try {
            numberEvents = Integer.parseInt(this._eventCountCombo.getText());
        }
        catch (NumberFormatException nfe) {
            return;
        }
        this._ganttChart.dispose();
        int flags = 0;
        switch (this._scrollCombo.getSelectionIndex()) {
            case 0: {
                flags |= 0x20;
                break;
            }
            case 1: {
                flags |= 0x10;
                break;
            }
            case 2: {
                flags |= 8;
                break;
            }
        }
        switch (this._selCombo.getSelectionIndex()) {
            case 0: {
                flags |= 4;
                break;
            }
            case 1: {
                flags |= 2;
                break;
            }
        }
        IColorManager color = new ColorThemeWindowsBlue();
        if (this._themeCombo.getSelectionIndex() == 1) {
            color = new ColorThemeSilver();
        } else if (this._themeCombo.getSelectionIndex() == 2) {
            color = new ColorThemeGrayBlue();
        } else if (this._themeCombo.getSelectionIndex() == 3) {
            color = new ColorThemeHighContrastBlack();
        }
        TestSettings toUse = new TestSettings();
        this._ganttChart = new GanttChart((Composite)this._vfChart, flags, toUse, color);
        this._ganttComposite = this._ganttChart.getGanttComposite();
        this._ganttComposite.getUndoRedoManager().addUndoRedoListener(new UndoRedoListenerAdapter(){

            public void canRedoChanged(boolean canRedo) {
                GanttTester.this._bRedo.setEnabled(canRedo);
            }

            public void canUndoChanged(boolean canUndo) {
                GanttTester.this._bUndo.setEnabled(canUndo);
            }
        });
        this._vfChart.setContent((Control)this._ganttChart);
        this._ganttChart.addGanttEventListener(new IGanttEventListener(){

            public void eventDoubleClicked(GanttEvent event, MouseEvent me) {
                GanttTester.this.eventLog("Doubleclicked '" + event + "'");
                Shell shell = new Shell(Display.getDefault(), 82144);
                shell.setLocation(Display.getDefault().getBounds().width * 1 / 5, Display.getDefault().getBounds().height * 1 / 3);
                shell.setSize(350, 200);
                String dialogTitle = event.getName();
                shell.setText(dialogTitle);
                shell.open();
            }

            public void eventHeaderSelected(Calendar newlySelectedDate, List allSelectedDates) {
                GanttTester.this.eventLog("Header date selected: " + newlySelectedDate.getTime() + ". Now a total of " + allSelectedDates.size() + " header date(s) selected.");
            }

            public void eventMovedToNewSection(GanttEvent event, GanttSection oldSection, GanttSection newSection) {
                GanttTester.this.eventLog("Eveent'" + event + "' was moved from GanttSection '" + oldSection.getName() + "' to '" + newSection.getName() + "'");
            }

            public void eventPropertiesSelected(List events) {
                GanttTester.this.eventLog("Properties was selected on '" + events + "'");
            }

            public void eventReordered(GanttEvent event) {
                GanttTester.this.eventLog("Event '" + event + "' was reordered");
            }

            public void eventsDeleteRequest(List events, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Events '" + events + "' were requested to be deleted");
                for (int i = 0; i < events.size(); ++i) {
                    ((GanttEvent)events.get(i)).dispose();
                }
            }

            public void eventSelected(GanttEvent event, List allSelectedEvents, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Event '" + event + "' was selected. " + allSelectedEvents.size() + " event(s) are now selected in total.");
            }

            public void eventsMoved(List events, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Events '" + events + "' were moved");
            }

            public void eventsMoveFinished(List events, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Events '" + events + "' were finished moving");
            }

            public void eventsResized(List events, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Events '" + events + "' were resized");
            }

            public void eventsResizeFinished(List events, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Events '" + events + "' were finished resizing");
            }

            public void lastDraw(GC gc) {
            }

            public void phaseMoved(GanttPhase phase, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Phase '" + phase.getTitle() + "' was moved");
            }

            public void phaseMoveFinished(GanttPhase phase, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Phase '" + phase.getTitle() + "' finished moving");
            }

            public void phaseResized(GanttPhase phase, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Phase '" + phase.getTitle() + "' was resized");
            }

            public void phaseResizeFinished(GanttPhase phase, MouseEvent mouseEvent) {
                GanttTester.this.eventLog("Phase '" + phase.getTitle() + "' finished resizing");
            }

            public void zoomedIn(int newZoomLevel) {
                GanttTester.this.eventLog("Zoomed in, zoom level is now: " + newZoomLevel);
            }

            public void zoomedOut(int newZoomLevel) {
                GanttTester.this.eventLog("Zoomed out, zoom level is now: " + newZoomLevel);
            }

            public void zoomReset() {
                GanttTester.this.eventLog("Zoomed level was reset");
            }

            public void eventsDroppedOrResizedOntoUnallowedDateRange(List events, GanttSpecialDateRange range) {
                GanttTester.this.eventLog("Events '" + events + "' were dropped or resized over special range '" + range + "' that does not allow events on its dates");
            }
        });
        Random r = new Random();
        GanttSection parent = null;
        int sectionCount = 1;
        int lastSectionEventCount = 0;
        if (this._bUseSections.getSelection() && (this._bUseSectionsLeft.getSelection() || this._bUseSectionsRight.getSelection())) {
            parent = new GanttSection(this._ganttChart, "Section " + sectionCount);
        }
        if (this._bGanttPhases.getSelection()) {
            Calendar phaseRoot = Calendar.getInstance();
            if (this._bUseDDay.getSelection()) {
                phaseRoot = toUse.getDDayRootCalendar();
            }
            Calendar x = (Calendar)phaseRoot.clone();
            x.add(5, 10);
            new GanttPhase(this._ganttChart, phaseRoot, x, "Testing");
            x.add(5, 10);
            Calendar x2 = (Calendar)phaseRoot.clone();
            x2.add(5, 30);
            new GanttPhase(this._ganttChart, x, x2, "Something Much Longer");
        }
        if (this._bSpecialDateRange.getSelection()) {
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            if (this._bUseDDay.getSelection()) {
                start = (Calendar)toUse.getDDayRootCalendar().clone();
                end = (Calendar)toUse.getDDayRootCalendar().clone();
            }
            end.add(5, 50);
            GanttSpecialDateRange range = new GanttSpecialDateRange(this._ganttChart, start, end);
            range.setFrequency(this._bUseDDay.getSelection() ? 5 : 2);
            if (this._bUseDDay.getSelection()) {
                range.setDDayRepeatInterval(10);
            } else {
                range.addRecurDay(4);
            }
            range.setRecurCount(50);
            range.setBackgroundColorTop(ColorCache.getRandomColor());
            range.setBackgroundColorBottom(ColorCache.getRandomColor());
            if (this._bCreateSpecialRangesWithAllowNoEvents.getSelection()) {
                range.setAllowEventsOnDates(false);
            }
        }
        for (int i = 0; i < numberEvents; ++i) {
            Calendar cal = Calendar.getInstance();
            if (this._bUseDDay.getSelection()) {
                cal = (Calendar)toUse.getDDayRootCalendar().clone();
            }
            GanttEvent predEvent = null;
            if (i != 0) {
                predEvent = (GanttEvent)this._ganttComposite.getEvents().get(i - 1);
                cal = predEvent.getActualEndDate();
            }
            Calendar cStartDate = cal;
            if (this._bRandomEventLength.getSelection()) {
                cStartDate.add(5, r.nextInt(5));
            }
            Calendar cEndDate = (Calendar)cStartDate.clone();
            if (this._bIncreaseDates.getSelection()) {
                cEndDate.add(5, this._bRandomEventLength.getSelection() ? r.nextInt(10) + 1 : 1);
            }
            GanttEvent ganttEvent = null;
            if (this._bCreatePlannedDates.getSelection()) {
                Calendar plannedStart = (Calendar)cStartDate.clone();
                plannedStart.add(5, this._bRandomEventLength.getSelection() ? -(r.nextInt(10) + 1) : -10);
                Calendar plannedEnd = (Calendar)cEndDate.clone();
                plannedEnd.add(5, this._bRandomEventLength.getSelection() ? r.nextInt(10) + 1 : 10);
                ganttEvent = new GanttEvent(this._ganttChart, null, "Event " + (i + 1), plannedStart, plannedEnd, cStartDate, cEndDate, 0);
            } else {
                ganttEvent = new GanttEvent(this._ganttChart, null, "Event " + (i + 1), cStartDate, cEndDate, 0);
            }
            if (this._bRandomPercentCompletes.getSelection()) {
                ganttEvent.setPercentComplete(r.nextInt(100));
            }
            if (this._bUseSections.getSelection() && (this._bUseSectionsLeft.getSelection() || this._bUseSectionsRight.getSelection())) {
                boolean reachedMax = false;
                if (this._sMaxSections.getSelection() != 0) {
                    boolean bl = reachedMax = sectionCount >= this._sMaxSections.getSelection();
                }
                if (lastSectionEventCount != 0 && !reachedMax) {
                    if (r.nextInt(2) == 1) {
                        parent = new GanttSection(this._ganttChart, "Section " + ++sectionCount);
                        parent.addGanttEvent(ganttEvent);
                        lastSectionEventCount = 0;
                    } else {
                        parent.addGanttEvent(ganttEvent);
                        ++lastSectionEventCount;
                    }
                } else {
                    parent.addGanttEvent(ganttEvent);
                    ++lastSectionEventCount;
                }
            }
            if (this._bRandomEventColors.getSelection()) {
                ganttEvent.setStatusColor(ColorCache.getColor(r.nextInt(255), r.nextInt(255), r.nextInt(255)));
                ganttEvent.setGradientStatusColor(ColorCache.getColor(r.nextInt(255), r.nextInt(255), r.nextInt(255)));
            }
            if (this._bRandomRowHeights.getSelection()) {
                int height = r.nextInt(100);
                if (height < this._ganttChart.getSettings().getEventHeight()) {
                    height = this._ganttChart.getSettings().getEventHeight();
                }
                ganttEvent.setFixedRowHeight(height);
                if (this._bRandomEventTextHLocation.getSelection()) {
                    int loc = -1;
                    switch (r.nextInt(3)) {
                        case 0: {
                            loc = 16384;
                            break;
                        }
                        case 1: {
                            loc = 0x1000000;
                            break;
                        }
                        case 2: {
                            loc = 131072;
                            break;
                        }
                    }
                    ganttEvent.setHorizontalTextLocation(loc);
                }
                if (this._bRandomEventTextVLocation.getSelection()) {
                    int loc = -1;
                    switch (r.nextInt(3)) {
                        case 0: {
                            loc = 128;
                            break;
                        }
                        case 1: {
                            loc = 0x1000000;
                            break;
                        }
                        case 2: {
                            loc = 1024;
                            break;
                        }
                    }
                    ganttEvent.setVerticalTextLocation(loc);
                }
                if (this._bRandomEventVLoc.getSelection()) {
                    int loc = -1;
                    switch (r.nextInt(3)) {
                        case 0: {
                            loc = 128;
                            break;
                        }
                        case 1: {
                            loc = 0x1000000;
                            break;
                        }
                        case 2: {
                            loc = 1024;
                            break;
                        }
                    }
                    ganttEvent.setVerticalEventAlignment(loc);
                }
            }
            if (this._bRandomImage.getSelection() && r.nextInt(5) == 0) {
                PaletteData palette = new PaletteData(new RGB[]{Display.getDefault().getSystemColor(1).getRGB(), Display.getDefault().getSystemColor(9).getRGB()});
                ImageData sourceData = new ImageData(16, 16, 1, palette);
                sourceData.transparentPixel = 0;
                Image image = new Image((Device)Display.getDefault(), sourceData);
                Rectangle rect = image.getBounds();
                GC gc = new GC((Drawable)image);
                gc.setAntialias(1);
                gc.setBackground(Display.getDefault().getSystemColor(9));
                gc.fillOval(rect.x, rect.y, rect.width, rect.height);
                gc.dispose();
                ganttEvent.setImage(true);
                ganttEvent.setPicture(image);
                ganttEvent.setEndDate(ganttEvent.getStartDate());
            }
            if (this._bDNDLimits.getSelection()) {
                Calendar noBefore = Calendar.getInstance();
                noBefore.setTime(cStartDate.getTime());
                noBefore.add(5, -(r.nextInt(10) + 2));
                if (r.nextInt(2) == 1) {
                    ganttEvent.setNoMoveBeforeDate(noBefore);
                }
                Calendar noBeyond = Calendar.getInstance();
                noBeyond.setTime(cEndDate.getTime());
                noBeyond.add(5, r.nextInt(10) + 2);
                if (r.nextInt(2) == 1) {
                    ganttEvent.setNoMoveAfterDate(noBeyond);
                }
            }
            if (!this._bConnectEvents.getSelection() || i >= this._sConnectionCountNumber.getSelection()) continue;
            if (this._bRandomColors.getSelection()) {
                this._ganttComposite.addConnection(predEvent, ganttEvent, ColorCache.getColor(r.nextInt(255), r.nextInt(255), r.nextInt(255)));
                continue;
            }
            this._ganttComposite.addConnection(predEvent, ganttEvent);
        }
        long time2 = System.currentTimeMillis();
        this._timerText.setText("Initial chart creation took " + (time2 - time1) + " ms");
        this.eventLog("Initial chart creation took " + (time2 - time1) + " ms");
        this.moveFocus();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (GanttTester.this._ganttChart.isDisposed()) {
                    return;
                }
                GanttTester.this._ganttChart.getVerticalBar().setPageIncrement(350);
            }
        });
    }

    private void createCreateButtons(Composite parent) {
        Group buttons = new Group(parent, 0);
        buttons.setText("Any changes to above requires a new 'Create'");
        buttons.setLayout((Layout)new GridLayout(2, true));
        GridData buttonData = new GridData();
        buttonData.grabExcessHorizontalSpace = true;
        buttons.setLayoutData((Object)buttonData);
        this._bCreate = new Button((Composite)buttons, 8);
        this._bCreate.setText("&Create");
        this._bCreate.setLayoutData((Object)new GridData(768));
        this._bCreate.setToolTipText("Creates a new chart");
        this._bClear = new Button((Composite)buttons, 8);
        this._bClear.setText("Clear");
        this._bClear.setLayoutData((Object)new GridData(768));
        this._bClear.setToolTipText("Clears all events from the chart");
        this._bRedraw = new Button((Composite)buttons, 8);
        this._bRedraw.setText("Normal Redraw");
        this._bRedraw.setLayoutData((Object)new GridData(768));
        this._bRedraw.setToolTipText("Forces a normal redraw which the chart does whenever something minor has changed");
        this._bHeavyRedraw = new Button((Composite)buttons, 8);
        this._bHeavyRedraw.setText("Heavy Redraw");
        this._bHeavyRedraw.setToolTipText("You should never have to use a heavy redraw. If you need to because of something not doing what it is supposed to it is most likely a bug\n\nAlso note that the results of using this may not be the same as when the chart calls this method itself");
        this._bHeavyRedraw.setLayoutData((Object)new GridData(768));
        this._bSaveFull = new Button((Composite)buttons, 8);
        this._bSaveFull.setText("Save Full Image");
        this._bSaveFull.setToolTipText("Saves an image of the chart, the entire chart, and nothing but the chart");
        this._bSaveFull.setLayoutData((Object)new GridData(768));
        this._bSaveFull.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Image full = GanttTester.this._ganttComposite.getFullImage();
                FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                fd.setFilterExtensions(new String[]{".jpg"});
                fd.setFilterNames(new String[]{"JPG File"});
                fd.setFileName("img.jpg");
                String path = fd.open();
                if (path == null) {
                    return;
                }
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{full.getImageData()};
                imageLoader.save(path, 4);
            }
        });
        this._bHeavyRedraw.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                long time1 = System.currentTimeMillis();
                GanttTester.this._ganttComposite.heavyRedraw();
                long time2 = System.currentTimeMillis();
                GanttTester.this._timerText.setText("Heavy redraw took " + (time2 - time1) + " ms");
                GanttTester.this.eventLog("Heavy redraw took " + (time2 - time1) + " ms");
            }
        });
        this._bCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GanttTester.this.createButtonClicked();
            }
        });
        this._bClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GanttTester.this._ganttComposite.clearChart();
                GanttTester.this.moveFocus();
            }
        });
        this._bRedraw.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long time1 = System.currentTimeMillis();
                GanttTester.this._ganttComposite.refresh();
                long time2 = System.currentTimeMillis();
                GanttTester.this._timerText.setText("Redraw took " + (time2 - time1) + " ms");
                GanttTester.this.eventLog("Redraw took " + (time2 - time1) + " ms");
                GanttTester.this.moveFocus();
            }
        });
    }

    private void prefHook(final Control ctrl) {
        Object obj = ctrl.getData(KEY);
        if (obj == null) {
            System.err.println("Control " + ctrl + " does not have a key set on it!");
            return;
        }
        final String keyName = obj.toString();
        if (ctrl instanceof Spinner) {
            ((Spinner)ctrl).addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    GanttTester.this._prefs.putInt(keyName, ((Spinner)ctrl).getSelection());
                }
            });
        } else if (ctrl instanceof Button) {
            ((Button)ctrl).addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    GanttTester.this._prefs.put(keyName, ((Button)ctrl).getSelection() ? "true" : "false");
                }
            });
        } else if (ctrl instanceof Text) {
            ((Text)ctrl).addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    GanttTester.this._prefs.put(keyName, ((Text)ctrl).getText());
                }
            });
        } else if (ctrl instanceof Combo) {
            ((Combo)ctrl).addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    GanttTester.this._prefs.putInt(keyName, ((Combo)ctrl).getSelectionIndex());
                }
            });
        }
    }

    private void prefLoad(Control ctrl) {
        Object obj = ctrl.getData(KEY);
        if (obj == null) {
            return;
        }
        String keyName = obj.toString();
        if (ctrl instanceof Spinner) {
            int old = this._prefs.getInt(keyName, -1);
            if (old == -1) {
                return;
            }
            ((Spinner)ctrl).setSelection(old);
        } else if (ctrl instanceof Button) {
            String old = this._prefs.get(keyName, null);
            if (old == null) {
                return;
            }
            ((Button)ctrl).setSelection(Boolean.valueOf(old).booleanValue());
        } else if (ctrl instanceof Text) {
            String old = this._prefs.get(keyName, null);
            if (old == null) {
                return;
            }
            ((Text)ctrl).setText(old);
        } else if (ctrl instanceof Combo) {
            int old = this._prefs.getInt(keyName, -1);
            if (old == -1) {
                return;
            }
            ((Combo)ctrl).select(old);
        }
    }

    public int getVerticalDNDStyle() {
        switch (this._vDNDCombo.getSelectionIndex()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private Composite createBottom(Composite parent) {
        final ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        final Composite outer = new Composite((Composite)sc, 0);
        sc.setContent((Control)outer);
        outer.setLayout((Layout)new GridLayout(1, true));
        sc.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                sc.setMinSize(outer.computeSize(-1, -1));
            }
        });
        Group comp = new Group(outer, 0);
        comp.setText("Gantt Chart Operations");
        comp.setLayoutData((Object)new GridData(1808));
        comp.setLayout((Layout)new GridLayout(10, false));
        Button bJumpEarliest = new Button((Composite)comp, 8);
        bJumpEarliest.setText("Jump to earliest event");
        Button bJumpLatest = new Button((Composite)comp, 8);
        bJumpLatest.setText("Jump to latest event");
        Button bSelectFirstEvent = new Button((Composite)comp, 8);
        bSelectFirstEvent.setText("Show first event");
        Button bSelectMidEvent = new Button((Composite)comp, 8);
        bSelectMidEvent.setText("Show middle event");
        Button bSelectLastEvent = new Button((Composite)comp, 8);
        bSelectLastEvent.setText("Show last event");
        Button bJumpToCurrentTimeLeft = new Button((Composite)comp, 8);
        bJumpToCurrentTimeLeft.setText("Today [Left]");
        Button bJumpToCurrentTimeCenter = new Button((Composite)comp, 8);
        bJumpToCurrentTimeCenter.setText("Today [Center]");
        Button bJumpToCurrentTimeRight = new Button((Composite)comp, 8);
        bJumpToCurrentTimeRight.setText("Today [Right]");
        Button bMoveEventsLeft = new Button((Composite)comp, 8);
        bMoveEventsLeft.setText("Move -1");
        Button bMoveEventsRight = new Button((Composite)comp, 8);
        bMoveEventsRight.setText("Move +1");
        Button zIn = new Button((Composite)comp, 8);
        Button zOut = new Button((Composite)comp, 8);
        zIn.setText("Zoom In");
        zOut.setText("Zoom Out");
        Button bShowPlanned = new Button((Composite)comp, 8);
        bShowPlanned.setText("Toggle Planned Dates");
        Button bShowDays = new Button((Composite)comp, 8);
        bShowDays.setText("Toggle Dates On Events");
        Button bSetDate = new Button((Composite)comp, 8);
        bSetDate.setText("Set Date Randomly (+-10)");
        bSetDate.setToolTipText("Sets the date randomly to a date +-10 days from the leftmost date of the chart");
        this._bUndo = new Button((Composite)comp, 8);
        this._bUndo.setText("Undo (CTRL+z)");
        this._bUndo.setEnabled(false);
        this._bUndo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttTester.this._ganttComposite.getUndoRedoManager().undo();
                GanttTester.this.eventLog("Undo was pressed");
            }
        });
        this._bRedo = new Button((Composite)comp, 8);
        this._bRedo.setText("Redo (CTRL+y)");
        this._bRedo.setEnabled(false);
        this._bRedo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttTester.this._ganttComposite.getUndoRedoManager().redo();
                GanttTester.this.eventLog("Redo was pressed");
            }
        });
        bMoveEventsLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GanttTester.this.moveAllEvents(5, -1);
                GanttTester.this.moveFocus();
            }
        });
        bMoveEventsRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GanttTester.this.moveAllEvents(5, 1);
                GanttTester.this.moveFocus();
            }
        });
        bJumpEarliest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GanttTester.this._ganttComposite.jumpToEarliestEvent();
                GanttTester.this.moveFocus();
            }
        });
        bJumpLatest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GanttTester.this._ganttComposite.jumpToLatestEvent();
                GanttTester.this.moveFocus();
            }
        });
        bSelectFirstEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GanttTester.this._ganttComposite.getEvents().size() == 0) {
                    return;
                }
                GanttTester.this._ganttComposite.setTopItem((GanttEvent)GanttTester.this._ganttComposite.getEvents().get(0), 0x1000000);
                GanttTester.this.moveFocus();
            }
        });
        bSelectLastEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GanttTester.this._ganttComposite.getEvents().size() == 0) {
                    return;
                }
                GanttTester.this._ganttComposite.setTopItem((GanttEvent)GanttTester.this._ganttComposite.getEvents().get(GanttTester.this._ganttComposite.getEvents().size() - 1), 0x1000000);
                GanttTester.this.moveFocus();
            }
        });
        bSelectMidEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GanttTester.this._ganttComposite.getEvents().size() < 2) {
                    return;
                }
                GanttEvent ge = (GanttEvent)GanttTester.this._ganttComposite.getEvents().get(GanttTester.this._ganttComposite.getEvents().size() / 2);
                GanttTester.this._ganttComposite.setTopItem(ge, 0x1000000);
                GanttTester.this.moveFocus();
            }
        });
        bJumpToCurrentTimeLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar currentDate = Calendar.getInstance();
                GanttTester.this._ganttComposite.setDate(currentDate, 16384);
                GanttTester.this.moveFocus();
            }
        });
        bJumpToCurrentTimeCenter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar currentDate = Calendar.getInstance();
                GanttTester.this._ganttComposite.setDate(currentDate, 0x1000000);
                GanttTester.this.moveFocus();
            }
        });
        bJumpToCurrentTimeRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar currentDate = Calendar.getInstance();
                GanttTester.this._ganttComposite.setDate(currentDate, 131072);
                GanttTester.this.moveFocus();
            }
        });
        zIn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttTester.this._ganttComposite.zoomIn();
                GanttTester.this.moveFocus();
            }
        });
        zOut.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttTester.this._ganttComposite.zoomOut();
                GanttTester.this.moveFocus();
            }
        });
        bShowPlanned.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttTester.this._ganttComposite.setShowPlannedDates(!GanttTester.this._ganttComposite.isShowingPlannedDates());
                GanttTester.this.moveFocus();
            }
        });
        bShowDays.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttTester.this._ganttComposite.setShowDaysOnEvents(!GanttTester.this._ganttComposite.isShowingDaysOnEvents());
                GanttTester.this.moveFocus();
            }
        });
        bSetDate.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Calendar cal = GanttTester.this._ganttComposite.getDate();
                Random r = new Random();
                int add = r.nextInt(10) + 1;
                if (r.nextInt(2) == 1) {
                    add = -add;
                }
                cal.add(5, add);
                GanttTester.this._ganttComposite.setDate(cal);
                GanttTester.this.moveFocus();
            }
        });
        return sc;
    }

    private void moveAllEvents(int calendarObj, int amount) {
        if (amount == 0) {
            return;
        }
        List events = this._ganttComposite.getEvents();
        for (int i = 0; i < events.size(); ++i) {
            GanttEvent ge = (GanttEvent)events.get(i);
            Calendar start = ge.getActualStartDate();
            Calendar end = ge.getActualEndDate();
            if (amount > 0) {
                end.add(calendarObj, amount);
                start.add(calendarObj, amount);
                ge.setRevisedDates(start, end, 0x4000000);
            } else {
                start.add(calendarObj, amount);
                end.add(calendarObj, amount);
                ge.setRevisedDates(start, end, 0x2000000);
            }
            ge.update(false);
        }
        this._ganttComposite.heavyRedraw();
    }

    private void moveFocus() {
        this._ganttComposite.setFocus();
    }

    private Locale getSelectedLocale() {
        Locale[] all = Locale.getAvailableLocales();
        return all[this._localeCombo.getSelectionIndex()];
    }

    private void eventLog(String txt) {
        TableItem ti = new TableItem(this._tEventLog, 0, 0);
        ti.setText(txt);
        System.out.println(txt);
    }

    class TestSettings
    extends AbstractSettings {
        TestSettings() {
        }

        public boolean lockHeaderOnVerticalScroll() {
            return GanttTester.this._bLockHeader.getSelection();
        }

        public boolean drawHeader() {
            return true;
        }

        public int getSectionSide() {
            return GanttTester.this._bUseSectionsRight.getSelection() ? 131072 : 16384;
        }

        public boolean drawHorizontalLines() {
            return GanttTester.this._bDrawHorizontalLines.getSelection();
        }

        public int getVerticalEventDragging() {
            return GanttTester.this.getVerticalDNDStyle();
        }

        public int getInitialView() {
            if (GanttTester.this._bUseDDay.getSelection()) {
                return 5;
            }
            return super.getInitialView();
        }

        public boolean moveLinkedEventsWhenEventsAreMoved() {
            return true;
        }

        public boolean moveAndResizeOnlyDependentEventsThatAreLaterThanLinkedMoveEvent() {
            return true;
        }

        public Locale getDefaultLocale() {
            return GanttTester.this.getSelectedLocale();
        }

        public boolean enableAutoScroll() {
            return GanttTester.this._bEnableAutoScroll.getSelection();
        }

        public boolean enableResizing() {
            return GanttTester.this._bEventResizing.getSelection();
        }

        public boolean enableDragAndDrop() {
            return GanttTester.this._bEventDND.getSelection();
        }

        public boolean adjustForLetters() {
            return GanttTester.this._bAdjustForLetters.getSelection();
        }

        public int getArrowConnectionType() {
            switch (GanttTester.this._bConnectionLineStyle.getSelectionIndex()) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                default: {
                    return 3;
                }
                case 3: 
            }
            return 4;
        }

        public boolean showArrows() {
            return GanttTester.this._bShowArrows.getSelection();
        }

        public boolean showBoldScopeText() {
            return GanttTester.this._bShowBoldScopeText.getSelection();
        }

        public boolean showToolTips() {
            return GanttTester.this._bShowTooltips.getSelection();
        }

        public boolean showGradientEventBars() {
            return GanttTester.this._bShowGradientEventBars.getSelection();
        }

        public boolean showOnlyDependenciesForSelectedItems() {
            return GanttTester.this._bShowOnlyDependenciesForSelectedItems.getSelection();
        }

        public boolean showZoomLevelBox() {
            return GanttTester.this._bShowZoomLevelBox.getSelection();
        }

        public boolean allowBlankAreaDragAndDropToMoveDates() {
            return GanttTester.this._bAllowBlankAreaDragAndDropToMoveDates.getSelection();
        }

        public boolean flipBlankAreaDragDirection() {
            return GanttTester.this._bFlipBlankAreaDragDirection.getSelection();
        }

        public boolean drawSelectionMarkerAroundSelectedEvent() {
            return GanttTester.this._bDrawSelectionMarkerAroundSelectedEvent.getSelection();
        }

        public boolean allowCheckpointResizing() {
            return GanttTester.this._bAllowCheckpointResizing.getSelection();
        }

        public boolean startCalendarOnFirstDayOfWeek() {
            return GanttTester.this._bStartCalendarOnFirstDayOfWeek.getSelection();
        }

        public boolean enableZooming() {
            return GanttTester.this._bEnableZooming.getSelection();
        }

        public boolean drawFullPercentageBar() {
            return GanttTester.this._bDrawFullPercentageBar.getSelection();
        }

        public boolean getUseAdvancedTooltips() {
            return GanttTester.this._bShowAdvancedTooltips.getSelection();
        }

        public boolean drawLockedDateMarks() {
            return GanttTester.this._bDrawLockedDateMarks.getSelection();
        }

        public boolean showDateTipsOnScrolling() {
            return GanttTester.this._bShowDateTipsOnScrolling.getSelection();
        }

        public boolean zoomToMousePointerDateOnWheelZooming() {
            return GanttTester.this._bZoomToMousePointerDateOnWheelZooming.getSelection();
        }

        public boolean allowBlankAreaVerticalDragAndDropToMoveChart() {
            return GanttTester.this._bAllowVerticalBlankDnd.getSelection();
        }

        public boolean scaleImageToDayWidth() {
            return GanttTester.this._bScaleImageToDay.getSelection();
        }

        public boolean allowArrowKeysToScrollChart() {
            return GanttTester.this._bAllowArrowKeysToMoveChart.getSelection();
        }
    }
}

