/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.security;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.artixadmin.Caller;
import ru.ssa.artixadmin.SecurityObjectManager;
import ru.ssa.artixadmin.provider.security.SecurityObjectContentProvider;
import ru.ssa.artixadmin.provider.security.SecurityObjectLabelProvider;
import ru.ssa.artixadmin.provider.security.SecurityPermissionContentProvider;
import ru.ssa.artixadmin.provider.security.SecurityPermissionLabelProvider;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.repository.SecurityObjectRepository;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.converter.StringToTrimStringConverter;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.validator.JSR303Validator;

@SecurityKey(title="\u0420\u043e\u043b\u0438 \u0438 \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u044c")
public class SecurityRoleEditPanel
extends EditorComposite<SecurityRole> {
    private static final Logger log = LoggerFactory.getLogger(SecurityRoleEditPanel.class);
    @SecurityKey(title="\u0414\u0435\u0440\u0435\u0432\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043f\u0440\u0430\u0432", id="treeChosen")
    private FilteredTree treeViewerChosenRights;
    @SecurityKey(title="\u0414\u0435\u0440\u0435\u0432\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043f\u0440\u0430\u0432", id="treeAvailable")
    private FilteredTree treeViewerAvailableRights;
    private Set<SecurityObject> availableRights = new HashSet<SecurityObject>();
    private Set<SecurityPermission> chosenRights = new HashSet<SecurityPermission>();
    @SecurityKey(title="\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", id="eread")
    private Button rereadSecurityObjectButton;
    @SecurityKey(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u043e\u043b\u0438", id="login")
    private Label labelLogin;
    @SecurityKey(id="login")
    private Text name;
    @SecurityKey(title="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u043e\u043b\u044c", id="addToRole")
    private Button addToRole;
    @SecurityKey(title="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u043e\u043b\u044c", id="delToRole")
    private Button delToRole;
    @SecurityKey(title="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0441\u0435 \u0440\u043e\u043b\u0438", id="addAllToRole")
    private Button addAllToRole;
    @SecurityKey(title="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0440\u043e\u043b\u0438", id="delAllToRole")
    private Button delAllToRole;

    public SecurityRoleEditPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public SecurityRoleEditPanel(Composite parent, int style, SecurityRole model) {
        super(parent, style, SecurityRole.class, (Object)model);
        this.readRights(model);
    }

    private void readRights(SecurityRole model) {
        SecurityObjectRepository securityObjectRepository = ArtixAdminActivator.getDefault().getBeanByClass(SecurityObjectRepository.class);
        SecurityRole withPermissions = (SecurityRole)ModelActivator.getDefault().getModelProvider().getDirectoryModel(SecurityRole.class).getById((Object)model.getName());
        this.availableRights.addAll(securityObjectRepository.findAll());
        if (withPermissions != null) {
            this.chosenRights.addAll(withPermissions.getPermissions());
        }
        for (SecurityPermission permission : this.chosenRights) {
            if (permission == null || permission.getSecurityObject() == null || permission.getSecurityObject().getParent() == null || permission.getSecurityObject().getParent().getId().equals("su.artix.yuki.editors.EditorComposite")) continue;
            log.trace("remove right:{}", (Object)permission.getSecurityObject());
            this.availableRights.remove(permission.getSecurityObject());
        }
        ArrayList<SecurityObject> removeSecurityObjects = new ArrayList<SecurityObject>();
        for (SecurityObject object : this.availableRights) {
            if (!this.permissionsContainsSecurityObject(object)) continue;
            removeSecurityObjects.add(object);
        }
        this.availableRights.removeAll(removeSecurityObjects);
        ArrayList<SecurityObject> addSecurityObjects = new ArrayList<SecurityObject>();
        for (SecurityObject object : this.availableRights) {
            if (object.getParent() == null || addSecurityObjects.contains(object.getParent()) || this.availableRights.contains(object.getParent())) continue;
            addSecurityObjects.add(object.getParent());
        }
        this.availableRights.addAll(addSecurityObjects);
    }

    private boolean permissionsContainsSecurityObject(SecurityObject securityObject) {
        for (SecurityPermission permission : this.chosenRights) {
            if (permission == null || permission.getSecurityObject() == null || !permission.getSecurityObject().equals((Object)securityObject) || permission.getSecurityObject().getParent() == null) continue;
            return true;
        }
        return false;
    }

    private void fillChildSecurityObjects(List<SecurityObject> childSecurityObjects, SecurityObject parentObject) {
        for (SecurityObject object : this.availableRights) {
            if (object.getParent() == null || !object.getParent().equals((Object)parentObject)) continue;
            childSecurityObjects.add(object);
            this.fillChildSecurityObjects(childSecurityObjects, object);
        }
    }

    private List<SecurityObject> getChildSecurityObjects(SecurityObject parentObject) {
        ArrayList<SecurityObject> childSecurityObjects = new ArrayList<SecurityObject>();
        this.fillChildSecurityObjects(childSecurityObjects, parentObject);
        return childSecurityObjects;
    }

    private boolean hasChildSecurityObjects(SecurityObject parentObject) {
        for (SecurityObject object : this.availableRights) {
            if (object.getParent() == null || !object.getParent().equals((Object)parentObject)) continue;
            return true;
        }
        return false;
    }

    private void moveParentSecurityObjects(SecurityObject securityObject) {
        if (securityObject.getParent() != null) {
            this.chosenRights.add(new SecurityPermission(securityObject.getParent(), Integer.valueOf(0)));
            if (!this.hasChildSecurityObjects(securityObject.getParent())) {
                this.availableRights.remove(securityObject.getParent());
            }
            this.moveParentSecurityObjects(securityObject.getParent());
        }
    }

    private void fillChildSecurityPermissions(List<SecurityPermission> childSecurityPermissions, SecurityObject parentObject) {
        for (SecurityPermission object : this.chosenRights) {
            if (object.getSecurityObject() == null || object.getSecurityObject().getParent() == null || !object.getSecurityObject().getParent().equals((Object)parentObject)) continue;
            childSecurityPermissions.add(object);
            this.fillChildSecurityPermissions(childSecurityPermissions, object.getSecurityObject());
        }
    }

    private List<SecurityPermission> getChildSecurityPermissions(SecurityObject parentObject) {
        ArrayList<SecurityPermission> childSecurityPermissions = new ArrayList<SecurityPermission>();
        this.fillChildSecurityPermissions(childSecurityPermissions, parentObject);
        return childSecurityPermissions;
    }

    private boolean hasChildSecurityPermissions(SecurityObject parentObject) {
        for (SecurityPermission object : this.chosenRights) {
            if (object.getSecurityObject() == null || object.getSecurityObject().getParent() == null || !object.getSecurityObject().getParent().equals((Object)parentObject)) continue;
            return true;
        }
        return false;
    }

    private void moveParentSecurityPermissions(SecurityObject securityObject) {
        if (securityObject.getParent() != null) {
            this.availableRights.add(securityObject.getParent());
            if (!this.hasChildSecurityPermissions(securityObject.getParent())) {
                this.chosenRights.removeAll(Arrays.asList(new SecurityPermission(securityObject.getParent(), Integer.valueOf(0)), new SecurityPermission(securityObject.getParent(), Integer.valueOf(1)), new SecurityPermission(securityObject.getParent(), Integer.valueOf(2))));
            }
            this.moveParentSecurityPermissions(securityObject.getParent());
        }
    }

    private void moveSelectionPermission(IStructuredSelection selection) {
        if (selection.getFirstElement() != null) {
            if (selection.getFirstElement() instanceof SecurityObject) {
                SecurityObject securityObject = (SecurityObject)selection.getFirstElement();
                this.chosenRights.add(new SecurityPermission(securityObject, Integer.valueOf(0)));
                this.availableRights.remove(securityObject);
                this.moveParentSecurityObjects(securityObject);
                for (SecurityObject object : this.getChildSecurityObjects(securityObject)) {
                    this.chosenRights.add(new SecurityPermission(object, Integer.valueOf(0)));
                    this.availableRights.remove(object);
                }
            } else if (selection.getFirstElement() instanceof SecurityPermission) {
                SecurityPermission securityPermission = (SecurityPermission)selection.getFirstElement();
                this.availableRights.add(securityPermission.getSecurityObject());
                this.chosenRights.remove(securityPermission);
                this.moveParentSecurityPermissions(securityPermission.getSecurityObject());
                for (SecurityPermission permission : this.getChildSecurityPermissions(securityPermission.getSecurityObject())) {
                    this.chosenRights.remove(permission);
                    this.availableRights.add(permission.getSecurityObject());
                }
            }
            ((SecurityRole)this.getModel()).setPermissions(new ArrayList<SecurityPermission>(this.chosenRights));
            this.treeViewerChosenRights.getViewer().refresh();
            this.treeViewerAvailableRights.getViewer().refresh();
        }
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        this.rereadSecurityObjectButton = new Button((Composite)this, 8);
        this.rereadSecurityObjectButton.setText("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043f\u0440\u0430\u0432");
        final String connectionId = ArtixAdminContextHolder.getConnectionId();
        final IRunnableWithProgress updateRole = new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ArtixAdminContextHolder.setConnectionId((String)connectionId);
                monitor.beginTask("\u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0435\u0440\u0435\u0432\u043e \u043f\u0440\u0430\u0432", 4000);
                ArtixAdminActivator.getDefault().getBeanByClass(SecurityObjectManager.class).persistAddSecurityObjects(new Caller(){

                    @Override
                    public void worked(int incrementAndGet) {
                        monitor.setTaskName("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 " + incrementAndGet + " \u0438\u0437 ~4000.");
                        monitor.worked(1);
                        log.info("update progress:{}", (Object)incrementAndGet);
                    }
                });
                SecurityRoleEditPanel.this.readRights((SecurityRole)SecurityRoleEditPanel.this.getModel());
                monitor.done();
            }
        };
        this.rereadSecurityObjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    new ProgressMonitorDialog(SecurityRoleEditPanel.this.getShell()).run(true, false, updateRole);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                SecurityRoleEditPanel.this.treeViewerAvailableRights.getViewer().setInput((Object)SecurityRoleEditPanel.this.availableRights);
                SecurityRoleEditPanel.this.treeViewerAvailableRights.getViewer().refresh();
                super.widgetSelected(event);
            }
        });
        Composite nameComposit = new Composite((Composite)this, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(nameComposit);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(3, 1).applyTo((Control)nameComposit);
        this.labelLogin = new Label(nameComposit, 0);
        this.labelLogin.setText("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u043e\u043b\u0438:");
        this.name = new Text(nameComposit, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.name.setTextLimit(200);
        Label availableRightsLabel = new Label((Composite)this, 0);
        availableRightsLabel.setText("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u043e\u043b\u044f:");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)availableRightsLabel);
        Label chosenRightsLabel = new Label((Composite)this, 0);
        chosenRightsLabel.setText("\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u044f:");
        GridDataFactory.fillDefaults().applyTo((Control)chosenRightsLabel);
        this.treeViewerAvailableRights = new FilteredTree((Composite)this, 67584, new PatternFilter(), true);
        this.treeViewerAvailableRights.getViewer().setContentProvider((IContentProvider)new SecurityObjectContentProvider());
        this.treeViewerAvailableRights.getViewer().setLabelProvider((IBaseLabelProvider)new SecurityObjectLabelProvider());
        this.treeViewerAvailableRights.getViewer().setInput(this.availableRights);
        Tree availableTree = this.treeViewerAvailableRights.getViewer().getTree();
        availableTree.setLinesVisible(true);
        availableTree.setHeaderVisible(true);
        TreeColumn column = new TreeColumn(availableTree, 16384);
        column.setText("\u042d\u043b\u0435\u043c\u0435\u043d\u0442");
        column.setWidth(220);
        availableTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeColumn column3 = new TreeColumn(availableTree, 16384);
        column3.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        column3.setWidth(200);
        this.treeViewerAvailableRights.getViewer().refresh();
        Composite buttonGroup = new Composite((Composite)this, 0);
        GridLayoutFactory.swtDefaults().applyTo(buttonGroup);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)buttonGroup);
        this.addToRole = new Button(buttonGroup, 8);
        this.addToRole.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_right").createImage());
        this.addToRole.setToolTipText("\u041d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u043e");
        this.addToRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SecurityRoleEditPanel.this.treeViewerAvailableRights.getViewer().getSelection();
                SecurityRoleEditPanel.this.moveSelectionPermission(selection);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.addToRole);
        this.delToRole = new Button(buttonGroup, 8);
        this.delToRole.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_left").createImage());
        this.delToRole.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u043e");
        this.delToRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SecurityRoleEditPanel.this.treeViewerChosenRights.getViewer().getSelection();
                SecurityRoleEditPanel.this.moveSelectionPermission(selection);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.delToRole);
        this.addAllToRole = new Button(buttonGroup, 8);
        this.addAllToRole.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_right2").createImage());
        this.addAllToRole.setToolTipText("\u041d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u0432\u0441\u0435 \u043f\u0440\u0430\u0432\u0430");
        this.addAllToRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (SecurityObject securityObject : SecurityRoleEditPanel.this.availableRights) {
                    SecurityRoleEditPanel.this.chosenRights.add(new SecurityPermission(securityObject, Integer.valueOf(0)));
                }
                SecurityRoleEditPanel.this.availableRights.clear();
                ((SecurityRole)SecurityRoleEditPanel.this.getModel()).setPermissions(new ArrayList(SecurityRoleEditPanel.this.chosenRights));
                SecurityRoleEditPanel.this.treeViewerChosenRights.getViewer().refresh();
                SecurityRoleEditPanel.this.treeViewerAvailableRights.getViewer().refresh();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.addAllToRole);
        this.delAllToRole = new Button(buttonGroup, 8);
        this.delAllToRole.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_left2").createImage());
        this.delAllToRole.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u043f\u0440\u0430\u0432\u0430");
        this.delAllToRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (SecurityPermission securityPermission : SecurityRoleEditPanel.this.chosenRights) {
                    SecurityRoleEditPanel.this.availableRights.add(securityPermission.getSecurityObject());
                }
                SecurityRoleEditPanel.this.chosenRights.clear();
                ((SecurityRole)SecurityRoleEditPanel.this.getModel()).setPermissions(new ArrayList(SecurityRoleEditPanel.this.chosenRights));
                SecurityRoleEditPanel.this.treeViewerChosenRights.getViewer().refresh();
                SecurityRoleEditPanel.this.treeViewerAvailableRights.getViewer().refresh();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.delAllToRole);
        this.treeViewerChosenRights = new FilteredTree((Composite)this, 67584, new PatternFilter(), true);
        this.treeViewerChosenRights.getViewer().setContentProvider((IContentProvider)new SecurityPermissionContentProvider(this.chosenRights));
        this.treeViewerChosenRights.getViewer().setLabelProvider((IBaseLabelProvider)new SecurityPermissionLabelProvider());
        this.treeViewerChosenRights.getViewer().setInput(this.chosenRights);
        Tree chosenTree = this.treeViewerChosenRights.getViewer().getTree();
        chosenTree.setLinesVisible(true);
        chosenTree.setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(chosenTree, 16384);
        column1.setText("\u042d\u043b\u0435\u043c\u0435\u043d\u0442");
        column1.setWidth(200);
        TreeColumn column4 = new TreeColumn(chosenTree, 16384);
        column4.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        column4.setWidth(150);
        TreeColumn column2 = new TreeColumn(chosenTree, 131072);
        column2.setText("\u041f\u0440\u0430\u0432\u043e");
        column2.setWidth(100);
        this.treeViewerChosenRights.getViewer().setColumnProperties(new String[]{"0", "0", "1"});
        this.treeViewerChosenRights.getViewer().setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                SecurityPermission elem;
                if (((TreeItem)element).getData() instanceof SecurityPermission && (elem = (SecurityPermission)((TreeItem)element).getData()).getSecurityObject().getParent() != null) {
                    int right = 0;
                    if (elem.getPermission() == 0) {
                        right = 1;
                    } else if (elem.getPermission() == 1) {
                        right = 2;
                    }
                    SecurityRoleEditPanel.this.chosenRights.remove(elem);
                    elem.setPermission(Integer.valueOf(right));
                    SecurityRoleEditPanel.this.chosenRights.add(elem);
                    ((SecurityRole)SecurityRoleEditPanel.this.getModel()).setPermissions(new ArrayList(SecurityRoleEditPanel.this.chosenRights));
                    SecurityRoleEditPanel.this.treeViewerChosenRights.getViewer().refresh();
                }
            }

            public Object getValue(Object element, String property) {
                if (property.equals("0")) {
                    return "";
                }
                return true;
            }

            public boolean canModify(Object element, String property) {
                return property.equals("1");
            }
        });
        this.treeViewerChosenRights.getViewer().setCellEditors(new CellEditor[]{new TextCellEditor((Composite)chosenTree), new TextCellEditor((Composite)chosenTree), new CheckboxCellEditor((Composite)chosenTree)});
        this.treeViewerChosenRights.getViewer().refresh();
        chosenTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    public void bindValues() {
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeText((Control)this.name, (int)24), this.getDetailValue("name"), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new JSR303Validator((Object)((SecurityRole)this.getModel()), "name", (Control)this.name, this.getValidatorListener())).setConverter((IConverter)new StringToTrimStringConverter()), null);
    }
}

