/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.domain.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateParser {
    private static final String DEFAULT_FORMAT = "dd.MM.yyyy HH:mm:ss";

    private DateParser() {
    }

    public static String dateToString(Date date) {
        return DateParser.dateToString(date, DEFAULT_FORMAT);
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        if (date != null) {
            return dateFormat.format(date);
        }
        return "";
    }

    public static Date stringToDate(String date) throws ParseException {
        return DateParser.stringToDate(date, DEFAULT_FORMAT);
    }

    public static Date stringToDate(String date, String format) throws ParseException {
        if (date != null && !date.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            return dateFormat.parse(date);
        }
        return new Date();
    }

    public static Date max(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return null;
        }
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1.after(d2) ? d1 : d2;
    }
}

