/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.binding;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.nebula.widgets.formattedtext.FormattedTextObservableValue;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.ActualClassResolver;
import ru.ssa.cashadmin.LibActivator;
import su.artix.cashserver.security.SecurityKey;
import su.artix.widgets.BitCheckGroup;
import su.artix.widgets.ComboBoxWithEmptyBox;
import su.artix.widgets.DateTimeAndTimeWithEmpyBox;
import su.artix.widgets.DateTimeWithEmpyBox;
import su.artix.widgets.ListCheckGroup;
import su.artix.widgets.SetStringCheckGroup;
import su.artix.widgets.SpinnerWithCheckBox;
import su.artix.widgets.TextWithClearButton;
import su.artix.widgets.TimeWithEmpyBox;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.binding.ComponentMetaData;
import su.artix.yuki.binding.ModelType;
import su.artix.yuki.binding.ToCurrentDateTimeFieldConverter;
import su.artix.yuki.binding.ToDefaultComboBoxFieldConverter;
import su.artix.yuki.binding.ToDefaultIntegerConverter;
import su.artix.yuki.converter.Base64ToImageConverter;
import su.artix.yuki.converter.BigDecimalToIntegerConverter;
import su.artix.yuki.converter.IntegerToBigDecimalConverter;
import su.artix.yuki.converter.IntegerToKeyValueConverter;
import su.artix.yuki.converter.IntegerToStringConverter;
import su.artix.yuki.converter.KeyValueToIntegerConverter;
import su.artix.yuki.converter.KeyValueToSetConverter;
import su.artix.yuki.converter.KeyValueToSexConverter;
import su.artix.yuki.converter.KeyValueToStringConverter;
import su.artix.yuki.converter.NullToBooleanConverter;
import su.artix.yuki.converter.NumberToBigDecimalConverter;
import su.artix.yuki.converter.SetToKeyValueConverter;
import su.artix.yuki.converter.SexToKeyValueConverter;
import su.artix.yuki.converter.StringToIntegerConverter;
import su.artix.yuki.converter.StringToKeyValueConverter;
import su.artix.yuki.converter.StringToTrimStringConverter;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.editors.utils.BitsCheckGroupProperty;
import su.artix.yuki.editors.utils.ListCheckGroupProperty;
import su.artix.yuki.editors.utils.SelectProperty;
import su.artix.yuki.editors.utils.SetStringCheckGroupProperty;
import su.artix.yuki.validator.DateTimeObservableValue;
import su.artix.yuki.validator.JSR303Validator;

public class ReflectionDataBinding<T> {
    private static final Logger log = LoggerFactory.getLogger(ReflectionDataBinding.class);
    private final DataBindingContext bindingContext;
    private Class<T> clazz;
    private final IObservableValue masterValue;
    private final T model;
    private PropertyChangeListener propertyChangeListener;
    private final int priceDigit = 2;
    private final int quantityDigit = 3;
    private final int alcoholDigit = 2;

    public ReflectionDataBinding(Class<T> clazz, T model, IObservableValue masterValue, DataBindingContext bindingContext, PropertyChangeListener propertyChangeListener) {
        this.clazz = clazz;
        this.model = model;
        this.masterValue = masterValue;
        this.bindingContext = bindingContext;
        this.propertyChangeListener = propertyChangeListener;
    }

    private ComponentMetaData getFieldMeta(Field f) {
        BindingKey ann;
        ComponentMetaData metaData = new ComponentMetaData();
        String id = null;
        if (f.isAnnotationPresent(BindingKey.class)) {
            BindingType bindingType;
            ann = f.getAnnotation(BindingKey.class);
            id = ann.id();
            String subFieldId = ann.subField();
            if (subFieldId != null && !subFieldId.isEmpty()) {
                metaData.setSubFieldId(ann.subField());
            }
            if ((bindingType = ann.bindingType()) == BindingType.PRICE) {
                metaData.setToConverter(new IntegerToBigDecimalConverter(2));
                metaData.setFromConverter(new BigDecimalToIntegerConverter(2));
            } else if (bindingType == BindingType.QUANTITY) {
                metaData.setToConverter(new IntegerToBigDecimalConverter(3));
                metaData.setFromConverter(new BigDecimalToIntegerConverter(3));
            } else if (bindingType == BindingType.ALCOHOL) {
                metaData.setToConverter(new IntegerToBigDecimalConverter(2));
                metaData.setFromConverter(new BigDecimalToIntegerConverter(2));
            } else if (bindingType == BindingType.SEX) {
                metaData.setToConverter(new SexToKeyValueConverter());
                metaData.setFromConverter(new KeyValueToSexConverter());
            } else if (bindingType == BindingType.DIRECTORY_LIST_INTEGER) {
                metaData.setToConverter(new IntegerToKeyValueConverter());
                metaData.setFromConverter(new KeyValueToIntegerConverter());
            } else if (bindingType == BindingType.DIRECTORY_LIST_STRING) {
                metaData.setToConverter(new StringToKeyValueConverter());
                metaData.setFromConverter(new KeyValueToStringConverter());
            } else if (bindingType == BindingType.STRING) {
                metaData.setToConverter(new IntegerToStringConverter());
                metaData.setFromConverter(new StringToIntegerConverter());
            } else if (bindingType == BindingType.IMAGE) {
                metaData.setFromConverter(new Base64ToImageConverter());
            } else if (bindingType == BindingType.DIRECTORY_LIST_SET) {
                metaData.setToConverter(new SetToKeyValueConverter());
                metaData.setFromConverter(new KeyValueToSetConverter());
            }
            metaData.setBindingType(bindingType);
            metaData.setInverseCheckBox(ann.inverseCheckBox());
            metaData.setModelType(ann.modelType());
            metaData.setIgnore(ann.ignore());
            metaData.setAutoChanged(ann.autoChanged());
        }
        if ((id == null || id.isEmpty()) && f.isAnnotationPresent(SecurityKey.class)) {
            ann = f.getAnnotation(SecurityKey.class);
            id = ann.id();
        }
        metaData.setFieldId(id);
        return metaData;
    }

    private IObservableValue getBindValue(Control inputControl, ComponentMetaData metaData) {
        IObservableValue observableValue = null;
        if (inputControl instanceof Spinner) {
            observableValue = this.getBindValue((Spinner)inputControl, metaData);
        } else if (inputControl instanceof Text) {
            observableValue = this.getBindValue((Text)inputControl, metaData);
        } else if (inputControl instanceof Button) {
            this.getBindValue((Button)inputControl, metaData);
        } else if (inputControl instanceof DateTime) {
            this.getBindValue((DateTime)inputControl, metaData);
        } else if (inputControl instanceof DateTimeWithEmpyBox) {
            this.getBindValue((DateTimeWithEmpyBox)inputControl, metaData);
        } else if (inputControl instanceof DateTimeAndTimeWithEmpyBox) {
            this.getBindValue((DateTimeAndTimeWithEmpyBox)inputControl, metaData);
        } else if (inputControl instanceof TimeWithEmpyBox) {
            this.getBindValue((TimeWithEmpyBox)inputControl, metaData);
        } else if (inputControl instanceof TextWithClearButton) {
            this.getBindValue((TextWithClearButton)inputControl, metaData);
        } else if (inputControl instanceof BitCheckGroup) {
            this.getBindValue((BitCheckGroup)inputControl, metaData);
        } else if (inputControl instanceof ListCheckGroup) {
            this.getBindValue((ListCheckGroup)inputControl, metaData);
        } else if (inputControl instanceof SetStringCheckGroup) {
            this.getBindValue((SetStringCheckGroup)inputControl, metaData);
        } else if (inputControl instanceof ComboBoxWithEmptyBox) {
            this.getBindValue((ComboBoxWithEmptyBox)inputControl, metaData);
        } else if (inputControl instanceof SpinnerWithCheckBox) {
            this.getBindValue((SpinnerWithCheckBox)inputControl, metaData);
        } else {
            String fieldId = metaData.getFieldId();
            log.warn("unknown binding {} field {}", (Object)inputControl.getClass().getSimpleName(), (Object)fieldId);
        }
        return observableValue;
    }

    private void getBindValue(ComboBoxWithEmptyBox control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        IObservableValue value = this.getDetailValue(fieldId);
        ComboViewer viewer = control.getComboBox();
        this.getBindingContext().bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)viewer), this.getDetailValue(fieldId, metaData.getModelType()), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, viewer.getControl(), this.propertyChangeListener)).setConverter(metaData.getFromConverter()), new UpdateValueStrategy().setConverter(metaData.getToConverter()));
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)control.getComboBox().getControl()), value, null, new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(false)));
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)control.getCheckBox()), value, new UpdateValueStrategy().setConverter((IConverter)new ToDefaultComboBoxFieldConverter(control.getComboBox(), metaData.isInverseCheckBox(), metaData.getToConverter().getFromType())).setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control.getCheckBox(), this.propertyChangeListener)), new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(!metaData.isInverseCheckBox())));
    }

    private void getBindValue(BitCheckGroup control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        this.getBindingContext().bindValue((IObservableValue)new BitsCheckGroupProperty().observe((Widget)control), this.getDetailValue(fieldId), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control, this.propertyChangeListener)), null);
    }

    private void getBindValue(ListCheckGroup control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        this.getBindingContext().bindValue((IObservableValue)new ListCheckGroupProperty().observe((Widget)control), this.getDetailValue(fieldId), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control, this.propertyChangeListener)), null);
    }

    private void getBindValue(SetStringCheckGroup control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        this.getBindingContext().bindValue((IObservableValue)new SetStringCheckGroupProperty().observe((Widget)control), this.getDetailValue(fieldId), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control, this.propertyChangeListener)), null);
    }

    private void getBindValue(TextWithClearButton inputControl, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        TextWithClearButton control = inputControl;
        ISWTObservableValue value = new SelectProperty(3).observe((Widget)control.getSelectButtonControl());
        IObservableValue dataValue = this.getDetailValue(fieldId, metaData.getModelType());
        JSR303Validator<T> validator = new JSR303Validator<T>(this.getModel(), fieldId, (Control)control, this.propertyChangeListener);
        this.getBindingContext().bindValue((IObservableValue)value, dataValue, new UpdateValueStrategy().setAfterConvertValidator(validator), null);
        ISWTObservableValue commandClearValue = new SelectProperty(3).observe((Widget)control.getClearButtonControl());
        this.getBindingContext().bindValue((IObservableValue)commandClearValue, dataValue, new UpdateValueStrategy().setAfterConvertValidator(validator), null);
        String subFieldId = metaData.getSubFieldId();
        if (metaData.getModelType() == ModelType.POJO) {
            this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeText((Control)control.getTextField(), (int)0), PojoObservables.observeDetailValue((IObservableValue)value, (String)subFieldId, null), null, null);
        } else {
            this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeText((Control)control.getTextField(), (int)0), BeansObservables.observeDetailValue((IObservableValue)BeansObservables.observeValue(this.getModel(), (String)fieldId), (String)subFieldId, null), null, null);
        }
    }

    private void getBindValue(DateTimeAndTimeWithEmpyBox inputControl, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        DateTimeAndTimeWithEmpyBox control = inputControl;
        IObservableValue value = this.getDetailValue(fieldId);
        DateTimeObservableValue dateObservable = new DateTimeObservableValue(control.getDate());
        DateTimeObservableValue timeObservable = new DateTimeObservableValue(control.getTime());
        this.getBindingContext().bindValue((IObservableValue)new DateAndTimeObservableValue((IObservableValue)dateObservable, (IObservableValue)timeObservable), value, new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)inputControl, this.propertyChangeListener)), null);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)control.getDate()), value, null, new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(false)));
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)control.getTime()), value, null, new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(false)));
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)control.getCheckBox()), value, new UpdateValueStrategy().setConverter((IConverter)new ToCurrentDateTimeFieldConverter(control.getDate(), metaData.isInverseCheckBox())).setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control.getCheckBox(), this.propertyChangeListener)), new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(!metaData.isInverseCheckBox())));
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)control.getCheckBox()), value, new UpdateValueStrategy().setConverter((IConverter)new ToCurrentDateTimeFieldConverter(control.getTime(), metaData.isInverseCheckBox())).setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control.getCheckBox(), this.propertyChangeListener)), new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(!metaData.isInverseCheckBox())));
    }

    private void getBindValue(DateTimeWithEmpyBox control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        IObservableValue value = this.getDetailValue(fieldId);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)control.getDateTime()), value, new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control, this.propertyChangeListener)), null);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)control.getDateTime()), value, null, new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(false)));
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)control.getCheckBox()), value, new UpdateValueStrategy().setConverter((IConverter)new ToCurrentDateTimeFieldConverter(control.getDateTime(), metaData.isInverseCheckBox())).setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control.getCheckBox(), this.propertyChangeListener)), new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(!metaData.isInverseCheckBox())));
    }

    private void getBindValue(TimeWithEmpyBox control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        IObservableValue value = this.getDetailValue(fieldId);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)control.getDateTime()), value, new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control, this.propertyChangeListener)), null);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)control.getDateTime()), value, null, new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(false)));
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)control.getCheckBox()), value, new UpdateValueStrategy().setConverter((IConverter)new ToCurrentDateTimeFieldConverter(control.getDateTime(), metaData.isInverseCheckBox())).setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control.getCheckBox(), this.propertyChangeListener)), new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(!metaData.isInverseCheckBox())));
    }

    private void getBindValue(DateTime inputControl, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        this.getBindingContext().bindValue((IObservableValue)new DateTimeObservableValue(inputControl), this.getDetailValue(fieldId), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)inputControl, this.propertyChangeListener)), null);
    }

    private void getBindValue(Button inputControl, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)inputControl), this.getDetailValue(fieldId), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)inputControl, this.propertyChangeListener)), null);
    }

    private IObservableValue getBindValue(Text inputControl, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        ISWTObservableValue observableValue = SWTObservables.observeText((Control)inputControl, (int)24);
        this.getBindingContext().bindValue((IObservableValue)observableValue, this.getDetailValue(fieldId), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)inputControl, this.propertyChangeListener)).setConverter((IConverter)new StringToTrimStringConverter()), null);
        return observableValue;
    }

    private IObservableValue getBindValue(Spinner control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        UpdateValueStrategy targetToModel = new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control, this.propertyChangeListener));
        if (metaData.getToConverter() != null) {
            targetToModel.setConverter(metaData.getToConverter());
        }
        UpdateValueStrategy modelToTarget = null;
        if (metaData.getFromConverter() != null) {
            modelToTarget = new UpdateValueStrategy().setConverter(metaData.getFromConverter());
        }
        ISWTObservableValue observableValue = SWTObservables.observeSelection((Control)control);
        this.getBindingContext().bindValue((IObservableValue)observableValue, this.getDetailValue(fieldId), targetToModel, modelToTarget);
        return observableValue;
    }

    private IObservableValue getBindValueForImage(Label control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        UpdateValueStrategy targetToModel = new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control, this.propertyChangeListener));
        if (metaData.getToConverter() != null) {
            targetToModel.setConverter(metaData.getToConverter());
        }
        UpdateValueStrategy modelToTarget = null;
        if (metaData.getFromConverter() != null) {
            modelToTarget = new UpdateValueStrategy().setConverter(metaData.getFromConverter());
        }
        ISWTObservableValue observableValue = SWTObservables.observeImage((Widget)control);
        this.getBindingContext().bindValue((IObservableValue)observableValue, this.getDetailValue(fieldId), targetToModel, modelToTarget);
        return observableValue;
    }

    private void getBindValue(SpinnerWithCheckBox control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        IObservableValue value = this.getDetailValue(fieldId);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)control.getControl()), value, new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control, this.propertyChangeListener)), null);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)control.getControl()), value, null, new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(false)));
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)control.getCheckBox()), value, new UpdateValueStrategy().setConverter((IConverter)new ToDefaultIntegerConverter(0, metaData.isInverseCheckBox())).setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control.getCheckBox(), this.propertyChangeListener)), new UpdateValueStrategy().setConverter((IConverter)new NullToBooleanConverter(!metaData.isInverseCheckBox())));
    }

    private void getBindValue(FormattedText control, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        if (metaData.getBindingType() == null || metaData.getBindingType() == BindingType.PRICE) {
            this.getBindingContext().bindValue((IObservableValue)new FormattedTextObservableValue(control, 24), this.getDetailValue(fieldId), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control.getControl(), this.propertyChangeListener)).setConverter((IConverter)new NumberToBigDecimalConverter()), null);
        }
        if (metaData.getBindingType() == BindingType.STRING) {
            this.getBindingContext().bindValue((IObservableValue)new FormattedTextObservableValue(control, 24), this.getDetailValue(fieldId), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, (Control)control.getControl(), this.propertyChangeListener)).setConverter((IConverter)new StringToTrimStringConverter()), null);
        }
    }

    private void getBindValue(Viewer obj, ComponentMetaData metaData) {
        String fieldId = metaData.getFieldId();
        if (obj instanceof ComboViewer) {
            ComboViewer viewer = (ComboViewer)obj;
            this.getBindingContext().bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)viewer), this.getDetailValue(fieldId, metaData.getModelType()), new UpdateValueStrategy().setAfterConvertValidator(new JSR303Validator<T>(this.getModel(), fieldId, viewer.getControl(), this.propertyChangeListener)).setConverter(metaData.getFromConverter()), new UpdateValueStrategy().setConverter(metaData.getToConverter()));
        } else {
            log.warn("unknown binding {} field {}", (Object)obj.getClass().getSimpleName(), (Object)fieldId);
        }
    }

    public void initDefaulBinding(EditorComposite<?> composite) {
        IObservableValue autoChangedValue = null;
        Field[] fieldArray = ((Object)composite).getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            f.setAccessible(true);
            Object obj = null;
            try {
                obj = f.get(composite);
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (obj != null) {
                ComponentMetaData metaData = this.getFieldMeta(f);
                ActualClassResolver actualClassResolver = LibActivator.getDefault().getActualClassResolver();
                if (this.isValidControl(obj)) {
                    log.trace("metaData={}", (Object)metaData);
                    if (metaData != null && metaData.getFieldId() != null && !metaData.isIgnore()) {
                        if (actualClassResolver.isValidProperty(this.clazz, metaData.getFieldId())) {
                            if (obj instanceof Control) {
                                IObservableValue res = this.getBindValue((Control)obj, metaData);
                                if (res != null && metaData.isAutoChanged()) {
                                    autoChangedValue = res;
                                }
                            } else if (obj instanceof Viewer) {
                                this.getBindValue((Viewer)obj, metaData);
                            } else if (obj instanceof FormattedText) {
                                this.getBindValue((FormattedText)obj, metaData);
                            }
                        } else if (obj instanceof Control) {
                            ((Control)obj).setVisible(false);
                        } else if (obj instanceof Viewer) {
                            ((Viewer)obj).getControl().setVisible(false);
                        }
                    }
                } else if (obj instanceof Label && metaData.getBindingType() == BindingType.IMAGE) {
                    this.getBindValueForImage((Label)obj, metaData);
                } else if (obj instanceof Label && !actualClassResolver.isValidProperty(this.clazz, metaData.getFieldId())) {
                    ((Label)obj).setVisible(false);
                }
            }
            ++n2;
        }
        composite.setAutoChangedValue(autoChangedValue);
    }

    private boolean isValidControl(Object obj) {
        return obj instanceof Text || obj instanceof Spinner || obj instanceof Button || obj instanceof DateTime || obj instanceof TextWithClearButton || obj instanceof DateTimeWithEmpyBox || obj instanceof ComboViewer || obj instanceof DateTimeAndTimeWithEmpyBox || obj instanceof TimeWithEmpyBox || obj instanceof BitCheckGroup || obj instanceof ListCheckGroup || obj instanceof SetStringCheckGroup || obj instanceof ComboBoxWithEmptyBox || obj instanceof SpinnerWithCheckBox || obj instanceof FormattedText;
    }

    private DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    private IObservableValue getDetailValue(String propertyName) {
        return this.getDetailValue(propertyName, ModelType.POJO);
    }

    private IObservableValue getDetailValue(String propertyName, ModelType modelType) {
        Class actualClazz = LibActivator.getDefault().getActualClassResolver().getActual(this.clazz);
        log.trace("detail value for class:{}, property:{}, modelType:{}", new Object[]{actualClazz, propertyName, modelType});
        if (modelType == ModelType.POJO) {
            return PojoProperties.value((Class)actualClazz, (String)propertyName).observeDetail(this.masterValue);
        }
        return BeanProperties.value((Class)actualClazz, (String)propertyName).observeDetail(this.masterValue);
    }

    private T getModel() {
        return this.model;
    }
}

