/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors;

import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.widgets.DualSelectionAdapter;
import su.artix.yuki.editors.AbstractDirectorySelectDialog;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.DirectoryEditorFactory;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.editors.DirectorySelectFactory;

public class DirectoryChoiceSelectionAdapter<E>
extends DualSelectionAdapter {
    private static final Logger log = LoggerFactory.getLogger(DirectoryChoiceSelectionAdapter.class);
    private Widget choice;
    private Class<E> clazz;
    private Object parentModel;
    private Shell parentShell;
    private DirectorySelectDialogState selectDialogState;
    private String property;

    public DirectoryChoiceSelectionAdapter(Shell parentShell, Widget choice, Object parentModel, String property, Class<E> clazz) {
        this(parentShell, choice, parentModel, property, clazz, new DirectorySelectDialogState());
    }

    public DirectoryChoiceSelectionAdapter(Shell parentShell, Widget choice, Object parentModel, String property, Class<E> clazz, DirectorySelectDialogState selectDialogState) {
        this.parentShell = parentShell;
        this.choice = choice;
        this.parentModel = parentModel;
        this.clazz = clazz;
        this.selectDialogState = selectDialogState;
        this.property = property;
    }

    public void widgetSelected(SelectionEvent event) {
        E model = this.getActualModel();
        AbstractDirectorySelectDialog<E, ?> dialog = this.getDialog(this.clazz, this.parentShell, model, this.selectDialogState);
        dialog.open();
        E retmodel = dialog.getModel();
        if (dialog.getReturnCode() == 0 && retmodel != null) {
            this.choice.setData(retmodel);
        }
        this.selectDialogState = dialog.getSelectDialogState();
        this.customAction(retmodel);
    }

    private E getActualModel() {
        Object model = null;
        if (this.property != null) {
            try {
                model = PropertyUtils.getProperty((Object)this.parentModel, (String)this.property);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalStateException("Property:" + this.property + " not found.");
            }
        } else if (this.parentModel != null) {
            model = this.parentModel;
        }
        return (E)model;
    }

    protected void customAction(E retmodel) {
    }

    public AbstractDirectorySelectDialog<E, ?> getDialog(Class<E> clazz, Shell parentShell, E model, DirectorySelectDialogState selectDialogState) {
        return DirectorySelectFactory.getSelect(clazz, parentShell, model, selectDialogState);
    }

    public SelectionAdapter getShowDetailAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object model = DirectoryChoiceSelectionAdapter.this.getActualModel();
                if (model != null) {
                    Dialog dialog = DirectoryEditorFactory.getEditor(DirectoryChoiceSelectionAdapter.this.clazz, DirectoryChoiceSelectionAdapter.this.parentShell, model, DialogMode.READ_ONLY);
                    dialog.open();
                }
            }
        };
    }
}

