/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.SessionManager;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.cashserver.security.GuiElementController;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.view.DirectoryViewPanel;
import su.artix.yuki.view.MementoPersistStore;

public abstract class DirectoryView<T, VIEWER extends ColumnViewer>
extends ViewPart
implements PropertyChangeListener,
ISelectionListener,
MementoPersistStore {
    private static final Logger log = LoggerFactory.getLogger(DirectoryView.class);
    protected DirectoryEditActionGroup<T> commonActionGroup;
    @SecurityKey(title="\u0422\u0430\u0431\u043b\u0438\u0446\u0430")
    private DirectoryViewPanel<T, VIEWER> viewPanel;
    private Class<T> pojoClass;
    private IMemento memento;

    protected abstract String getID();

    protected VIEWER getViewer() {
        log.trace("get viewer. {}", (Object)this.getID());
        return this.viewPanel.getViewer();
    }

    @Override
    public IMemento getMemento() {
        return this.memento;
    }

    public void saveState(IMemento memento) {
        this.getViewPanel().savePersistState();
        memento.putMemento(this.memento);
        super.saveState(memento);
    }

    protected void restoreState() {
        this.getViewPanel().initPersistState((IWorkbenchPart)this);
        this.getViewer().refresh(false);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"temped_null_memento") : memento;
    }

    protected void doRemove(PropertyChangeEvent evt) {
    }

    protected void doRefresh() {
    }

    protected void doRefreshCascade() {
    }

    protected void doSingleItemRefresh(PropertyChangeEvent evt) {
    }

    protected void doChangeId(PropertyChangeEvent evt) {
    }

    protected void doUpdate(PropertyChangeEvent evt) {
    }

    protected void doAdd(PropertyChangeEvent evt) {
    }

    @Override
    public final void propertyChange(final PropertyChangeEvent evt) {
        log.trace("evt {}", (Object)evt);
        log.trace("Type event={}, evt.getNewValue={}, evt.getOldValue={}", new Object[]{evt.getPropertyName(), evt.getNewValue(), evt.getOldValue()});
        SessionManager.openSession(this.pojoClass);
        final String connectionId = ArtixAdminContextHolder.getConnectionId();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArtixAdminContextHolder.setConnectionId((String)connectionId);
                if (DirectoryAction.UPDATE.toString().equals(evt.getPropertyName())) {
                    DirectoryView.this.doUpdate(evt);
                } else if (DirectoryAction.CHANGE_ID.toString().equals(evt.getPropertyName())) {
                    DirectoryView.this.doChangeId(evt);
                } else if (DirectoryAction.ADD.toString().equals(evt.getPropertyName())) {
                    DirectoryView.this.doAdd(evt);
                } else if (DirectoryAction.REMOVE.toString().equals(evt.getPropertyName())) {
                    DirectoryView.this.doRemove(evt);
                } else if (DirectoryAction.REFRESH.toString().equals(evt.getPropertyName())) {
                    DirectoryView.this.doRefresh();
                } else if (DirectoryAction.CASCADE_REFRESH.toString().equals(evt.getPropertyName())) {
                    DirectoryView.this.doRefreshCascade();
                } else if (DirectoryAction.REFRESH_SINGLE_ITEM.toString().equals(evt.getPropertyName())) {
                    DirectoryView.this.doSingleItemRefresh(evt);
                }
            }
        });
        SessionManager.closeSession(this.pojoClass);
    }

    public void createPartControl(Composite parent) {
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.pojoClass).addPropertyChangeListener((PropertyChangeListener)this);
        this.applyRights();
    }

    public void applyRights() {
        log.trace("begin apply rights");
        GuiActivator.getDefault().getBeanByClass(GuiElementController.class).applyRights(this.getClass(), (Object)this);
        log.trace("end apply rights");
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void setFocus() {
        this.getViewer().getControl().setFocus();
        this.applyRights();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        if (this.commonActionGroup != null) {
            this.commonActionGroup.dispose();
            ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.commonActionGroup.getClazz()).removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.getViewer() != null && this.getViewer().getContentProvider() != null) {
            this.getViewer().getContentProvider().dispose();
        }
    }

    public void setViewPanel(DirectoryViewPanel<T, VIEWER> viewPanel) {
        this.viewPanel = viewPanel;
    }

    public DirectoryViewPanel<T, VIEWER> getViewPanel() {
        return this.viewPanel;
    }

    protected void setPojoClass(Class<T> pojoClass) {
        this.pojoClass = pojoClass;
    }
}

