/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view.sort;

import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class TableComparator<T>
implements Comparator<T> {
    private TableColumn currentTableColumn = null;
    private TreeColumn currentTreeColumn = null;

    protected int stringCompare(String str1, String str2) {
        return Collator.getInstance(Locale.getDefault()).compare(str1, str2);
    }

    protected int intCompare(Integer value1, Integer value2) {
        if (value1 < value2) {
            return -1;
        }
        if (value1 > value2) {
            return 1;
        }
        return 0;
    }

    protected int doubleCompare(Double value1, Double value2) {
        if (value1 < value2) {
            return -1;
        }
        if (value1 > value2) {
            return 1;
        }
        return 0;
    }

    protected int longCompare(Long value1, Long value2) {
        if (value1 < value2) {
            return -1;
        }
        if (value1 > value2) {
            return -1;
        }
        return 0;
    }

    protected int dateCompare(Date date1, Date date2) {
        if (date1 == null) {
            return 0;
        }
        if (date2 == null) {
            return 0;
        }
        if (date1.equals(date2)) {
            return 0;
        }
        return date1.before(date2) ? 1 : -1;
    }

    protected int objectCompare(Object obj1, Object obj2) {
        return Collator.getInstance(Locale.getDefault()).compare(obj1, obj2);
    }

    public TableColumn getCurrentTableColumn() {
        return this.currentTableColumn;
    }

    public void setCurrentTableColumn(TableColumn currentTableColumn) {
        this.currentTableColumn = currentTableColumn;
    }

    public TreeColumn getCurrentTreeColumn() {
        return this.currentTreeColumn;
    }

    public void setCurrentTreeColumn(TreeColumn currentTreeColumn) {
        this.currentTreeColumn = currentTreeColumn;
    }
}

