/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view.state;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.provider.IOrderedContentProvider;
import su.artix.yuki.view.state.PersistStateViewer;

public class PersistTableSortOrderState
implements PersistStateViewer<Table, TableViewer> {
    private static final Logger log = LoggerFactory.getLogger(PersistTableSortOrderState.class);
    private IMemento memento;
    private String id;

    public PersistTableSortOrderState(IMemento memento, String id) {
        this.memento = memento;
        this.id = id;
    }

    @Override
    public void saveState(IMemento memento, Table composite) {
    }

    @Override
    public void restoreState(Table composite) {
        this.restoreState(composite, null);
    }

    @Override
    public void restoreState(Table composite, TableViewer viewer) {
        log.trace("restore state");
        if (this.memento != null) {
            this.memento = this.memento.getChild(String.valueOf(this.id) + "_sort_order");
            if (this.memento != null && viewer.getContentProvider() instanceof IOrderedContentProvider) {
                String sortProperty;
                Integer sortColumn;
                IOrderedContentProvider provider = (IOrderedContentProvider)viewer.getContentProvider();
                Integer direction = this.memento.getInteger("direction");
                if (direction != null) {
                    composite.setSortDirection(direction.intValue());
                    provider.setAscending(direction == 128);
                }
                if ((sortColumn = this.memento.getInteger("sort_column")) != null) {
                    composite.setSortColumn(composite.getColumn(sortColumn.intValue()));
                }
                if ((sortProperty = this.memento.getString("sort_property")) != null) {
                    provider.setSortProperty(sortProperty);
                }
            }
        }
    }

    @Override
    public void saveState(IMemento memento, TableViewer viewer) {
        log.trace("save state");
        IMemento stored = memento.getChild(String.valueOf(this.id) + "_sort_order");
        memento = stored == null ? memento.createChild(String.valueOf(this.id) + "_sort_order") : stored;
        Table composite = viewer.getTable();
        int direction = composite.getSortDirection();
        memento.putInteger("direction", direction);
        if (composite.getSortColumn() != null) {
            int index = 0;
            TableColumn[] tableColumnArray = composite.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                if (composite.getSortColumn().equals(column)) {
                    memento.putInteger("sort_column", index);
                }
                ++index;
                ++n2;
            }
        }
        if (viewer.getContentProvider() instanceof IOrderedContentProvider) {
            IOrderedContentProvider provider = (IOrderedContentProvider)viewer.getContentProvider();
            memento.putString("sort_property", provider.getSortProperty());
        }
    }
}

