/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.controls;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControlListener;

public class DiscountConditionTimeControl
implements DiscountConditionControl {
    private DateTime dateTime;

    public DiscountConditionTimeControl(Composite parent, String labelName, String defaultValue) {
        Label label = new Label(parent, 0);
        label.setText(labelName);
        this.dateTime = new DateTime(parent, 32896);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.dateTime);
        this.setTime(defaultValue);
    }

    private void setTime(String defaultDate) {
        String def = defaultDate;
        if (def != null && !def.isEmpty()) {
            String[] values;
            if (def.startsWith("\"") && def.endsWith("\"")) {
                def = StringUtils.substringBetween((String)def, (String)"\"", (String)"\"");
            }
            if ((values = def.split(":")).length == 2) {
                try {
                    this.dateTime.setHours(Integer.valueOf(values[0].trim()).intValue());
                    this.dateTime.setMinutes(Integer.valueOf(values[1].trim()).intValue());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    @Override
    public String getText() {
        return "\"" + this.dateTime.getHours() + ":" + (this.dateTime.getMinutes() < 10 ? "0" : "") + this.dateTime.getMinutes() + "\"";
    }

    @Override
    public String getDesc() {
        return String.valueOf(this.dateTime.getHours()) + ":" + (this.dateTime.getMinutes() < 10 ? "0" : "") + this.dateTime.getMinutes();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void addListener(final DiscountConditionControlListener listener) {
        this.dateTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                listener.exec();
            }
        });
    }
}

