/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.discountsystem.compare;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;
import su.artix.discountmanager.discountsystem.compare.CompareItem;
import su.artix.discountmanager.providers.SystemLabelProvider;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;

public class DiscountDifferencer {
    public static final int NO_CHANGE = 0;
    public static final int ADDITION = 1;
    public static final int DELETION = 2;
    public static final int CHANGE = 3;
    public static final int CHANGE_TYPE_MASK = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int CONFLICTING = 12;
    public static final int DIRECTION_MASK = 12;
    public static final int PSEUDO_CONFLICT = 16;
    private ITreeContentProvider contentProvider;
    private SystemLabelProvider labelProvider;

    public DiscountDifferencer(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.contentProvider = contentProvider;
        this.labelProvider = (SystemLabelProvider)labelProvider;
    }

    public Object findDifferences(DiscountSystem left, DiscountSystem right) {
        Node root = new Node(null, left, right, 0, this.labelProvider.getImage(left));
        this.traverse(root, root.getLeft(), root.getRight());
        return this.createDiffTree(root);
    }

    private IDiffContainer createDiffTree(Node node) {
        DiffNode diffNode = new DiffNode(node.getDiffCode(), null, (ITypedElement)new CompareItem(node.getLeft(), this.labelProvider, node.getNodeImage()), (ITypedElement)new CompareItem(node.getRight(), this.labelProvider, node.getNodeImage()));
        if (node.getChildrens() != null && !node.getChildrens().isEmpty()) {
            for (Node child : node.getChildrens()) {
                IDiffContainer childDiffNode = this.createDiffTree(child);
                if (childDiffNode == null) continue;
                diffNode.setKind(diffNode.getKind() | childDiffNode.getKind());
                diffNode.add((IDiffElement)childDiffNode);
            }
        }
        if (diffNode.getKind() == 0) {
            return null;
        }
        return diffNode;
    }

    private void traverse(Node parent, Object left, Object right) {
        Object[] rightChilds;
        Object[] leftChilds = this.contentProvider.getChildren(left);
        Node current = this.findPairs(leftChilds, rightChilds = this.contentProvider.getChildren(right), parent);
        if (current.getChildrens() == null) {
            return;
        }
        for (Node child : current.getChildrens()) {
            this.traverse(child, child.getLeft(), child.getRight());
        }
        if ((current.getDiffCode() & 3) != 0 && (current.getDiffCode() & 3) != 3) {
            current.removeChildrens();
        }
    }

    private Node findPairs(Object[] leftChilds, Object[] rightChilds, Node parent) {
        LinkedList input2List = new LinkedList();
        CollectionUtils.addAll(input2List, (Object[])rightChilds);
        Object[] objectArray = leftChilds;
        int n = leftChilds.length;
        int n2 = 0;
        while (n2 < n) {
            Object item1 = objectArray[n2];
            Object removedItem2 = null;
            for (Object item2 : input2List) {
                if (!this.isLikeElements(item1, item2, parent)) continue;
                int diff = 3;
                if (this.isEqualsElements(item1, item2)) {
                    diff = 0;
                }
                parent.add(new Node(parent, item1, item2, diff, this.labelProvider.getImage(item1)));
                removedItem2 = item2;
                break;
            }
            if (removedItem2 == null) {
                parent.add(new Node(parent, item1, null, 1, this.labelProvider.getImage(item1)));
            } else {
                input2List.remove(removedItem2);
            }
            ++n2;
        }
        for (Object item2 : input2List) {
            parent.add(new Node(parent, null, item2, 2, this.labelProvider.getImage(item2)));
        }
        return parent;
    }

    protected boolean isLikeElements(Object item1, Object item2, Node parent) {
        if (item1 != null && item2 != null) {
            if (item1 instanceof DiscountRate && item2 instanceof DiscountRate || item1 instanceof DiscountObject && item2 instanceof DiscountObject || item1 instanceof DiscountSystem && item2 instanceof DiscountSystem) {
                return true;
            }
            if (item1.getClass().equals(item2.getClass())) {
                if (item1 instanceof Discount && ((Discount)item1).getId().equals(((Discount)item2).getId()) || item1 instanceof DiscountCampaign && ((DiscountCampaign)item1).getId().equals(((DiscountCampaign)item2).getId())) {
                    return true;
                }
                return this.labelProvider.getTextWithoutChangedSymbol(item1).equals(this.labelProvider.getTextWithoutChangedSymbol(item2));
            }
            return false;
        }
        return item1 == item2;
    }

    protected boolean isEqualsElements(Object item1, Object item2) {
        if (item1.getClass() == item2.getClass() && item1 instanceof DiscountCondition) {
            return ((DiscountCondition)item1).equalsWithoutParent(item2);
        }
        return item1.equals(item2);
    }

    private class Node {
        private int diffCode;
        private List<Node> childrens;
        private Image nodeImage;
        private Object left;
        private Object right;
        private Object parent;

        public Node(Object parent, Object left, Object right, int diffCode, Image nodeImage) {
            this.parent = parent;
            this.left = left;
            this.right = right;
            this.diffCode = diffCode;
            this.nodeImage = nodeImage;
        }

        public void add(Node node) {
            if (this.childrens == null) {
                this.childrens = new ArrayList<Node>();
            }
            this.childrens.add(node);
        }

        public List<Node> getChildrens() {
            return this.childrens;
        }

        public int getDiffCode() {
            return this.diffCode;
        }

        public void setDiffCode(int diffCode) {
            this.diffCode = diffCode;
        }

        public Object getLeft() {
            return this.left;
        }

        public void setLeft(Object left) {
            this.left = left;
        }

        public Object getRight() {
            return this.right;
        }

        public void setRight(Object right) {
            this.right = right;
        }

        public Object getParent() {
            return this.parent;
        }

        public void setParent(Object parent) {
            this.parent = parent;
        }

        public void removeChildrens() {
            this.childrens = null;
        }

        public Image getNodeImage() {
            return this.nodeImage;
        }
    }
}

