/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers.discountsystem;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.swt.widgets.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.dialogs.discountsystem.DiscountObjectKitDialog;
import su.artix.discountmanager.dialogs.discountsystem.DiscountRateDialog;
import su.artix.discountmanager.dialogs.discountsystem.kitnew.KitDialog;
import su.artix.discountmanager.handlers.discountsystem.HandlerUtils;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountKitObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitObject;
import su.artix.yuki.editors.DialogMode;

public class EditDiscountRateHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(EditDiscountRateHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DiscountRate current = (DiscountRate)((Event)event.getTrigger()).data;
        Discount parent = (Discount)current.getParent();
        Map<String, String> paramList = null;
        String title = "";
        try {
            title = event.getCommand().getName();
            paramList = HandlerUtils.fillParams(event, event.getCommand().getName());
        }
        catch (NotDefinedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        paramList.put("title", title);
        if (current instanceof DiscountRateKit) {
            DiscountObjectKitDialog dialog = new DiscountObjectKitDialog((DiscountObjectKit)parent.getDiscountObject(), paramList, DialogMode.UPDATE);
            dialog.open();
        } else if (current instanceof DiscountRateKitObject) {
            KitDialog dialog = new KitDialog((DiscountKitObject)parent.getDiscountObject(), paramList, DialogMode.UPDATE);
            dialog.open();
        } else {
            DiscountRateDialog dialog = new DiscountRateDialog(parent, current, paramList, DialogMode.UPDATE);
            if (dialog.open() == 0) {
                log.trace("Edited " + dialog.getDiscountRate());
            }
        }
        return null;
    }
}

