/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;
import su.artix.discountmanager.views.DiscountGanttChartViewPanel;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;

public class DiscountGanttChartView
extends ViewPart
implements PropertyChangeListener {
    public static final Logger log = LoggerFactory.getLogger(DiscountGanttChartView.class);
    public static final String ID = "su.artix.discountmanager.views.DiscountGanttChartView";
    private DiscountGanttChartViewPanel viewPanel;

    public void createPartControl(Composite parent) {
        this.viewPanel = new DiscountGanttChartViewPanel(parent, 0);
    }

    public void setFocus() {
        this.viewPanel.setFocus();
    }

    private DiscountSystem getDiscountSystem(CustomSystemTreeViewer systemTree) {
        DiscountSystem system = new DiscountSystem();
        try {
            DiscountSystemContentProvider provider = (DiscountSystemContentProvider)systemTree.getContentProvider();
            log.debug("type={}", (Object)provider.getSystemType());
            system = provider.getCurrentSystem();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return system;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.viewPanel.setDiscountSystem(this.getDiscountSystem((CustomSystemTreeViewer)evt.getSource()));
        this.viewPanel.refresh();
    }

    public DiscountGanttChartViewPanel getViewPanel() {
        return this.viewPanel;
    }

    public void setActiveParentId(String activeParentId) {
        this.viewPanel.setActiveParentId(activeParentId);
    }
}

