/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.views;

import java.beans.PropertyChangeListener;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.holders.CommandHolder;
import su.artix.discountmanager.holders.MenuHolder;
import su.artix.discountmanager.holders.PopupMenuHolderDiscountSystem;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.providers.discountsystem.SecondDiscountSystemLabelProvider;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;
import su.artix.discountmanager.views.IViewPartCustomize;
import su.artix.discountmanager.views.TreeUtils;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.yuki.view.MementoPersistStore;

public class SecondSystemView
extends ViewPart
implements ISelectionListener,
IViewPartCustomize,
MementoPersistStore {
    public static final String ID = "su.artix.discountmanager.views.secondsystemview";
    private CustomSystemTreeViewer systemTreeViewer;
    private final DiscountSystemDAO systemDAO = Activator.getDefault().getBeanByClass(DiscountSystemDAO.class);
    private IMemento memento;

    public IMemento getMemento() {
        return this.memento;
    }

    public void saveState(IMemento memento) {
        memento.putMemento(this.memento);
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"temped_null_memento") : memento;
    }

    public void createPartControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.systemTreeViewer = new CustomSystemTreeViewer(parent, (IWorkbenchPart)this, ID);
        this.systemTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommandHolder.INSTANCE.executeCommand("su.artix.discountmanager.commands.edit", null);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.systemTreeViewer.getTree());
        this.systemTreeViewer.setContentProvider((IContentProvider)new DiscountSystemContentProvider(DiscountSystemDAO.SystemType.SECOND_SYSTEM));
        this.systemTreeViewer.setLabelProvider((IBaseLabelProvider)new SecondDiscountSystemLabelProvider());
        this.systemTreeViewer.setInput(this.systemDAO);
        TreeUtils.expandTreeToGroups(this.systemTreeViewer);
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.systemTreeViewer.getTree());
        this.systemTreeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.systemTreeViewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.systemTreeViewer);
        this.activateHandlers();
    }

    private void activateHandlers() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("yuki.discount.context");
        }
    }

    public void setFocus() {
        this.systemTreeViewer.getControl().setFocus();
        ViewHolder.INSTANCE.setActiveSystemViewPart((IWorkbenchPart)this);
        Object[] expandElements = this.systemTreeViewer.getExpandedElements();
        this.systemTreeViewer.refresh();
        this.systemTreeViewer.setExpandedElements(expandElements);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection selectionIn = (IStructuredSelection)selection;
            if (part instanceof SecondSystemView) {
                ViewHolder.INSTANCE.setActiveViewPart((IWorkbenchPart)this);
                this.initializePopupMenu(selectionIn.getFirstElement());
            }
        }
    }

    public void initializePopupMenu(Object currentObject) {
        MenuHolder.INSTANCE.setActiveExport(true);
        PopupMenuHolderDiscountSystem.INSTANCE.initialize(currentObject);
    }

    @Override
    public void setImage(Image image) {
        this.setTitleImage(image);
    }

    @Override
    public void setTitleName(String title) {
        this.setPartName(title);
    }

    @Override
    public void setIsChangedView(Boolean isChanged) {
        String title = StringUtils.remove((String)this.getTitle(), (char)'*');
        if (isChanged.booleanValue()) {
            this.setTitleName("*" + title);
        } else {
            this.setPartName(title);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.systemTreeViewer.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.systemTreeViewer.removePropertyChangeListener(listener);
    }
}

