/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Reference;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AbstractPersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationBasedPersistentProperty<P extends PersistentProperty<P>>
extends AbstractPersistentProperty<P> {
    private final Value value;

    public AnnotationBasedPersistentProperty(Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, P> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
        this.value = field.getAnnotation(Value.class);
        field.isAnnotationPresent(Autowired.class);
    }

    @Override
    public String getSpelExpression() {
        return this.value == null ? null : this.value.value();
    }

    @Override
    public boolean isTransient() {
        boolean isTransient = super.isTransient() || this.field.isAnnotationPresent(Transient.class);
        return isTransient || this.field.isAnnotationPresent(Value.class) || this.field.isAnnotationPresent(Autowired.class);
    }

    @Override
    public boolean isIdProperty() {
        return this.field.isAnnotationPresent(Id.class);
    }

    @Override
    public boolean isAssociation() {
        if (this.isTransient()) {
            return false;
        }
        if (this.field.isAnnotationPresent(Reference.class)) {
            return true;
        }
        for (Annotation annotation : this.field.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Reference.class)) continue;
            return true;
        }
        return false;
    }
}

