/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryBeanDefinitionRegistrarSupport
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)annotationMetadata);
        Assert.notNull((Object)registry);
        if (annotationMetadata.getAnnotationAttributes(this.getAnnotation().getName()) == null) {
            return;
        }
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        AnnotationRepositoryConfigurationSource configuration = new AnnotationRepositoryConfigurationSource(annotationMetadata, this.getAnnotation());
        RepositoryConfigurationExtension extension = this.getExtension();
        extension.registerBeansForRoot(registry, configuration);
        for (RepositoryConfiguration<AnnotationRepositoryConfigurationSource> repositoryConfiguration : extension.getRepositoryConfigurations(configuration, (ResourceLoader)resourceLoader)) {
            RepositoryBeanDefinitionBuilder builder = new RepositoryBeanDefinitionBuilder(repositoryConfiguration, extension);
            BeanDefinitionBuilder definitionBuilder = builder.build(registry, (ResourceLoader)resourceLoader);
            extension.postProcess(definitionBuilder, configuration);
            registry.registerBeanDefinition(repositoryConfiguration.getBeanId(), (BeanDefinition)definitionBuilder.getBeanDefinition());
        }
    }

    protected abstract Class<? extends Annotation> getAnnotation();

    protected abstract RepositoryConfigurationExtension getExtension();
}

