/*
 * Decompiled with CFR 0.152.
 */
package cashserver.cashregistry.rest.repository;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;
import su.artix.cashserver.core.cashregistry.repository.SecurityObjectRepository;
import su.artix.cashserver.rest.client.IClientGetter;

public class SecurityObjectRepositoryRest
implements SecurityObjectRepository {
    private IClientGetter clientGetter;

    public <S extends SecurityObject> S save(S entity) {
        if (this.exists(entity.getId())) {
            this.clientGetter.getClient().getSecurityObjectEntity().updateSecurityObject(entity.getId(), entity);
        } else {
            this.clientGetter.getClient().getSecurityObjectEntity().addSecurityObject(entity);
        }
        return entity;
    }

    public <S extends SecurityObject> Iterable<S> save(Iterable<S> entities) {
        for (SecurityObject securityObject : entities) {
            this.save(securityObject);
        }
        return entities;
    }

    public SecurityObject findOne(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return this.clientGetter.getClient().getSecurityObjectEntity().getSecurityObject(id);
    }

    public boolean exists(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        return this.clientGetter.getClient().getSecurityObjectEntity().existsSecurityObject(id);
    }

    public List<SecurityObject> findAll() {
        return this.clientGetter.getClient().getSecurityObjectEntity().getSecurityObjects();
    }

    public long count() {
        return this.clientGetter.getClient().getSecurityObjectEntity().countSecurityObjects();
    }

    public void delete(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            this.clientGetter.getClient().getSecurityObjectEntity().removeSecurityObject(id);
        }
    }

    public void delete(SecurityObject entity) {
        this.delete(entity.getId());
    }

    public void delete(Iterable<? extends SecurityObject> entities) {
        for (SecurityObject securityObject : entities) {
            this.delete(securityObject.getId());
        }
    }

    public SecurityObject findById(String id) {
        return this.findOne(id);
    }

    public List<SecurityObject> findByParentId(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return Collections.emptyList();
        }
        return this.clientGetter.getClient().getSecurityObjectEntity().getSecurityObjectsByParentId(id);
    }

    public List<SecurityObject> findByClass(String clazz) {
        if (StringUtils.isEmpty((String)clazz)) {
            return Collections.emptyList();
        }
        return this.clientGetter.getClient().getSecurityObjectEntity().getSecurityObjectsByClass(clazz);
    }

    public Iterable<SecurityObject> findAll(Sort sort) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Page<SecurityObject> findAll(Pageable pageable) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterable<SecurityObject> findAll(Iterable<String> ids) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void deleteAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IClientGetter getClientGetter() {
        return this.clientGetter;
    }

    public void setClientGetter(IClientGetter clientGetter) {
        this.clientGetter = clientGetter;
    }
}

