/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.directory;

import java.util.Collection;
import java.util.List;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.domain.payment.Supplier;
import ru.ssa.cashadmin.domain.payment.TmcSupplier;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.model.directory.DirectoryModel;
import su.artix.yuki.model.directory.DirectoryModelFactory;

public class DirectorySupplierModel
extends DirectoryModel<Supplier> {
    public DirectorySupplierModel() {
        super(Supplier.class);
    }

    @Override
    protected void doAfterChangeId(Object oldId, Supplier obj) throws ExecuteQueryException {
        String id = (String)oldId;
        this.updateTmcSuppliers(id, obj);
    }

    @Override
    public void delete(Supplier obj) throws ExecuteQueryException {
        super.delete(obj);
        this.removeTmcSuppliers(obj);
    }

    @Override
    public void cascadeRefresh() {
        super.cascadeRefresh();
        DirectoryModelFactory.getModel(TmcSupplier.class).firePropertyChange(DirectoryAction.CASCADE_REFRESH, null, null);
    }

    private void updateTmcSuppliers(String oldId, Supplier obj) throws ExecuteQueryException {
        TmcSupplier state = (TmcSupplier)LibActivator.getDefault().getActualClassResolver().getInstance(TmcSupplier.class);
        state.setSupplierCode(oldId);
        state.getPk().setSupplierCode(oldId);
        DaoInterface dao = DaoFactory.getDAO(TmcSupplier.class);
        List list = dao.getList((Object)state);
        dao.deleteAll((Collection)list);
        for (TmcSupplier command : list) {
            command.setSupplier(obj);
            dao.update((Object)command);
        }
    }

    private void removeTmcSuppliers(Supplier obj) throws ExecuteQueryException {
        TmcSupplier state = (TmcSupplier)LibActivator.getDefault().getActualClassResolver().getInstance(TmcSupplier.class);
        state.setSupplierCode(obj.getCode());
        state.getPk().setSupplierCode(obj.getCode());
        DaoInterface dao = DaoFactory.getDAO(TmcSupplier.class);
        dao.deleteAll((Collection)dao.getList((Object)state));
    }
}

