/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.duallists;

import com.richclientgui.toolbox.duallists.DualListComposite;
import com.richclientgui.toolbox.duallists.TableColumnData;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CustomTableDualListComposite<T>
extends DualListComposite<T> {
    protected static final int DEFAULT_COLUMN_WIDTH = 150;
    private final TableColumnData[] availableColumnData;
    private final TableColumnData[] chosenColumnData;

    public CustomTableDualListComposite(Composite parent, int style, TableColumnData[] availableColumnData, TableColumnData[] chosenColumnData) {
        super(parent, style);
        TableColumnData[] tableColumnDataArray;
        TableColumnData[] tableColumnDataArray2;
        if (availableColumnData == null) {
            TableColumnData[] tableColumnDataArray3 = new TableColumnData[1];
            tableColumnDataArray2 = tableColumnDataArray3;
            tableColumnDataArray3[0] = new TableColumnData(0, "", 150);
        } else {
            tableColumnDataArray2 = availableColumnData;
        }
        this.availableColumnData = tableColumnDataArray2;
        Comparator<TableColumnData> columnDataComparator = new Comparator<TableColumnData>(){

            @Override
            public int compare(TableColumnData arg0, TableColumnData arg1) {
                return arg0.getIndex() - arg1.getIndex();
            }
        };
        Arrays.sort(this.availableColumnData, columnDataComparator);
        if (chosenColumnData == null) {
            TableColumnData[] tableColumnDataArray4 = new TableColumnData[1];
            tableColumnDataArray = tableColumnDataArray4;
            tableColumnDataArray4[0] = new TableColumnData(0, "", 150);
        } else {
            tableColumnDataArray = this.chosenColumnData = chosenColumnData;
        }
        if (this.chosenColumnData != null) {
            Arrays.sort(this.chosenColumnData, columnDataComparator);
        }
        this.createTableColumns();
    }

    @Override
    protected final Table createAvailableTable(Composite parent) {
        Table table = new Table(parent, 68354);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        return table;
    }

    @Override
    protected final Table createChosenTable(Composite parent) {
        Table table = new Table(parent, 68354);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        return table;
    }

    private void createTableColumns() {
        TableColumnData element;
        TableColumnData[] tableColumnDataArray = this.availableColumnData;
        int n = this.availableColumnData.length;
        int n2 = 0;
        while (n2 < n) {
            element = tableColumnDataArray[n2];
            CustomTableDualListComposite.createTableColumn(element, this.getAvailableTable());
            ++n2;
        }
        tableColumnDataArray = this.chosenColumnData;
        n = this.chosenColumnData.length;
        n2 = 0;
        while (n2 < n) {
            element = tableColumnDataArray[n2];
            CustomTableDualListComposite.createTableColumn(element, this.getChosenTable());
            ++n2;
        }
    }

    private static void createTableColumn(TableColumnData columnData, Table table) {
        TableColumn col = new TableColumn(table, columnData.getColumnStyle(), columnData.getIndex());
        col.setText(columnData.getHeader());
        col.setMoveable(columnData.isMoveable());
        col.setWidth(columnData.getWidth());
        col.setResizable(columnData.isResizable());
        col.setAlignment(columnData.getAlignment());
        col.setToolTipText(columnData.getTooltip());
        col.setImage(columnData.getImage());
    }
}

