/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.goods;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.cashadmin.domain.Connect;
import ru.ssa.cashadmin.domain.Images;
import su.artix.artixadmin.connection.ManagedWebUserSource;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.discountmanager.Activator;
import su.artix.yuki.editors.EditorComposite;

public class AbstractImageEditPanel<T>
extends EditorComposite<T> {
    private Label imageField;
    private final RestTemplate restTemplateForImage = new RestTemplate();
    private final RestInvoker restInvoker;

    public AbstractImageEditPanel(Composite parent, int style, Class<T> clazz, T model) {
        super(parent, style, clazz, model);
        RestInvokerManager restInvokerManager = ArtixAdminActivator.getDefault().getBeanByClass(RestInvokerManager.class, "restInvokerManager");
        this.restInvoker = restInvokerManager.getRestInvoker();
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)this);
        this.imageField = new Label((Composite)this, 0);
    }

    protected void setImage(String id, String usageType, String idType) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String urlPref = preferenceStore.getString("IMAGES_URL_PREFIX");
        if (StringUtils.isEmpty((String)urlPref)) {
            Connect currentConnect = ArtixAdminActivator.getDefault().getCurrentConnect();
            Map resultResp = (Map)this.restInvoker.invokeGet("propertys/SEND_DICTS_ON_CASHES_BY_URL_HTTP_PREFIX", Map.class);
            if (resultResp != null) {
                String dictUrl = (String)resultResp.get("value");
                Pattern pattern = Pattern.compile("(http.+\\d{1,5})");
                Matcher matcher = pattern.matcher(dictUrl);
                if (matcher.find()) {
                    urlPref = matcher.group();
                    urlPref = StringUtils.replace((String)urlPref, (String)"{host}", (String)currentConnect.getAddress());
                }
            }
        }
        ResponseEntity result = null;
        try {
            result = this.restTemplateForImage.exchange(String.valueOf(urlPref) + "/images/" + usageType + "/" + idType + "/" + id, HttpMethod.GET, null, byte[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            this.imageField.setText("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435!");
            return;
        }
        if (result.getHeaders().getContentLength() > 1000000L) {
            this.imageField.setText("\u0420\u0430\u0437\u043c\u0435\u0440 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u043e\u0439!");
            return;
        }
        Image image = null;
        ImageData data = null;
        ByteArrayInputStream stream = new ByteArrayInputStream((byte[])result.getBody());
        data = new ImageData((InputStream)stream);
        if (data.transparentPixel > 0) {
            image = new Image((Device)Display.getCurrent(), data, data.getTransparencyMask());
        }
        image = new Image((Device)Display.getCurrent(), data);
        try {
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.imageField.setImage(image);
        this.imageField.pack();
        this.imageField.redraw();
    }

    protected String getUsageType(List<Images> images) {
        Integer usageType = 0;
        for (Images i : images) {
            if (i.getUsagetype() == 0) {
                usageType = 0;
                break;
            }
            usageType = i.getUsagetype();
        }
        return Images.getUsagetypeStr((Integer)usageType);
    }

    public void setImageFieldText(String text) {
        this.imageField.setText(text);
    }

    public String getConnectIdForAllDB() {
        WebUser webUser = ArtixAdminActivator.getDefault().getBeanByClass(ManagedWebUserSource.class).getCurrentUser();
        Connect currentConnect = ArtixAdminActivator.getDefault().getCurrentConnect();
        String ip = currentConnect.isMysqlServerSplitConnect() ? currentConnect.getMysqlServerHost() : currentConnect.getAddress();
        String port = currentConnect.getPort();
        String prefix = currentConnect.getPrefix();
        String clusterId = StringUtils.defaultString((String)currentConnect.getClusterId());
        String connectId = String.valueOf(ip) + port + clusterId + prefix + "All" + webUser.getName();
        return connectId;
    }
}

