/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.goods;

import java.io.File;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventCatalog;
import su.artix.cashserver.security.SecurityKey;
import su.artix.widgets.DualSelectionAdapter;
import su.artix.widgets.TextWithClearButton;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.editors.DirectoryChoiceSelectionAdapter;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.view.Base64ImageExtractor;

@SecurityKey(title="\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0438 \u0443 \u0442\u043e\u0432\u0430\u0440\u0430")
public class PicklistInventEditPanel
extends EditorComposite<InventCatalog> {
    private static final Logger log = LoggerFactory.getLogger(PicklistInventEditPanel.class);
    @SecurityKey(title="\u0422\u043e\u0432\u0430\u0440", id="tmc")
    private Label inventLabel;
    @SecurityKey(id="tmc")
    @BindingKey(subField="name")
    private TextWithClearButton inventField;
    @SecurityKey(title="\u0418\u0437\u043e\u0431\u0430\u0440\u0436\u0435\u043d\u0438\u0435", id="image")
    private Label imageLabel;
    @SecurityKey(id="image")
    @BindingKey(bindingType=BindingType.IMAGE)
    private Label imageField;

    public PicklistInventEditPanel(Composite parent, int style, InventCatalog model) {
        super(parent, style, InventCatalog.class, (Object)model);
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        this.inventLabel = new Label((Composite)this, 0);
        this.inventLabel.setText("\u0422\u043e\u0432\u0430\u0440:");
        this.inventField = new TextWithClearButton((Composite)this, 0);
        this.inventField.addSelectionListener((DualSelectionAdapter)new DirectoryChoiceSelectionAdapter(this.getShell(), (Widget)this.inventField.getSelectButtonControl(), this.getModel(), "tmc", Invent.class));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.inventField);
        this.imageLabel = new Label((Composite)this, 0);
        this.imageLabel.setText("\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435:");
        Button button = new Button((Composite)this, 8);
        button.setText("\u0412\u044b\u0431\u0440\u0430\u0442\u044c  \u0444\u0430\u0439\u043b (\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 48\u043a\u0431) ...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String path = PicklistInventEditPanel.openDialogsForSelectImage((Shell)PicklistInventEditPanel.this.getShell());
                if (path != null) {
                    try {
                        String data = DatatypeConverter.printBase64Binary((byte[])FileUtils.readFileToByteArray((File)new File(path)));
                        ((InventCatalog)PicklistInventEditPanel.this.getModel()).setImage(data);
                        PicklistInventEditPanel.this.imageField.setImage(new Base64ImageExtractor().getImage(data));
                        PicklistInventEditPanel.this.imageField.pack();
                        PicklistInventEditPanel.this.imageField.redraw();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
        new Label((Composite)this, 0);
        this.imageField = new Label((Composite)this, 0);
        this.imageField.setSize(new Point(500, 500));
    }

    public void bindValues() {
        this.initDefaulBinding();
    }
}

