/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.notes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import ru.ssa.artixadmin.editors.directory.notes.StringEditDialog;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamContainer;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.images.ArtixAdminImages;

@SecurityKey(title="\u0414\u0438\u0430\u043b\u043e\u0433 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0431\u043e\u0440\u0430")
public class DialogMultiChoiceEditPanel
extends EditorComposite<DialogParamContainer> {
    @SecurityKey(title="\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", id="dialogMultiChoice.title")
    private Label titleLabel;
    @SecurityKey(id="dialogMultiChoice.title")
    private Text titleField;
    private TableViewer tableViewer;
    private ToolBar toolbar;
    private List<String> list = new ArrayList<String>();

    public DialogMultiChoiceEditPanel(Composite parent, int style, DialogParamContainer model) {
        super(parent, style, DialogParamContainer.class, (Object)model);
        if (model.getDialogMultiChoice() != null && model.getDialogMultiChoice().getChoices() != null) {
            this.list = model.getDialogMultiChoice().getChoices();
        }
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo((Composite)this);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this);
        this.titleLabel = new Label((Composite)this, 0);
        this.titleLabel.setText("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a:");
        this.titleField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.titleField);
        Group choicesGroup = new Group((Composite)this, 0);
        choicesGroup.setText("\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u044b \u0432\u044b\u0431\u043e\u0440\u0430");
        GridLayoutFactory.swtDefaults().applyTo((Composite)choicesGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)choicesGroup);
        this.toolbar = new ToolBar((Composite)choicesGroup, 0x800000);
        ToolBarManager toolBarManager = new ToolBarManager(this.toolbar);
        toolBarManager.add((IAction)new AddValueAction());
        final EditValueAction editValueAction = new EditValueAction();
        toolBarManager.add((IAction)editValueAction);
        final RemoveValueAction removeValueAction = new RemoveValueAction();
        toolBarManager.add((IAction)removeValueAction);
        final DownValueAction downValueAction = new DownValueAction();
        toolBarManager.add((IAction)downValueAction);
        final UpValueAction upValueAction = new UpValueAction();
        toolBarManager.add((IAction)upValueAction);
        toolBarManager.update(true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.toolbar);
        this.tableViewer = new TableViewer((Composite)choicesGroup, 68352);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                new EditValueAction().run();
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(250, 100, true));
        this.tableViewer.getTable().setLayout((Layout)tableLayout);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        boolean enableEditAndRemove = !this.tableViewer.getSelection().isEmpty();
        editValueAction.setEnabled(enableEditAndRemove);
        removeValueAction.setEnabled(enableEditAndRemove);
        downValueAction.setEnabled(enableEditAndRemove);
        upValueAction.setEnabled(enableEditAndRemove);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enableEditAndRemove = !event.getSelection().isEmpty();
                editValueAction.setEnabled(enableEditAndRemove);
                removeValueAction.setEnabled(enableEditAndRemove);
                downValueAction.setEnabled(enableEditAndRemove);
                upValueAction.setEnabled(enableEditAndRemove);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableViewer.getTable());
        TableColumn valueColumn = new TableColumn(this.tableViewer.getTable(), 16384);
        valueColumn.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        this.tableViewer.setInput(this.list);
    }

    protected DialogParamContainer getActualModel(DialogParamContainer model) {
        return model;
    }

    public void bindValues() {
        this.initDefaulBinding();
    }

    private class AddValueAction
    extends Action {
        public AddValueAction() {
            super("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/add"));
        }

        public void run() {
            StringEditDialog dialog = new StringEditDialog("");
            if (dialog.open() == 0) {
                DialogMultiChoiceEditPanel.this.list.add(dialog.getValue());
                DialogMultiChoiceEditPanel.this.tableViewer.refresh();
            }
        }
    }

    class DownValueAction
    extends Action {
        public DownValueAction() {
            super("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432\u043d\u0438\u0437", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/down"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogMultiChoiceEditPanel.this.tableViewer.getSelection();
            String entry = (String)structuredSelection.getFirstElement();
            int index = DialogMultiChoiceEditPanel.this.list.indexOf(entry);
            if (index < DialogMultiChoiceEditPanel.this.list.size()) {
                Collections.swap(DialogMultiChoiceEditPanel.this.list, index, index + 1);
                DialogMultiChoiceEditPanel.this.tableViewer.refresh();
            }
        }
    }

    private class EditValueAction
    extends Action {
        public EditValueAction() {
            super("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/edit"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogMultiChoiceEditPanel.this.tableViewer.getSelection();
            String entry = (String)structuredSelection.getFirstElement();
            StringEditDialog dialog = new StringEditDialog(entry);
            if (dialog.open() == 0) {
                int index = DialogMultiChoiceEditPanel.this.list.indexOf(entry);
                DialogMultiChoiceEditPanel.this.list.set(index, dialog.getValue());
                DialogMultiChoiceEditPanel.this.tableViewer.refresh();
            }
        }
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            ((DialogParamContainer)DialogMultiChoiceEditPanel.this.getModel()).getDialogMultiChoice().setChoices(DialogMultiChoiceEditPanel.this.list);
            return ((List)inputElement).toArray();
        }
    }

    class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String entry = (String)element;
            switch (columnIndex) {
                case 0: {
                    return entry;
                }
            }
            return null;
        }
    }

    class RemoveValueAction
    extends Action {
        public RemoveValueAction() {
            super("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/delete"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogMultiChoiceEditPanel.this.tableViewer.getSelection();
            String entry = (String)structuredSelection.getFirstElement();
            DialogMultiChoiceEditPanel.this.list.remove(entry);
            DialogMultiChoiceEditPanel.this.tableViewer.refresh();
        }
    }

    class UpValueAction
    extends Action {
        public UpValueAction() {
            super("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432\u0432\u0435\u0440\u0445", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/up"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogMultiChoiceEditPanel.this.tableViewer.getSelection();
            String entry = (String)structuredSelection.getFirstElement();
            int index = DialogMultiChoiceEditPanel.this.list.indexOf(entry);
            if (index > 0) {
                Collections.swap(DialogMultiChoiceEditPanel.this.list, index - 1, index);
                DialogMultiChoiceEditPanel.this.tableViewer.refresh();
            }
        }
    }
}

