/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.discount;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.editors.directory.goods.PicklistInventEditDialog;
import ru.ssa.artixadmin.view.directory.discount.PicklistInventViewPanel;
import ru.ssa.artixadmin.view.directory.discount.PicklistTableView;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Catalog;
import ru.ssa.cashadmin.domain.InventCatalog;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryAddAction;
import su.artix.yuki.action.DirectoryEditAction;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438. \u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0438. \u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0438")
public class PicklistInventTableView
extends DirectoryTableView<InventCatalog> {
    public static final String ID = "ru.ssa.artixadmin.view.directory.discount.PicklistInventTableView";
    private static final Logger log = LoggerFactory.getLogger(PicklistInventTableView.class);

    public void createPartControl(Composite parent) {
        this.setPojoClass(InventCatalog.class);
        this.setViewPanel((DirectoryViewPanel)new PicklistInventViewPanel(parent, 0, false));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        LazyContentProvider lazyContentProvider = new LazyContentProvider(InventCatalog.class, (TableViewer)this.getViewer());
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)lazyContentProvider);
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns()));
        this.commonActionGroup = new DirectoryEditActionGroup<InventCatalog>(InventCatalog.class){

            protected IAction createEditAction(Class<InventCatalog> e) {
                return new DirectoryEditAction<InventCatalog>(e){

                    protected Dialog getEditor(IWorkbenchWindow window, Object obj) {
                        return new PicklistInventEditDialog(window.getShell(), (InventCatalog)obj, DialogMode.UPDATE);
                    }
                };
            }

            protected DirectoryAddAction<InventCatalog> createAddAction(Class<InventCatalog> e) {
                return new DirectoryAddAction<InventCatalog>(e){

                    protected Dialog getEditor(IWorkbenchWindow window, Object obj) {
                        return new PicklistInventEditDialog(window.getShell(), (InventCatalog)obj, DialogMode.CREATE);
                    }
                };
            }
        }.removeAction(new String[]{"ru.ssa.artixadmin.action.DirectoryCopyAction"});
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        super.createPartControl(parent);
        this.restoreState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
        IStructuredSelection selection = (IStructuredSelection)selectionIn;
        if (part instanceof PicklistTableView) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof Catalog) {
                Catalog selected = (Catalog)selection.getFirstElement();
                InventCatalog state = (InventCatalog)LibActivator.getDefault().getActualClassResolver().getInstance(InventCatalog.class);
                state.setCatalog(selected);
                this.commonActionGroup.getAddAction().setModel((Object)state);
                this.commonActionGroup.getAddAction().setEnabled(true);
                this.getViewPanel().setInput((Object)state);
            } else {
                this.commonActionGroup.getAddAction().setEnabled(false);
            }
        }
    }

    protected String getID() {
        return ID;
    }

    protected boolean isMaster() {
        return false;
    }
}

