/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.columns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.mihalis.opal.columns.ColumnItem;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class ColumnBrowserWidget
extends ScrolledComposite {
    private final List<Table> columns;
    private final Composite composite = new Composite((Composite)this, 0);
    private final Image columnArrow;
    private final List<SelectionListener> selectionListeners;

    public ColumnBrowserWidget(Composite composite, int n) {
        super(composite, n | 0x100 | 0x200);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 1;
        rowLayout.pack = false;
        this.composite.setLayout((Layout)rowLayout);
        this.columnArrow = SWTGraphicUtil.createImageFromFile("images/columnArrow.png");
        this.columns = new ArrayList<Table>();
        for (int i = 0; i < 3; ++i) {
            this.createTable();
        }
        this.columns.get(0).setData((Object)new ColumnItem(this));
        this.setContent((Control)this.composite);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setShowFocusedControl(true);
        this.updateContent();
        this.setMinSize(this.composite.computeSize(-1, -1));
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SWTGraphicUtil.safeDispose((Resource)ColumnBrowserWidget.this.columnArrow);
            }
        });
    }

    private void createTable() {
        Table table = new Table(this.composite, 67844);
        new TableColumn(table, 16384);
        table.setLayoutData((Object)new RowData(150, 175));
        this.columns.add(table);
        this.addTableListeners(table);
        if (super.getBackground() != null && super.getBackground().getRed() != 240 && super.getBackground().getGreen() != 240 && super.getBackground().getBlue() != 240) {
            table.setBackground(super.getBackground());
        }
        table.setBackgroundImage(super.getBackgroundImage());
        table.setBackgroundMode(super.getBackgroundMode());
        table.setCursor(super.getCursor());
        table.setFont(super.getFont());
        table.setForeground(super.getForeground());
        table.setMenu(super.getMenu());
        table.setToolTipText(super.getToolTipText());
    }

    private void addTableListeners(final Table table) {
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int n = table.getSize().x;
                table.getColumn(0).setWidth(n - 5);
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Table table = (Table)event.widget;
                if (table.getSelection() == null || table.getSelection().length != 1) {
                    return;
                }
                ColumnBrowserWidget.this.selectItem(table.getSelection()[0]);
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        Rectangle rectangle = ColumnBrowserWidget.this.columnArrow.getBounds();
                        event.width += rectangle.width;
                        event.height = Math.max(event.height, rectangle.height + 2);
                        break;
                    }
                    case 42: {
                        if (!(event.item instanceof TableItem)) {
                            return;
                        }
                        TableItem tableItem = (TableItem)event.item;
                        if (tableItem.getData() == null) {
                            return;
                        }
                        if (((ColumnItem)tableItem.getData()).getItemCount() == 0) {
                            return;
                        }
                        int n = event.x + event.width;
                        Rectangle rectangle = ColumnBrowserWidget.this.columnArrow.getBounds();
                        int n2 = Math.max(0, (event.height - rectangle.height) / 2);
                        event.gc.drawImage(ColumnBrowserWidget.this.columnArrow, n, event.y + n2);
                        break;
                    }
                }
            }
        };
        table.addListener(41, listener);
        table.addListener(42, listener);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColumnBrowserWidget.this.fireSelectionListeners(selectionEvent);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ColumnBrowserWidget.this.fireSelectionListeners(selectionEvent);
            }
        });
    }

    private boolean fireSelectionListeners(SelectionEvent selectionEvent) {
        Event event = new Event();
        event.button = 0;
        event.display = this.getDisplay();
        event.item = null;
        event.widget = this;
        event.data = null;
        event.time = selectionEvent.time;
        event.x = selectionEvent.x;
        event.y = selectionEvent.y;
        SelectionEvent selectionEvent2 = new SelectionEvent(event);
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(selectionEvent2);
            if (selectionEvent2.doit) continue;
            return false;
        }
        return true;
    }

    private void selectItem(TableItem tableItem) {
        ColumnItem columnItem = (ColumnItem)tableItem.getData();
        if (columnItem.getItemCount() == 0) {
            return;
        }
        int n = this.findSelectedColumn(tableItem);
        boolean bl = false;
        if (n != this.columns.size() - 1) {
            int n2;
            for (n2 = n + 1; n2 < this.columns.size(); ++n2) {
                this.columns.get(n2).setData(null);
                this.columns.get(n2).deselectAll();
            }
            n2 = 0;
            Iterator<Table> iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                Table table = iterator.next();
                if (n2 > n) {
                    table.dispose();
                    iterator.remove();
                    this.setMinSize(this.composite.computeSize(-1, -1));
                }
                ++n2;
            }
            if (n != this.columns.size() - 1) {
                this.columns.get(n + 1).setData((Object)columnItem);
            } else {
                this.createTable();
                this.columns.get(this.columns.size() - 1).setData((Object)columnItem);
            }
            bl = true;
        } else {
            this.createTable();
            bl = true;
            this.columns.get(this.columns.size() - 1).setData((Object)columnItem);
        }
        this.updateContent();
        if (bl) {
            this.composite.pack();
            this.setMinSize(this.composite.computeSize(-1, -1));
        }
        this.columns.get(this.columns.size() - 1).forceFocus();
    }

    private int findSelectedColumn(TableItem tableItem) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).equals(tableItem.getParent())) continue;
            return i;
        }
        return -1;
    }

    void updateContent() {
        if (this.columns == null) {
            return;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Table table = this.columns.get(i);
            int n = table.getSelectionIndex();
            table.removeAll();
            if (table.getData() == null) continue;
            for (ColumnItem columnItem : ((ColumnItem)table.getData()).getItems()) {
                TableItem tableItem = new TableItem(table, 0);
                tableItem.setData((Object)columnItem);
                if (columnItem.getText() != null) {
                    tableItem.setText(columnItem.getText());
                }
                if (columnItem.getImage() == null) continue;
                tableItem.setImage(columnItem.getImage());
            }
            table.setSelection(n);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.add(selectionListener);
    }

    public void clear(boolean bl) {
        Iterator<Table> iterator = this.columns.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Table table = iterator.next();
            if (n >= 3) {
                table.dispose();
                iterator.remove();
            } else {
                if (n != 0) {
                    table.setData(null);
                }
                table.deselectAll();
            }
            ++n;
        }
        this.updateContent();
        if (bl) {
            this.composite.pack();
            this.setMinSize(this.composite.computeSize(-1, -1));
        }
        this.columns.get(0).forceFocus();
    }

    public ColumnItem getSelection() {
        for (int i = this.columns.size() - 1; i >= 0; --i) {
            Table table = this.columns.get(i);
            if (table == null || table.getData() == null || table.getSelection().length == 0) continue;
            return (ColumnItem)table.getItem(table.getSelectionIndex()).getData();
        }
        return null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.remove(selectionListener);
    }

    public void select(ColumnItem columnItem) {
        int n;
        ArrayList<ColumnItem> arrayList = new ArrayList<ColumnItem>();
        this.findElement(columnItem, arrayList);
        Collections.reverse(arrayList);
        if (arrayList.isEmpty()) {
            return;
        }
        this.clear(false);
        for (n = 3; n < arrayList.size(); ++n) {
            this.createTable();
        }
        for (n = 0; n < arrayList.size() - 1; ++n) {
            this.columns.get(n + 1).setData(arrayList.get(n));
        }
        this.updateContent();
        for (n = 0; n < this.columns.size() - 1; ++n) {
            ColumnItem columnItem2 = (ColumnItem)this.columns.get(n + 1).getData();
            for (TableItem tableItem : this.columns.get(n).getItems()) {
                if (tableItem.getData() == null || !tableItem.getData().equals(columnItem2)) continue;
                tableItem.getParent().setSelection(tableItem);
            }
        }
        this.composite.pack();
        this.setMinSize(this.composite.computeSize(-1, -1));
        this.columns.get(this.columns.size() - 1).forceFocus();
    }

    private void findElement(ColumnItem columnItem, List<ColumnItem> list) {
        if (columnItem == null) {
            return;
        }
        list.add(columnItem);
        this.findElement(columnItem.getParentItem(), list);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        for (Table table : this.columns) {
            table.setBackground(color);
        }
    }

    public void setBackgroundMode(int n) {
        super.setBackgroundMode(n);
        for (Table table : this.columns) {
            table.setBackgroundMode(n);
        }
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        for (Table table : this.columns) {
            table.setBackgroundImage(image);
        }
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        for (Table table : this.columns) {
            table.setCursor(cursor);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        for (Table table : this.columns) {
            table.setFont(font);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        for (Table table : this.columns) {
            table.setForeground(color);
        }
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        for (Table table : this.columns) {
            table.setMenu(menu);
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        for (Table table : this.columns) {
            table.setToolTipText(string);
        }
    }

    ColumnItem getRootItem() {
        if (this.columns == null || this.columns.isEmpty()) {
            return null;
        }
        return (ColumnItem)this.columns.get(0).getData();
    }
}

