/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import su.artix.discountmanager.dialogs.discountsystem.ParsedControlsMeta;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionCardControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionCardGroupControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionCatalogControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionChooseConrtol;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionClientControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionDateControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionDateTimeControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionInventBarcodeControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionInventCodeControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionInventGroupControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionMultiDoubleControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionMultiIntControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionMultiSelectControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionMultiStringControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionMultiTextControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionOptionsControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionSelectControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionSpinnerConrtol;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionStringControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionTextControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionTimeControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionValutControl;
import su.artix.yuki.discount.condition.domain.xml.ConstructorWidgetType;

public class DiscountConditionValuePanel
extends Composite {
    private List<ParsedControlsMeta> metas;
    private Map<ParsedControlsMeta, DiscountConditionControl> controlsWithMetaMap;

    public DiscountConditionValuePanel(Composite parent, int style, List<ParsedControlsMeta> metas) {
        super(parent, style);
        this.metas = metas;
        this.controlsWithMetaMap = new LinkedHashMap<ParsedControlsMeta, DiscountConditionControl>(5);
        this.init();
    }

    private void init() {
        DiscountConditionValuePanel mainPanel = this;
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo((Composite)mainPanel);
        Composite innerComposite = new Composite((Composite)mainPanel, 0);
        GridLayoutFactory.swtDefaults().applyTo(innerComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)innerComposite);
        for (ParsedControlsMeta meta : this.metas) {
            DiscountConditionControl newControl = null;
            String labelName = meta.getLabel();
            if (meta.getConstListType() != null) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (Map.Entry<String, String> entry : meta.getValues().entrySet()) {
                    map.put(entry.getKey(), this.getSituatableString(meta.getType(), entry.getValue()));
                }
                switch (meta.getConstListType()) {
                    case Choose: {
                        newControl = new DiscountConditionChooseConrtol(innerComposite, labelName, map, meta.getDefaultValue());
                        break;
                    }
                    case Select: {
                        newControl = new DiscountConditionSelectControl(innerComposite, labelName, map, meta.getDefaultValue());
                        break;
                    }
                    case Multiselect: {
                        newControl = new DiscountConditionMultiSelectControl(innerComposite, labelName, map, meta.getDefaultValue());
                        break;
                    }
                    default: {
                        newControl = new DiscountConditionTextControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                }
            } else {
                switch (meta.getType()) {
                    case Text: {
                        newControl = new DiscountConditionTextControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                    case MultiText: {
                        newControl = new DiscountConditionMultiTextControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                    case String: {
                        newControl = new DiscountConditionStringControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                    case MultiString: {
                        newControl = new DiscountConditionMultiStringControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                    case Double: {
                        int digits = 2;
                        Double d = 0.0;
                        if (meta.getDefaultValue() != null) {
                            try {
                                d = Double.valueOf(meta.getDefaultValue());
                                d = d * Math.pow(10.0, digits);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        newControl = new DiscountConditionSpinnerConrtol(innerComposite, labelName, d.intValue());
                        ((DiscountConditionSpinnerConrtol)newControl).getSpinner().setDigits(digits);
                        ((DiscountConditionSpinnerConrtol)newControl).getSpinner().setIncrement(100);
                        break;
                    }
                    case MultiDouble: {
                        newControl = new DiscountConditionMultiDoubleControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                    case Numeric: {
                        Integer n = 0;
                        if (meta.getDefaultValue() != null) {
                            try {
                                n = Integer.valueOf(meta.getDefaultValue());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        newControl = new DiscountConditionSpinnerConrtol(innerComposite, labelName, n, 1);
                        break;
                    }
                    case Int: {
                        Integer i = 0;
                        if (meta.getDefaultValue() != null) {
                            try {
                                i = Integer.valueOf(meta.getDefaultValue());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        newControl = new DiscountConditionSpinnerConrtol(innerComposite, labelName, i);
                        break;
                    }
                    case MultiInt: {
                        newControl = new DiscountConditionMultiIntControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                    case Date: {
                        newControl = new DiscountConditionDateControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                    case Time: {
                        newControl = new DiscountConditionTimeControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                    case Datetime: {
                        newControl = new DiscountConditionDateTimeControl(innerComposite, labelName);
                        break;
                    }
                    case Code: {
                        newControl = new DiscountConditionInventCodeControl(innerComposite, labelName, meta.getDefaultValue(), false);
                        break;
                    }
                    case Codes: {
                        newControl = new DiscountConditionInventCodeControl(innerComposite, labelName, meta.getDefaultValue(), true);
                        break;
                    }
                    case Barcode: {
                        newControl = new DiscountConditionInventBarcodeControl(innerComposite, labelName, meta.getDefaultValue(), false);
                        break;
                    }
                    case Barcodes: {
                        newControl = new DiscountConditionInventBarcodeControl(innerComposite, labelName, meta.getDefaultValue(), true);
                        break;
                    }
                    case InventGroup: {
                        newControl = new DiscountConditionInventGroupControl(innerComposite, labelName, meta.getDefaultValue(), false);
                        break;
                    }
                    case InventGroups: {
                        newControl = new DiscountConditionInventGroupControl(innerComposite, labelName, meta.getDefaultValue(), true);
                        break;
                    }
                    case Catalog: {
                        newControl = new DiscountConditionCatalogControl(innerComposite, labelName, meta.getDefaultValue(), false);
                        break;
                    }
                    case Catalogs: {
                        newControl = new DiscountConditionCatalogControl(innerComposite, labelName, meta.getDefaultValue(), true);
                        break;
                    }
                    case CatalogsInt: {
                        newControl = new DiscountConditionCatalogControl(innerComposite, labelName, meta.getDefaultValue(), true, true);
                        break;
                    }
                    case Client: {
                        newControl = new DiscountConditionClientControl(innerComposite, labelName, meta.getDefaultValue(), false);
                        break;
                    }
                    case Clients: {
                        newControl = new DiscountConditionClientControl(innerComposite, labelName, meta.getDefaultValue(), true);
                        break;
                    }
                    case InventOption: 
                    case InventOptions: 
                    case ClientOption: 
                    case ClientOptions: {
                        newControl = new DiscountConditionOptionsControl(innerComposite, labelName, meta.getDefaultValue());
                        break;
                    }
                    case Card: {
                        newControl = new DiscountConditionCardControl(innerComposite, labelName, meta.getDefaultValue(), false);
                        break;
                    }
                    case Cards: {
                        newControl = new DiscountConditionCardControl(innerComposite, labelName, meta.getDefaultValue(), true);
                        break;
                    }
                    case CardGroup: {
                        newControl = new DiscountConditionCardGroupControl(innerComposite, labelName, meta.getDefaultValue(), false);
                        break;
                    }
                    case CardGroups: {
                        newControl = new DiscountConditionCardGroupControl(innerComposite, labelName, meta.getDefaultValue(), true);
                        break;
                    }
                    case Valut: {
                        newControl = new DiscountConditionValutControl(innerComposite, labelName, meta.getDefaultValue(), false);
                        break;
                    }
                    case Valuts: {
                        newControl = new DiscountConditionValutControl(innerComposite, labelName, meta.getDefaultValue(), true);
                        break;
                    }
                    default: {
                        newControl = new DiscountConditionTextControl(innerComposite, labelName, meta.getDefaultValue());
                    }
                }
            }
            this.controlsWithMetaMap.put(meta, newControl);
        }
        mainPanel.pack();
    }

    private String getSituatableString(ConstructorWidgetType type, String str) {
        String result = "";
        switch (type) {
            case String: {
                result = "u\"" + str + "\"";
                break;
            }
            case Int: {
                try {
                    Integer i = Double.valueOf(str).intValue();
                    result = i.toString();
                }
                catch (NumberFormatException numberFormatException) {
                    result = str;
                }
                break;
            }
            case Double: {
                try {
                    Double i = Double.valueOf(str);
                    result = i.toString();
                }
                catch (NumberFormatException numberFormatException) {
                    result = str;
                }
                break;
            }
            default: {
                result = str;
            }
        }
        return result;
    }

    public Map<ParsedControlsMeta, DiscountConditionControl> getControlsWithMetaMap() {
        return this.controlsWithMetaMap;
    }
}

