/*
 * Decompiled with CFR 0.152.
 */
package su.artix.widgets.macroparameter;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.widgets.macroparameter.MacroparameterBar;
import su.artix.widgets.macroparameter.SelectMacroparameterDialog;
import su.artix.yuki.discount.macroparameter.domain.xml.Macroparameter;

public class TextWithMacroparameter
extends Composite {
    private static Logger log = LoggerFactory.getLogger(TextWithMacroparameter.class);
    private List<Macroparameter> macroparameters;
    private List<ToolItem> toolItems;
    protected StyledText textControl;
    protected Control[] controls;
    protected int[] offsets;
    private static int MARGIN = 2;
    private static int DEFAULT_SIZE = 100;
    private static String MACROPARAMETER_ICON = "su.artix.widgets.macroparameter.macroparameter_icon";
    private Color color;
    private final transient PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/widgets/16x16/plane/macroparameter.gif");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(MACROPARAMETER_ICON, descriptor);
        }
    }

    public TextWithMacroparameter(Composite parent, int style) {
        this(parent, style, new ArrayList<Macroparameter>());
    }

    public TextWithMacroparameter(Composite parent, int style, List<Macroparameter> macroparameters) {
        super(parent, style);
        this.macroparameters = macroparameters;
        this.controls = new Control[macroparameters.size()];
        this.offsets = new int[macroparameters.size()];
        this.createContents();
    }

    private void createBarControls(Composite parent) {
        this.controls = new Control[DEFAULT_SIZE];
        this.offsets = new int[DEFAULT_SIZE];
        int index = 0;
        for (Macroparameter macro : this.macroparameters) {
            int lastOffset = -1;
            while (lastOffset < this.textControl.getText().lastIndexOf(macro.getId().charValue())) {
                int offset;
                this.offsets[index] = offset = this.textControl.getText().indexOf(macro.getId().charValue(), lastOffset);
                MacroparameterBar control = new MacroparameterBar(parent, 2048);
                control.setTitle(macro.getTitle());
                control.setMacro(macro.getMacro());
                control.setDescription(macro.getDescription());
                this.controls[index] = control;
                lastOffset = offset + 1;
                ++index;
            }
        }
    }

    protected String textToInternalText(String text) {
        return text;
    }

    protected String textToExternalText(String text) {
        return text;
    }

    protected List<ToolItem> createOtherToolItems(ToolBar toolBar) {
        return Collections.emptyList();
    }

    protected void textModified() {
    }

    protected void setChanged() {
        this.firePropertyChange("textControl", null, (Object)this);
    }

    private String textReplaceMacroparameterToChar(String text) {
        String str = new String(text);
        str = this.textToInternalText(str);
        for (Macroparameter macro : this.macroparameters) {
            log.trace("char : {}, to macroparameter : {}", (Object)macro.getId(), (Object)macro.getMacro());
            str = str.replace(macro.getMacro().toString(), macro.getId().toString());
        }
        return str;
    }

    private String textReplaceCharToMacroparameter(String text) {
        String str = new String(text);
        str = this.textToExternalText(str);
        for (Macroparameter macro : this.macroparameters) {
            log.trace("macroparameter : {} to char : {}", (Object)macro.getMacro(), (Object)macro.getId());
            str = str.replace(macro.getId().toString(), macro.getMacro().toString());
        }
        return str;
    }

    protected void createContents() {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(1).applyTo((Composite)this);
        final ToolBar toolBar = new ToolBar((Composite)this, 0x800040);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)toolBar);
        this.toolItems = new ArrayList<ToolItem>();
        ToolItem insertItem = new ToolItem(toolBar, 8);
        insertItem.setToolTipText("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043c\u0430\u043a\u0440\u043e\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
        insertItem.setImage(JFaceResources.getImageRegistry().getDescriptor(MACROPARAMETER_ICON).createImage());
        insertItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectMacroparameterDialog dialog = new SelectMacroparameterDialog(TextWithMacroparameter.this.getShell(), TextWithMacroparameter.this.macroparameters, toolBar.getDisplay().getCursorLocation());
                if (dialog.open() == 0) {
                    Macroparameter macro = dialog.getMacroparameter();
                    int offset = TextWithMacroparameter.this.textControl.getCaretOffset();
                    TextWithMacroparameter.this.textControl.replaceTextRange(offset, 0, macro.getId().toString());
                    int index = 0;
                    while (index < TextWithMacroparameter.this.offsets.length) {
                        if (TextWithMacroparameter.this.offsets[index] == -1 && TextWithMacroparameter.this.controls[index] == null) break;
                        ++index;
                    }
                    if (index == TextWithMacroparameter.this.offsets.length) {
                        int[] tmpOffsets = new int[index + 1];
                        System.arraycopy(TextWithMacroparameter.this.offsets, 0, tmpOffsets, 0, TextWithMacroparameter.this.offsets.length);
                        TextWithMacroparameter.this.offsets = tmpOffsets;
                        Control[] tmpControls = new Control[index + 1];
                        System.arraycopy(TextWithMacroparameter.this.controls, 0, tmpControls, 0, TextWithMacroparameter.this.controls.length);
                        TextWithMacroparameter.this.controls = tmpControls;
                    }
                    TextWithMacroparameter.this.offsets[index] = offset;
                    MacroparameterBar control = new MacroparameterBar((Composite)TextWithMacroparameter.this.textControl, 2048);
                    control.setTitle(macro.getTitle());
                    control.setMacro(macro.getMacro());
                    control.setDescription(macro.getDescription());
                    TextWithMacroparameter.this.controls[index] = control;
                    TextWithMacroparameter.this.addControl((Control)control, offset);
                    TextWithMacroparameter.this.textControl.forceFocus();
                    TextWithMacroparameter.this.textControl.setSelection(TextWithMacroparameter.this.textControl.getSelection().x + 1);
                }
            }
        });
        this.toolItems.add(insertItem);
        this.toolItems.addAll(this.createOtherToolItems(toolBar));
        this.textControl = new StyledText((Composite)this, 2882);
        this.color = this.textControl.getBackground();
        this.textControl.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int start = e.start;
                int replaceCharCount = e.end - e.start;
                int newCharCount = e.text.length();
                int i = 0;
                while (i < TextWithMacroparameter.this.offsets.length) {
                    int offset = TextWithMacroparameter.this.offsets[i];
                    if (start <= offset && offset < start + replaceCharCount) {
                        if (TextWithMacroparameter.this.controls[i] != null && !TextWithMacroparameter.this.controls[i].isDisposed()) {
                            TextWithMacroparameter.this.controls[i].dispose();
                            TextWithMacroparameter.this.controls[i] = null;
                        }
                        offset = -1;
                    }
                    if (offset != -1 && offset >= start) {
                        offset += newCharCount - replaceCharCount;
                    }
                    TextWithMacroparameter.this.offsets[i] = offset;
                    ++i;
                }
            }
        });
        this.textControl.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                StyleRange style = event.style;
                int start = style.start;
                int i = 0;
                while (i < TextWithMacroparameter.this.offsets.length) {
                    int offset = TextWithMacroparameter.this.offsets[i];
                    if (start == offset) {
                        Point pt = TextWithMacroparameter.this.controls[i].getSize();
                        int x = event.x + MARGIN;
                        int y = event.y + event.ascent - 2 * pt.y / 3;
                        TextWithMacroparameter.this.controls[i].setLocation(x, y);
                        break;
                    }
                    ++i;
                }
            }
        });
        this.textControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextWithMacroparameter.this.textModified();
                TextWithMacroparameter.this.setChanged();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.textControl);
    }

    private void addControl(Control control, int offset) {
        StyleRange style = new StyleRange();
        style.start = offset;
        style.length = 1;
        control.pack();
        Rectangle rect = control.getBounds();
        int ascent = 2 * rect.height / 3;
        int descent = rect.height - ascent;
        style.metrics = new GlyphMetrics(ascent + MARGIN, descent + MARGIN, rect.width + 2 * MARGIN);
        this.textControl.setStyleRange(style);
    }

    public void refresh() {
        this.createBarControls((Composite)this.textControl);
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null) {
                this.addControl(this.controls[i], this.offsets[i]);
            }
            ++i;
        }
    }

    public String getText() {
        return this.textReplaceCharToMacroparameter(this.textControl.getText());
    }

    public void setText(String text) {
        this.textControl.setText(this.textReplaceMacroparameterToChar(text));
        this.refresh();
    }

    public List<Macroparameter> getMacroparameters() {
        return this.macroparameters;
    }

    public void setMacroparameters(List<Macroparameter> macroparameters) {
        this.macroparameters = macroparameters;
    }

    public void addListener(int eventType, Listener listener) {
        if (eventType == 24) {
            this.textControl.addListener(eventType, listener);
        } else {
            super.addListener(eventType, listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (eventType == 24) {
            this.textControl.removeListener(eventType, listener);
        } else {
            super.removeListener(eventType, listener);
        }
    }

    public void setEnabled(boolean enabled) {
        for (ToolItem toolItem : this.toolItems) {
            toolItem.setEnabled(enabled);
        }
        this.textControl.setEnabled(enabled);
        if (enabled) {
            this.textControl.setBackground(this.color);
        } else {
            this.textControl.setBackground(this.getBackground());
        }
        Control[] controlArray = this.controls;
        int n = this.controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control != null) {
                control.setEnabled(enabled);
            }
            ++n2;
        }
        super.setEnabled(enabled);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

