/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.ganttchart.AbstractGanttEvent;
import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.nebula.widgets.ganttchart.IGanttChartItem;

public class GanttGroup
extends AbstractGanttEvent
implements IGanttChartItem {
    public static final int FIXED_ROW_HEIGHT_AUTOMATIC = -1;
    private final List _events;
    private int _fixedRowHeight = -1;
    private int _vAlignment = 128;
    private final GanttChart _chart;

    public GanttGroup(GanttChart parent) {
        this._chart = parent;
        this._events = new ArrayList();
        parent.addGroup(this);
    }

    public void addEvent(GanttEvent event) {
        if (!this._events.contains(event)) {
            this._events.add(event);
        }
        event.setGanttGroup(this);
    }

    public void removeEvent(GanttEvent event) {
        if (event.getGanttGroup() == this) {
            event.setGanttGroup(null);
        }
        this._events.remove(event);
    }

    public boolean containsEvent(GanttEvent event) {
        return this._events.contains(event);
    }

    public List getEventMembers() {
        return this._events;
    }

    public int getFixedRowHeight() {
        return this._fixedRowHeight;
    }

    public void setFixedRowHeight(int fixedRowHeight) {
        this._fixedRowHeight = fixedRowHeight;
    }

    public boolean isAutomaticRowHeight() {
        return this.getFixedRowHeight() == -1;
    }

    public void setAutomaticRowHeight() {
        this.setFixedRowHeight(-1);
    }

    public int getVerticalEventAlignment() {
        return this._vAlignment;
    }

    public void setVerticalEventAlignment(int vAlignment) {
        this._vAlignment = vAlignment;
    }

    public void dispose() {
        this._chart.removeGroup(this);
        this._chart.redraw();
    }

    int getTallestEvent() {
        int max = 0;
        for (int i = 0; i < this._events.size(); ++i) {
            GanttEvent event = (GanttEvent)this._events.get(i);
            max = Math.max(event.getHeight(), max);
        }
        return max;
    }

    public String toString() {
        return "[GanttGroup " + this._events.toString() + "]";
    }
}

