/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import su.artix.discountmanagercore.holders.PropertiesHolder;

public class XMLFileDialog {
    private FileDialog fileDialog;

    public XMLFileDialog(int style) {
        this.fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), style);
        String[] filterExtensions = new String[]{"*.xml"};
        String filterPath = PropertiesHolder.INSTANCE.getCommonsProperty("SYSTEM.PATHTOEXPORTEDFILELIN", "/");
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterPath = PropertiesHolder.INSTANCE.getCommonsProperty("SYSTEM.PATHTOEXPORTEDFILEWIN", "C:\\");
            filterExtensions = new String[]{"*.xml"};
        }
        this.fileDialog.setFilterExtensions(filterExtensions);
        this.fileDialog.setFilterPath(filterPath);
    }

    public String open() {
        String file = this.fileDialog.open();
        if (file != null) {
            String platform = SWT.getPlatform();
            if (platform.equals("win32") || platform.equals("wpf")) {
                PropertiesHolder.INSTANCE.setCommonsProperty("SYSTEM.PATHTOEXPORTEDFILEWIN", file);
            } else {
                PropertiesHolder.INSTANCE.setCommonsProperty("SYSTEM.PATHTOEXPORTEDFILELIN", file);
            }
        }
        return file;
    }
}

