/*
 * Decompiled with CFR 0.152.
 */
package su.artix.accounting.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import su.artix.accounting.domain.Account;
import su.artix.accounting.domain.AdditionalAssetInfo;
import su.artix.accounting.domain.AssetGroup;
import su.artix.accounting.domain.AssetStatus;
import su.artix.accounting.domain.AssetTransactionStatus;
import su.artix.accounting.domain.Card;
import su.artix.accounting.domain.Terminal;
import su.artix.accounting.domain.TransactionStatus;

@Entity
@Table(name="asset")
@Document
@CompoundIndexes(value={@CompoundIndex(name="assetGroup_id", def="{ assetGroup._id : 1 }"), @CompoundIndex(name="card_and_date_index", def="{ card.$id : 1 , date: 1 }"), @CompoundIndex(name="account_and_date_index", def="{ account.$id : 1 , date: 1 }"), @CompoundIndex(name="account_ref_index", def="{ account: 1 }"), @CompoundIndex(name="card_ref_index", def="{ card: 1 }")})
public class Asset
implements Serializable {
    private static final long serialVersionUID = 6549971821678357058L;
    private Long idAsset;
    @Id
    private String id_mongo;
    private long amount;
    @Indexed
    private String sessionId;
    @DBRef(db="account")
    private Account account;
    @DBRef(db="terminal")
    private Terminal terminal;
    private AssetGroup assetGroup;
    @DBRef(db="card")
    private Card card;
    private AssetStatus status;
    private TransactionStatus lastStatus;
    private List<AssetTransactionStatus> transactionStatuses;
    @Indexed(name="dateIndex")
    private Date date;
    @Embedded
    private AdditionalAssetInfo additionalInfo;

    @Transient
    public String getId_mongo() {
        return this.id_mongo;
    }

    public void setId_mongo(String id_mongo) {
        this.id_mongo = id_mongo;
    }

    @javax.persistence.Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.idAsset;
    }

    public void setId(Long id) {
        this.idAsset = id;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    @Enumerated(value=EnumType.STRING)
    public AssetStatus getStatus() {
        return this.status;
    }

    public void setStatus(AssetStatus status) {
        this.status = status;
    }

    @ManyToOne
    @JoinColumn(name="accountNumber", referencedColumnName="number")
    public Account getAccount() {
        return this.account;
    }

    @ManyToOne
    @JoinColumn(name="terminalNumber", referencedColumnName="terminalId")
    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @ManyToOne
    @JoinColumn(name="cardNumber", referencedColumnName="number")
    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    @Transient
    public Iterator<AssetTransactionStatus> getTransactions() {
        return this.transactionStatuses.iterator();
    }

    @Enumerated(value=EnumType.STRING)
    public TransactionStatus getLastStatus() {
        return this.lastStatus;
    }

    public void setLastStatus(TransactionStatus lastStatus) {
        this.lastStatus = lastStatus;
    }

    public void addAssetTrasactionStatus(AssetTransactionStatus assetTransactionStatus) {
        if (this.transactionStatuses == null) {
            this.transactionStatuses = new ArrayList<AssetTransactionStatus>();
        }
        this.transactionStatuses.add(assetTransactionStatus);
        this.lastStatus = assetTransactionStatus.getTransactionStatus();
    }

    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="asset_id")
    public List<AssetTransactionStatus> getTransactionStatuses() {
        return this.transactionStatuses;
    }

    public void setTransactionStatuses(List<AssetTransactionStatus> transactionStatuses) {
        this.transactionStatuses = transactionStatuses;
    }

    public AdditionalAssetInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(AdditionalAssetInfo additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @ManyToOne
    @JoinColumn(name="assetGroupId", referencedColumnName="internalId")
    public AssetGroup getAssetGroup() {
        return this.assetGroup;
    }

    public void setAssetGroup(AssetGroup assetGroup) {
        this.assetGroup = assetGroup;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Asset [idAsset=");
        builder.append(this.idAsset);
        builder.append(", amount=");
        builder.append(this.amount);
        builder.append(", sessionId=");
        builder.append(this.sessionId);
        builder.append(", account=");
        builder.append(this.account);
        builder.append(", terminal=");
        builder.append(this.terminal);
        builder.append(", assetGroup=");
        builder.append(this.assetGroup);
        builder.append(", card=");
        builder.append(this.card);
        builder.append(", status=");
        builder.append((Object)this.status);
        builder.append(", lastStatus=");
        builder.append((Object)this.lastStatus);
        builder.append(", date=");
        builder.append(this.date);
        builder.append(", additionalInfo=");
        builder.append(this.additionalInfo);
        builder.append("]");
        return builder.toString();
    }
}

