/*
 * Decompiled with CFR 0.152.
 */
package su.artix.accounting.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.springframework.data.mongodb.core.mapping.DBRef;
import su.artix.accounting.domain.Card;
import su.artix.accounting.domain.CardStatus;
import su.artix.accounting.domain.Terminal;

@Entity
@Table(name="cardTransaction")
public class CardTransaction
implements Serializable {
    private static final long serialVersionUID = 5913572563484203104L;
    private Long id;
    private Date operationDate;
    @DBRef(db="terminal")
    private Terminal terminal;
    private CardStatus status;
    private Card card;
    private String accountNumber;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getOperationDate() {
        return this.operationDate;
    }

    public void setOperationDate(Date operationDate) {
        this.operationDate = operationDate;
    }

    @ManyToOne
    @JoinColumn(name="terminalNumber", referencedColumnName="terminalId")
    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    @Enumerated(value=EnumType.STRING)
    public CardStatus getStatus() {
        return this.status;
    }

    public void setStatus(CardStatus status) {
        this.status = status;
    }

    @ManyToOne
    @JoinColumn(name="card_id", insertable=false, updatable=false)
    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }
}

