/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.dao;

import java.util.Iterator;
import javax.persistence.ManyToOne;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.impl.CriteriaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.DomainUtils;
import ru.ssa.cashadmin.dao.FilteredCollection;

public class AbstractCriteriaWorker<E> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCriteriaWorker.class);
    private Class<E> clazz;

    public AbstractCriteriaWorker(Class<E> clazz) {
        this.clazz = clazz;
    }

    public void updateOrder(String sortby, boolean sortAsc, DetachedCriteria criteria, Session session) {
        log.trace("sortby = {} , sortAsc={}", (Object)sortby, (Object)sortAsc);
        if (sortby != null && sortby.length() > 0) {
            int dotIndex = sortby.lastIndexOf(46);
            if (dotIndex >= 0) {
                String alias = sortby.substring(0, dotIndex);
                String property = sortby.substring(dotIndex);
                Criteria simpleCriteria = criteria.getExecutableCriteria(session);
                CriteriaImpl criteriaImpl = (CriteriaImpl)simpleCriteria;
                Iterator it = criteriaImpl.iterateSubcriteria();
                boolean hasSubCriteria = false;
                while (it.hasNext()) {
                    CriteriaImpl.Subcriteria subCriteria = (CriteriaImpl.Subcriteria)it.next();
                    if (!alias.equals(subCriteria.getAlias())) continue;
                    hasSubCriteria = true;
                    break;
                }
                if (hasSubCriteria) {
                    this.addOrder(sortAsc, criteria, String.valueOf(alias) + property);
                } else {
                    criteria.createAlias(alias, "sortAlias", 1);
                    this.addOrder(sortAsc, criteria, "sortAlias" + property);
                }
            } else {
                this.addOrder(sortAsc, criteria, sortby);
            }
        }
    }

    private void addOrder(boolean sortAsc, DetachedCriteria criteria, String property) {
        if (sortAsc) {
            criteria.addOrder(Order.asc((String)property));
        } else {
            criteria.addOrder(Order.desc((String)property));
        }
    }

    public void createEntityExampleCriteria(E state, DetachedCriteria criteria) {
        criteria.add((Criterion)Example.create(state));
    }

    public void addPrimaryKeyCriteria(Object state, DetachedCriteria criteria) {
        Object idValue;
        if (!DomainUtils.isComposite(state.getClass(), DomainUtils.getIdColum(state.getClass())) && (idValue = DomainUtils.getIdValue(state)) != null) {
            criteria.add(Restrictions.idEq((Object)idValue));
        }
    }

    public void addAssociatedCriteria(Object state, DetachedCriteria criteria) {
        for (String field : DomainUtils.getAnnotationField(state.getClass(), ManyToOne.class, false)) {
            Object fieldValue = DomainUtils.getFieldValue(field, state);
            log.trace("create subcriteria with alias for {}", (Object)field);
            DetachedCriteria fieldCriteria = criteria.createCriteria(field, field, 1);
            if (fieldValue == null) continue;
            String assField = DomainUtils.getIdColum(fieldValue.getClass());
            Object assId = DomainUtils.getIdValue(fieldValue);
            log.trace("add id criteria for field={},value={}", (Object)field, fieldValue);
            log.trace("assField={},assId={}", (Object)assField, assId);
            if (assId != null) {
                fieldCriteria.add(Restrictions.idEq((Object)assId));
            } else {
                this.createAssociatedExampleCriteria(fieldValue, fieldCriteria);
            }
            this.addAssociatedCriteria(fieldValue, fieldCriteria);
        }
    }

    public void createAssociatedExampleCriteria(Object fieldValue, DetachedCriteria fieldCriteria) {
        fieldCriteria.add((Criterion)Example.create((Object)fieldValue));
    }

    public void addCollectionCriteria(E state, DetachedCriteria criteria) {
        for (String field : DomainUtils.getAnnotationField(this.clazz, FilteredCollection.class, false)) {
            Object fieldValue = DomainUtils.getFieldValue(field, state);
            if (fieldValue == null) continue;
            log.trace("add collection criteria for field={},value={}", (Object)field, fieldValue);
            boolean has = false;
            Disjunction disjunction = Restrictions.disjunction();
            for (Object element : (Iterable)fieldValue) {
                disjunction.add((Criterion)Example.create(element));
                has = true;
            }
            if (!has) continue;
            criteria.createCriteria(field).add((Criterion)disjunction);
        }
    }
}

