/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.ganttchart.AdvancedTooltip;
import org.eclipse.nebula.widgets.ganttchart.ColorCache;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.IColorManager;
import org.eclipse.nebula.widgets.ganttchart.Utils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class AdvancedTooltipDialog {
    private static Shell _shell;

    public static void makeDialog(AdvancedTooltip toolTip, IColorManager colorManager, Point location) {
        AdvancedTooltipDialog.makeDialog(toolTip, colorManager, location, null, null, null);
    }

    public static void makeDialog(final AdvancedTooltip toolTip, final IColorManager colorManager, Point location, final String titleOverride, final String contentOverride, String helpOverride) {
        if (_shell != null && !_shell.isDisposed()) {
            _shell.dispose();
        }
        _shell = new Shell(Display.getDefault().getActiveShell(), 540684);
        _shell.setLayout((Layout)new FillLayout());
        final Composite comp = new Composite((Composite)_shell, 0x200C0000);
        comp.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                AdvancedTooltipDialog.kill();
            }
        });
        comp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Region region = new Region((Device)_shell.getDisplay());
                GC gc = e.gc;
                Rectangle bounds = comp.getBounds();
                AdvancedTooltipDialog.drawBorders(gc, colorManager, bounds);
                int marginTop = 8;
                int marginLeft = 6;
                int marginRight = 6;
                int marginBottom = 12;
                int x = marginLeft;
                int y = marginTop;
                int xMax = 0;
                int yMax = 0;
                Font bold = null;
                Font old = gc.getFont();
                bold = Utils.applyBoldFont(old);
                String title = toolTip.getTitle();
                if (titleOverride != null) {
                    title = titleOverride;
                }
                if (title != null && title.length() > 0) {
                    gc.setForeground(colorManager.getAdvancedTooltipTextColor());
                    gc.setFont(bold);
                    Point point = gc.stringExtent(title);
                    AdvancedTooltipDialog.drawText(gc, title, x, y);
                    gc.setFont(old);
                    xMax = Math.max(xMax, x + point.x);
                    yMax = Math.max(yMax, y += point.y);
                }
                Image bigImage = toolTip.getImage();
                int imageY = y;
                if (bigImage != null) {
                    Rectangle imBounds = bigImage.getBounds();
                    gc.drawImage(bigImage, x += 9, y + 12);
                    x += imBounds.width;
                    imageY += imBounds.height + 12;
                }
                int textY = y;
                String content = toolTip.getContent();
                if (contentOverride != null) {
                    content = contentOverride;
                }
                if (content != null && content.length() > 0) {
                    x = bigImage == null ? (x += 8) : (x += 13);
                    textY += 13;
                    StringTokenizer tokenizer = new StringTokenizer(content, "\n");
                    int widestLine = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        Point extent = AdvancedTooltipDialog.drawText(gc, token, x, textY);
                        textY += extent.y;
                        widestLine = Math.max(widestLine, extent.x);
                    }
                    x += widestLine;
                }
                y = Math.max(textY, imageY);
                xMax = Math.max(xMax, x);
                yMax = Math.max(yMax, y);
                if (toolTip.getHelpImage() != null || toolTip.getHelpText() != null) {
                    gc.setForeground(colorManager.getAdvancedTooltipDividerColor());
                    gc.drawLine(marginLeft, y += 8, marginLeft + xMax, y);
                    gc.setForeground(colorManager.getAdvancedTooltipDividerShadowColor());
                    gc.drawLine(marginLeft, ++y, marginLeft + xMax, y);
                    y += 7;
                    gc.setForeground(colorManager.getAdvancedTooltipTextColor());
                    gc.setFont(bold);
                    int curX = marginLeft;
                    int widthUsed = 0;
                    if (toolTip.getHelpImage() != null) {
                        gc.drawImage(toolTip.getHelpImage(), marginLeft, y);
                        curX += toolTip.getHelpImage().getBounds().width;
                        widthUsed += (curX += 9) - marginLeft;
                    }
                    if (toolTip.getHelpText() != null) {
                        Point helpSize = gc.stringExtent(toolTip.getHelpText());
                        gc.drawString(toolTip.getHelpText(), curX, y, true);
                        widthUsed += helpSize.x;
                    }
                    xMax = Math.max(xMax, widthUsed);
                    yMax = Math.max(yMax, y);
                }
                region.add(0, 0, xMax += marginLeft + marginRight, yMax += marginTop + marginBottom);
                region.subtract(0, 0, 1, 1);
                region.subtract(xMax - 1, yMax - 1, 1, 1);
                region.subtract(0, yMax - 1, 1, 1);
                region.subtract(xMax - 1, 0, 1, 1);
                if (GanttComposite._osType != 2) {
                    _shell.setRegion(region);
                }
                Rectangle size = region.getBounds();
                _shell.setSize(size.width, size.height);
                if (bold != null) {
                    bold.dispose();
                }
                Monitor active = null;
                try {
                    active = Display.getDefault().getActiveShell().getMonitor();
                }
                catch (Exception err) {
                    active = Display.getDefault().getPrimaryMonitor();
                }
                int totalXBounds = 0;
                Monitor[] all = Display.getDefault().getMonitors();
                for (int i = 0; i < all.length && all[i] != active; ++i) {
                    totalXBounds += all[i].getBounds().width;
                }
                Rectangle maxBounds = active.getBounds();
                int shellHeight = _shell.getSize().y;
                int shellWidth = _shell.getSize().x;
                Point location = _shell.getLocation();
                if (location.y + shellHeight > maxBounds.height) {
                    location.y = maxBounds.height - shellHeight;
                }
                if (location.x + shellWidth > totalXBounds) {
                    location.x = totalXBounds - shellWidth;
                }
                _shell.setLocation(location);
            }
        });
        _shell.pack();
        _shell.setLocation(location);
        _shell.setVisible(true);
        if (GanttComposite._osType == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    _shell.redraw();
                }
            });
        }
    }

    private static void drawBorders(GC gc, IColorManager colorManager, Rectangle bounds) {
        gc.setForeground(colorManager.getAdvancedTooltipInnerFillTopColor());
        gc.setBackground(colorManager.getAdvancedTooltipInnerFillBottomColor());
        gc.fillGradientRectangle(bounds.x, bounds.y, bounds.width, bounds.height, true);
        gc.setForeground(colorManager.getAdvancedTooltipBorderColor());
        gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        gc.setForeground(colorManager.getAdvancedTooltipShadowCornerOuterColor());
        gc.drawLine(bounds.x + 1, bounds.y, bounds.x + 1, bounds.y);
        gc.drawLine(bounds.x, bounds.y + 1, bounds.x, bounds.y + 1);
        gc.drawLine(bounds.x + bounds.width - 2, bounds.y, bounds.x + bounds.width - 2, bounds.y);
        gc.drawLine(bounds.x + bounds.width - 1, bounds.y + 1, bounds.x + bounds.width - 1, bounds.y + 1);
        gc.drawLine(bounds.x + bounds.width - 1, bounds.y + bounds.height - 2, bounds.x + bounds.width - 1, bounds.y + bounds.height - 2);
        gc.drawLine(bounds.x + bounds.width - 2, bounds.y + bounds.height - 1, bounds.x + bounds.width - 2, bounds.y + bounds.height - 1);
        gc.drawLine(bounds.x + 1, bounds.y + bounds.height - 1, bounds.x + 1, bounds.y + bounds.height - 1);
        gc.drawLine(bounds.x, bounds.y + bounds.height - 2, bounds.x, bounds.y + bounds.height - 2);
        gc.setForeground(colorManager.getAdvancedTooltipShadowCornerInnerColor());
        gc.drawLine(bounds.x + 2, bounds.y, bounds.x + 2, bounds.y);
        gc.drawLine(bounds.x, bounds.y + 2, bounds.x, bounds.y + 2);
        gc.drawLine(bounds.x + bounds.width - 3, bounds.y, bounds.x + bounds.width - 3, bounds.y);
        gc.drawLine(bounds.x + bounds.width - 1, bounds.y + 2, bounds.x + bounds.width - 1, bounds.y + 2);
        gc.drawLine(bounds.x + bounds.width - 1, bounds.y + bounds.height - 3, bounds.x + bounds.width - 1, bounds.y + bounds.height - 3);
        gc.drawLine(bounds.x + bounds.width - 3, bounds.y + bounds.height - 1, bounds.x + bounds.width - 3, bounds.y + bounds.height - 1);
        gc.drawLine(bounds.x + 2, bounds.y + bounds.height - 1, bounds.x + 2, bounds.y + bounds.height - 1);
        gc.drawLine(bounds.x, bounds.y + bounds.height - 3, bounds.x, bounds.y + bounds.height - 3);
        gc.setForeground(colorManager.getAdvancedTooltipShadowInnerCornerColor());
        gc.drawLine(bounds.x + 1, bounds.y + 1, bounds.x + 1, bounds.y + 1);
        gc.drawLine(bounds.x + bounds.width - 2, bounds.y + 1, bounds.x + bounds.width - 2, bounds.y + 1);
        gc.drawLine(bounds.x + bounds.width - 2, bounds.y + bounds.height - 2, bounds.x + bounds.width - 2, bounds.y + bounds.height - 2);
        gc.drawLine(bounds.x + 1, bounds.y + bounds.height - 2, bounds.x + 1, bounds.y + bounds.height - 2);
    }

    private static Point drawText(GC gc, String text, int x, int y) {
        try {
            Font old = gc.getFont();
            Font used = null;
            String oldName = old.getFontData()[0].getName();
            int oldSize = (int)old.getFontData()[0].height;
            int curX = x;
            boolean bold = false;
            boolean italic = false;
            int size = oldSize;
            Color fg = ColorCache.getBlack();
            int maxWidth = 0;
            int maxHeight = 0;
            char[] all = text.toCharArray();
            for (int i = 0; i < all.length; ++i) {
                String token = Character.toString(all[i]);
                if ("\\".equals(token)) {
                    StringBuffer buf = new StringBuffer(token);
                    buf.append(Character.toString(all[i + 1]));
                    token = buf.toString();
                    ++i;
                }
                if (AdvancedTooltipDialog.isNormalize(token)) {
                    bold = false;
                    italic = false;
                    size = oldSize;
                    fg = ColorCache.getBlack();
                } else {
                    int newSize = AdvancedTooltipDialog.getSize(token);
                    if (newSize != size && newSize != -1) {
                        size = newSize;
                    }
                    boolean newBold = AdvancedTooltipDialog.isBold(token);
                    bold = bold && !newBold ? true : newBold;
                    boolean newItalic = AdvancedTooltipDialog.isItalic(token);
                    italic = italic && !newItalic ? true : newItalic;
                    if (text.length() > i + 10 && "\\c".equals(token)) {
                        String colTxt = text.substring(i - 1, i + 10);
                        Color newColor = AdvancedTooltipDialog.getColor(colTxt);
                        if (newColor != null) {
                            i += colTxt.length() - 2;
                            token = colTxt;
                        }
                        if (!newColor.equals((Object)fg)) {
                            fg = newColor;
                        }
                    }
                }
                if (fg != null) {
                    gc.setForeground(fg);
                }
                token = AdvancedTooltipDialog.cleanUp(token);
                int style = 0;
                if (bold) {
                    style |= 1;
                }
                if (italic) {
                    style |= 2;
                }
                if (all[i] == '\t') {
                    curX += gc.stringExtent((String)" ").x * 4;
                    token = " ";
                }
                used = new Font((Device)Display.getDefault(), oldName, size, style);
                gc.setFont(used);
                if (token.length() != 0) {
                    gc.drawString(token, curX, y, true);
                    int extX = gc.stringExtent((String)token).x;
                    int extY = gc.stringExtent((String)token).y;
                    maxWidth = Math.max(maxWidth, curX += extX);
                    maxHeight = Math.max(maxHeight, extY);
                }
                used.dispose();
            }
            gc.setFont(old);
            return new Point(maxWidth - x, maxHeight);
        }
        catch (Exception err) {
            SWT.error((int)1, (Throwable)err);
            return null;
        }
    }

    private static String cleanUp(String string) {
        String str = string;
        int start = str.indexOf("\\s");
        if (start != -1) {
            String left = str.substring(0, start);
            String right = str.substring(start + 4, str.length());
            str = left + right;
        }
        str = str.replaceAll("\\\\ce", "");
        str = str.replaceAll("\\\\c[0-9]{9}", "");
        str = str.replaceAll("\\\\x", "");
        str = str.replaceAll("\\\\b", "");
        return str;
    }

    private static boolean isNormalize(String str) {
        return str.indexOf("\\x") > -1;
    }

    private static boolean isBold(String str) {
        return str.indexOf("\\b") > -1;
    }

    private static boolean isItalic(String str) {
        return str.indexOf("\\i") > -1;
    }

    private static int getSize(String str) {
        int start = str.indexOf("\\s");
        if (start == -1) {
            return -1;
        }
        String size = str.substring(start + 2, start + 4);
        try {
            return Integer.parseInt(size);
        }
        catch (Exception badParse) {
            SWT.error((int)1, (Throwable)badParse);
            return -1;
        }
    }

    private static Color getColor(String str) {
        int start = str.indexOf("\\c");
        if (start == -1) {
            return null;
        }
        if (str.indexOf("\\ce") != -1) {
            return ColorCache.getBlack();
        }
        try {
            int red = Integer.parseInt(str.substring(start + 2, start + 5));
            int green = Integer.parseInt(str.substring(start + 5, start + 8));
            int blue = Integer.parseInt(str.substring(start + 8, start + 11));
            return ColorCache.getColor(red, green, blue);
        }
        catch (Exception err) {
            SWT.error((int)1, (Throwable)err);
            return ColorCache.getBlack();
        }
    }

    public static void kill() {
        if (_shell != null && !_shell.isDisposed()) {
            _shell.dispose();
        }
    }

    public static boolean isActive() {
        return _shell != null && !_shell.isDisposed();
    }
}

