/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.payment;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;
import ru.ssa.cashadmin.dao.FilteredCollection;
import ru.ssa.cashadmin.domain.payment.Accountmask;
import ru.ssa.cashadmin.domain.payment.Category;
import ru.ssa.cashadmin.domain.payment.Defcode;
import ru.ssa.cashadmin.domain.payment.Extendedparameter;
import ru.ssa.cashadmin.domain.payment.Terminal;

@Entity
@Table(name="provider")
@MappedSuperclass
public class Provider
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Integer providerid;
    @NotNull
    @Length(max=100, min=1)
    private String providercode;
    @NotNull
    @Column(insertable=false, updatable=false)
    private Integer terminalid;
    @NotNull
    @ManyToOne
    @JoinColumn(name="terminalid")
    @NotFound(action=NotFoundAction.IGNORE)
    private Terminal terminal;
    @NotNull
    @Column(insertable=false, updatable=false)
    private Integer categoryid;
    @NotNull
    @ManyToOne
    @JoinColumn(name="categoryid")
    @NotFound(action=NotFoundAction.IGNORE)
    private Category category;
    @Length(max=100)
    private String name;
    @Length(max=100)
    private String inn;
    @Length(max=100)
    private String phone;
    @Length(max=255)
    private String address;
    @Length(max=255)
    private String accountmask;
    private BigDecimal minsum;
    private BigDecimal maxsum;
    @Length(max=255)
    private String bcodemask;
    @Length(max=255)
    private String bcodetransform;
    @Length(max=255)
    private String inputmask;
    @Length(max=255)
    private String inputtransform;
    @Length(max=255)
    private String accountdatamask;
    @Length(max=255)
    private String accountdatatransform;
    @OneToMany(mappedBy="providerid", cascade={CascadeType.ALL})
    @FilteredCollection
    private List<Defcode> defcodes = new ArrayList<Defcode>();
    @OneToMany(mappedBy="providerid", cascade={CascadeType.ALL})
    private List<Accountmask> accountmasks = new ArrayList<Accountmask>();
    @OneToMany(mappedBy="providerid", cascade={CascadeType.ALL})
    private List<Extendedparameter> extendedparameters = new ArrayList<Extendedparameter>();

    public Integer getTerminalid() {
        return this.terminalid;
    }

    public void setTerminalid(Integer terminalid) {
        this.terminalid = terminalid;
    }

    protected Provider() {
    }

    public Integer getProviderid() {
        return this.providerid;
    }

    public void setProviderid(Integer providerid) {
        this.providerid = providerid;
    }

    public String getProvidercode() {
        return this.providercode;
    }

    public void setProvidercode(String providercode) {
        this.providercode = providercode;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
        this.terminalid = terminal != null ? terminal.getTerminalid() : null;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
        this.categoryid = category != null ? category.getCategoryid() : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInn() {
        return this.inn;
    }

    public void setInn(String inn) {
        this.inn = inn;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAccountmask() {
        return this.accountmask;
    }

    public void setAccountmask(String accountmask) {
        this.accountmask = accountmask;
    }

    public BigDecimal getMinsum() {
        return this.minsum;
    }

    public void setMinsum(BigDecimal minsum) {
        this.minsum = minsum;
    }

    public BigDecimal getMaxsum() {
        return this.maxsum;
    }

    public void setMaxsum(BigDecimal maxsum) {
        this.maxsum = maxsum;
    }

    public String getBcodemask() {
        return this.bcodemask;
    }

    public void setBcodemask(String bcodemask) {
        this.bcodemask = bcodemask;
    }

    public String getBcodetransform() {
        return this.bcodetransform;
    }

    public void setBcodetransform(String bcodetransform) {
        this.bcodetransform = bcodetransform;
    }

    public String getInputmask() {
        return this.inputmask;
    }

    public void setInputmask(String inputmask) {
        this.inputmask = inputmask;
    }

    public String getInputtransform() {
        return this.inputtransform;
    }

    public void setInputtransform(String inputtransform) {
        this.inputtransform = inputtransform;
    }

    public String getAccountdatamask() {
        return this.accountdatamask;
    }

    public void setAccountdatamask(String accountdatamask) {
        this.accountdatamask = accountdatamask;
    }

    public String getAccountdatatransform() {
        return this.accountdatatransform;
    }

    public void setAccountdatatransform(String accountdatatransform) {
        this.accountdatatransform = accountdatatransform;
    }

    public void setDefcodes(List<Defcode> defcodes) {
        this.defcodes = defcodes;
    }

    public List<Defcode> getDefcodes() {
        return this.defcodes;
    }

    public void setAccountmasks(List<Accountmask> accountmasks) {
        this.accountmasks = accountmasks;
    }

    public List<Accountmask> getAccountmasks() {
        return this.accountmasks;
    }

    public void setExtendedparameters(List<Extendedparameter> extendedparameters) {
        this.extendedparameters = extendedparameters;
    }

    public List<Extendedparameter> getExtendedparameters() {
        return this.extendedparameters;
    }

    public Integer getCategoryid() {
        return this.categoryid;
    }

    public void setCategoryid(Integer categoryid) {
        this.categoryid = categoryid;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.providerid == null ? 0 : this.providerid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Provider other = (Provider)obj;
        return !(this.providerid == null ? other.providerid != null : !this.providerid.equals(other.providerid));
    }

    public String toString() {
        return "Provider [providerid=" + this.providerid + ", providercode=" + this.providercode + ", terminalid=" + this.terminalid + ", categoryid=" + this.categoryid + ", name=" + this.name + "]";
    }
}

