/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DomainUtils;
import ru.ssa.cashadmin.domain.BaseJavaBean;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.utils.JaxbUtil;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.yuki.action.IModel;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.view.XMLFileDialog;

public class DirectoryImportAction<E>
extends Action
implements IModel,
ActionFactory.IWorkbenchAction {
    public static final String ID = "ru.ssa.artixadmin.action.DirectoryImportAction";
    private static final Logger log = LoggerFactory.getLogger(DirectoryImportAction.class);
    private Object model;
    private Class<E> clazz;
    private static final String TEXT = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430";

    public DirectoryImportAction(Class<E> cl) {
        super(TEXT);
        this.clazz = cl;
        this.setId(ID);
        ArtixAdminImages images = ArtixAdminImages.getDefault();
        this.setImageDescriptor(images.getImageDescriptor("plane/16x16/import"));
        this.setToolTipText(TEXT);
        this.setEnabled(true);
    }

    public void run() {
        String connectionId = ArtixAdminContextHolder.getConnectionId();
        String xmlFileName = new XMLFileDialog(4096).open();
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            DirectoryImportAction directoryImportAction = this;
            directoryImportAction.getClass();
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)directoryImportAction.new DirectoryImportOperation(connectionId, xmlFileName));
        }
        catch (InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430: \"" + xmlFileName + "\"."));
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object getModel() {
        return this.model;
    }

    @Override
    public void setModel(Object model) {
        this.model = model;
    }

    public void dispose() {
    }

    private class DirectoryImportOperation
    implements IRunnableWithProgress {
        private final String connectionId;
        private final String xmlFileName;

        public DirectoryImportOperation(String connectionId, String xmlFileName) {
            this.connectionId = connectionId;
            this.xmlFileName = xmlFileName;
            BeanUtilsBean.getInstance().getConvertUtils().register(false, false, 0);
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                DomainCollections domainCollections;
                ArtixAdminContextHolder.setConnectionId((String)this.connectionId);
                if (this.xmlFileName != null && !(domainCollections = JaxbUtil.INSTANCE.importFromXml(this.xmlFileName)).getDomainCollection().isEmpty()) {
                    List list = domainCollections.getDomainCollection();
                    int size = list.size();
                    log.debug("impot collection size={}", (Object)size);
                    monitor.beginTask(DirectoryImportAction.TEXT, size);
                    int index = 0;
                    for (Object fromXml : list) {
                        Object object = this.convertObject(fromXml);
                        List referencedCollFields = DomainUtils.getAnnotationFieldOneToMany((Class)DirectoryImportAction.this.clazz, (boolean)false);
                        for (String referencedCollField : referencedCollFields) {
                            Object fieldValue = DomainUtils.getFieldValue((String)referencedCollField, (Object)object);
                            if (!(fieldValue instanceof List) || ((List)fieldValue).size() <= 0) continue;
                            Class<?> refClass = ((List)fieldValue).get(0).getClass();
                            ModelActivator.getDefault().getModelProvider().getDirectoryModel(refClass).saveCollection((Collection)fieldValue);
                        }
                        if (ModelActivator.getDefault().getModelProvider().getDirectoryModel(DirectoryImportAction.this.clazz).getById(DomainUtils.getIdValue((Object)object)) != null) {
                            ModelActivator.getDefault().getModelProvider().getDirectoryModel(DirectoryImportAction.this.clazz).update(object);
                        } else {
                            ModelActivator.getDefault().getModelProvider().getDirectoryModel(DirectoryImportAction.this.clazz).save(object);
                        }
                        monitor.setTaskName("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 " + ++index + " \u0438\u0437 " + size + ".");
                        monitor.worked(1);
                        if (monitor.isCanceled()) break;
                    }
                    ModelActivator.getDefault().getModelProvider().getDirectoryModel(DirectoryImportAction.this.clazz).doRefresh();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new InvocationTargetException(e);
            }
            monitor.done();
        }

        private Object convertObject(Object fromXml) throws IllegalAccessException, InvocationTargetException {
            Class base = this.findBase(fromXml.getClass());
            Object current = LibActivator.getDefault().getActualClassResolver().getInstance(base);
            BeanUtils.copyProperties((Object)current, (Object)fromXml);
            return current;
        }

        private Class findBase(Class<? extends Object> clazz) {
            if (Object.class.equals(clazz.getSuperclass()) || BaseJavaBean.class.equals(clazz.getSuperclass())) {
                return clazz;
            }
            return this.findBase(clazz.getSuperclass());
        }
    }
}

