/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;

public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    private static Map<ClassLoader, Map> _registeredFactoryNames = new HashMap<ClassLoader, Map>();
    private static Map<ClassLoader, Map> _factories = new HashMap<ClassLoader, Map>();
    private static final Set<String> VALID_FACTORY_NAMES = new HashSet<String>();
    private static final Map<String, Class> ABSTRACT_FACTORY_CLASSES = new HashMap<String, Class>();

    FactoryFinder() {
    }

    public static Object getFactory(String factoryName) throws FacesException {
        Object factory;
        if (factoryName == null) {
            throw new NullPointerException("factoryName may not be null");
        }
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map factoryClassNames = _registeredFactoryNames.get(classLoader);
        if (factoryClassNames == null) {
            String message = "No Factories configured for this Application. This happens if the faces-initialization does not work at all - make sure that you properly include all configuration settings necessary for a basic faces application and that all the necessary libs are included. Also check the logging output of your web application and your container for any exceptions!\nIf you did that and find nothing, the mistake might be due to the fact that you use some special web-containers which do not support registering context-listeners via TLD files and a context listener is not setup in your web.xml.\nA typical config looks like this;\n<listener>\n  <listener-class>org.apache.myfaces.webapp.StartupServletContextListener</listener-class>\n</listener>\n";
            throw new IllegalStateException(message);
        }
        if (!factoryClassNames.containsKey(factoryName)) {
            throw new IllegalArgumentException("no factory " + factoryName + " configured for this application.");
        }
        HashMap factoryMap = _factories.get(classLoader);
        if (factoryMap == null) {
            factoryMap = new HashMap();
            _factories.put(classLoader, factoryMap);
        }
        if ((factory = factoryMap.get(factoryName)) == null) {
            List classNames = (List)factoryClassNames.get(factoryName);
            factory = FactoryFinder.newFactoryInstance(ABSTRACT_FACTORY_CLASSES.get(factoryName), classNames.iterator(), classLoader);
            factoryMap.put(factoryName, factory);
        }
        return factory;
    }

    private static Object newFactoryInstance(Class interfaceClass, Iterator classNamesIterator, ClassLoader classLoader) {
        try {
            Object current = null;
            while (classNamesIterator.hasNext()) {
                String implClassName = (String)classNamesIterator.next();
                Class<?> implClass = classLoader.loadClass(implClassName);
                if (!interfaceClass.isAssignableFrom(implClass)) {
                    throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
                }
                if (current == null) {
                    current = implClass.newInstance();
                    continue;
                }
                try {
                    Constructor<?> delegationConstructor = implClass.getConstructor(interfaceClass);
                    try {
                        current = delegationConstructor.newInstance(current);
                    }
                    catch (InstantiationException e) {
                        throw new FacesException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new FacesException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new FacesException(e);
                    }
                }
                catch (NoSuchMethodException e) {
                    current = implClass.newInstance();
                }
            }
            return current;
        }
        catch (ClassNotFoundException e) {
            throw new FacesException(e);
        }
        catch (InstantiationException e) {
            throw new FacesException(e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFactory(String factoryName, String implName) {
        FactoryFinder.checkFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map<ClassLoader, Map> map = _registeredFactoryNames;
        synchronized (map) {
            ArrayList<String> classNameList;
            Map factories = _factories.get(classLoader);
            if (factories != null && factories.containsKey(factoryName)) {
                return;
            }
            HashMap<String, ArrayList<String>> factoryClassNames = _registeredFactoryNames.get(classLoader);
            if (factoryClassNames == null) {
                factoryClassNames = new HashMap<String, ArrayList<String>>();
                _registeredFactoryNames.put(classLoader, factoryClassNames);
            }
            if ((classNameList = (ArrayList<String>)factoryClassNames.get(factoryName)) == null) {
                classNameList = new ArrayList<String>();
                factoryClassNames.put(factoryName, classNameList);
            }
            classNameList.add(implName);
        }
    }

    public static void releaseFactories() throws FacesException {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        _factories.remove(classLoader);
    }

    private static void checkFactoryName(String factoryName) {
        if (!VALID_FACTORY_NAMES.contains(factoryName)) {
            throw new IllegalArgumentException("factoryName '" + factoryName + "'");
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                throw new FacesException("web application class loader cannot be identified", null);
            }
            return classLoader;
        }
        catch (Exception e) {
            throw new FacesException("web application class loader cannot be identified", e);
        }
    }

    static {
        VALID_FACTORY_NAMES.add(APPLICATION_FACTORY);
        VALID_FACTORY_NAMES.add(FACES_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(LIFECYCLE_FACTORY);
        VALID_FACTORY_NAMES.add(RENDER_KIT_FACTORY);
        ABSTRACT_FACTORY_CLASSES.put(APPLICATION_FACTORY, ApplicationFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(FACES_CONTEXT_FACTORY, FacesContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(LIFECYCLE_FACTORY, LifecycleFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(RENDER_KIT_FACTORY, RenderKitFactory.class);
    }
}

