/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.preferenceWindow.PWRowGroup;
import org.mihalis.opal.preferenceWindow.PWTab;
import org.mihalis.opal.preferenceWindow.PWTabContainer;
import org.mihalis.opal.preferenceWindow.ValueAndAssociatedWidgets;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class PreferenceWindow {
    private final Map<String, ValueAndAssociatedWidgets> values;
    private final List<PWTab> tabs;
    private final Shell parentShell;
    private boolean returnedValue;
    private Shell shell;
    private static PreferenceWindow instance;
    private PWTabContainer container;
    private int selectedTab;

    private PreferenceWindow(Shell shell, Map<String, Object> map) {
        this.parentShell = shell;
        this.values = new HashMap<String, ValueAndAssociatedWidgets>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.values.put(entry.getKey(), new ValueAndAssociatedWidgets(entry.getValue()));
        }
        this.tabs = new ArrayList<PWTab>();
    }

    public static PreferenceWindow create(Shell shell, Map<String, Object> map) {
        instance = new PreferenceWindow(shell, map);
        return instance;
    }

    public static PreferenceWindow create(Map<String, Object> map) {
        instance = new PreferenceWindow(null, map);
        return instance;
    }

    public static PreferenceWindow getInstance() {
        if (instance == null) {
            throw new NullPointerException("The instance of PreferenceWindow has not yet been created or has been destroyed.");
        }
        return instance;
    }

    public PWTab addTab(Image image, String string) {
        PWTab pWTab = new PWTab(image, string);
        this.tabs.add(pWTab);
        return pWTab;
    }

    public void addWidgetLinkedTo(String string, PWWidget pWWidget) {
        if (!this.values.containsKey(string)) {
            this.values.put(string, new ValueAndAssociatedWidgets(null));
        }
        this.values.get(string).addWidget(pWWidget);
    }

    public void addRowGroupLinkedTo(String string, PWRowGroup pWRowGroup) {
        if (!this.values.containsKey(string)) {
            this.values.put(string, new ValueAndAssociatedWidgets(null));
        }
        this.values.get(string).addRowGroup(pWRowGroup);
    }

    public boolean open() {
        this.shell = this.parentShell == null ? new Shell(1264) : new Shell(PreferenceWindow.instance.parentShell, 1264);
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                instance = null;
            }
        });
        this.buildShell();
        this.openShell();
        return this.returnedValue;
    }

    private void buildShell() {
        this.shell.setText(ResourceManager.getLabel("preferences"));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.shell.setLayout((Layout)gridLayout);
        this.container = new PWTabContainer((Composite)this.shell, 0, this.tabs);
        this.container.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.container.build();
        Label label = new Label((Composite)this.shell, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.buildButtons();
    }

    private void buildButtons() {
        Button button = new Button((Composite)this.shell, 8);
        button.setText(ResourceManager.getLabel("Ok"));
        GridData gridData = new GridData(3, 3, true, false);
        gridData.widthHint = 100;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferenceWindow.this.returnedValue = true;
                PreferenceWindow.this.shell.dispose();
            }
        });
        this.shell.setDefaultButton(button);
        Button button2 = new Button((Composite)this.shell, 8);
        button2.setText(ResourceManager.getLabel("Cancel"));
        GridData gridData2 = new GridData(1, 3, false, false);
        gridData2.widthHint = 100;
        button2.setLayoutData((Object)gridData2);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferenceWindow.this.returnedValue = false;
                PreferenceWindow.this.shell.dispose();
            }
        });
    }

    private void openShell() {
        this.shell.pack();
        this.shell.open();
        SWTGraphicUtil.centerShell(this.shell);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public void fireEnablers() {
        for (String string : this.values.keySet()) {
            this.values.get(string).fireValueChanged();
        }
    }

    public int getSelectedTab() {
        return this.selectedTab;
    }

    public Object getValueFor(String string) {
        if (this.values.containsKey(string)) {
            return this.values.get(string).getValue();
        }
        return null;
    }

    public Map<String, Object> getValues() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this.values.keySet()) {
            hashMap.put(string, this.values.get(string).getValue());
        }
        return hashMap;
    }

    public void setValue(String string, Object object) {
        if (this.values.containsKey(string)) {
            this.values.get(string).setValue(object);
        } else {
            this.values.put(string, new ValueAndAssociatedWidgets(object));
        }
    }

    public void setSelectedTab(int n) {
        this.selectedTab = n;
        if (this.container != null) {
            this.container.redraw();
            this.container.update();
        }
    }
}

