/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanagercore.dao.accounting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import su.artix.accounting.domain.Asset;
import su.artix.accounting.domain.AssetGroup;
import su.artix.accounting.domain.AssetStatus;
import su.artix.accounting.rpc.logic.AbstractAccountingClient;
import su.artix.accounting.rpc.logic.AdminLogicClient;
import su.artix.accounting.rpc.logic.LocationNotFound;
import su.artix.accounting.rpc.logic.LogicClient;
import su.artix.accounting.rpc.logic.thriftapi.AccountingAdminLogicService;
import su.artix.accounting.rpc.logic.thriftapi.AccountingLogicService;
import su.artix.accounting.rpc.logic.thriftapi.AdditionalAssetInfo;
import su.artix.accounting.rpc.logic.thriftapi.AdminResult;
import su.artix.accounting.rpc.logic.thriftapi.Card;
import su.artix.accounting.rpc.logic.thriftapi.CardStatus;
import su.artix.accounting.rpc.logic.thriftapi.Result;
import su.artix.accounting.rpc.logic.thriftapi.SortAssetGroupsByField;
import su.artix.accounting.rpc.logic.thriftapi.Version;
import su.artix.discountmanagercore.converter.AssetConverter;
import su.artix.discountmanagercore.dao.accounting.AccountingDAO;
import su.artix.discountmanagercore.holders.PropertiesHolder;
import su.artix.discountmanagercore.model.accounting.AccountingResult;

public class AccountingDAOThriftImpl
implements AccountingDAO {
    private static final int LAST_BUILD_OF_OLD_STATUS = 160;
    private static final Logger log = LoggerFactory.getLogger(AccountingDAOThriftImpl.class);
    private AdminLogicClient adminLogicClient = new AdminLogicClient();
    private LogicClient logicClient = new LogicClient();
    private String terminalId;
    @Autowired
    private AssetConverter assetConverter;
    private Boolean modernStatusOfCard;

    private void prepareConnection() {
        this.adminLogicClient.setLocations(Arrays.asList(PropertiesHolder.INSTANCE.getAccountingProperty("logic.server.admin.location")));
        this.logicClient.setLocations(Arrays.asList(PropertiesHolder.INSTANCE.getAccountingProperty("logic.server.base.location")));
        this.terminalId = PropertiesHolder.INSTANCE.getAccountingProperty("terminal.id");
    }

    @Override
    public List<Asset> getAssets(final String cardNumber) throws LocationNotFound {
        log.trace("cardNumber={}", (Object)cardNumber);
        this.prepareConnection();
        Object res = this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

            public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                ArrayList<Asset> assets = new ArrayList<Asset>();
                List inner = client.getAssetList(AccountingDAOThriftImpl.this.terminalId, cardNumber, false);
                for (su.artix.accounting.rpc.logic.thriftapi.Asset tAsset : inner) {
                    Asset asset = AccountingDAOThriftImpl.this.assetConverter.convert(tAsset);
                    assets.add(asset);
                }
                return assets;
            }
        });
        return (List)res;
    }

    @Override
    public AccountingResult cancel(final String sessionId, final AssetStatus currentStatus, final String source, final String reason) throws LocationNotFound {
        log.trace("sessionId={}", (Object)sessionId);
        this.prepareConnection();
        AccountingResult res = (AccountingResult)this.logicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingLogicService.Client>(){

            public Object doIt(AccountingLogicService.Client client) throws TException {
                Result tResult = client.cancel(AccountingDAOThriftImpl.this.terminalId, sessionId, currentStatus.getValue(), AccountingDAOThriftImpl.this.getAdditionalAssetInfo(source, reason));
                return AccountingDAOThriftImpl.this.copyBaseResult(tResult);
            }
        });
        log.trace("result={}", (Object)res);
        return res;
    }

    @Override
    public AccountingResult add(String sessionId, String cardNumber, long amount, String source, String reason) throws LocationNotFound {
        return this.add(sessionId, cardNumber, amount, source, reason, null);
    }

    @Override
    public AccountingResult add(final String sessionId, final String cardNumber, final long amount, final String source, final String reason, final AssetGroup assetGroup) throws LocationNotFound {
        log.trace("sessionId={} cardNumber={} amount={} assetGroup={}", new Object[]{sessionId, cardNumber, amount, assetGroup});
        this.prepareConnection();
        AccountingResult res = (AccountingResult)this.logicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingLogicService.Client>(){

            public Object doIt(AccountingLogicService.Client client) throws TException {
                su.artix.accounting.rpc.logic.thriftapi.AssetGroup assetGroupInner = null;
                if (assetGroup != null) {
                    assetGroupInner = AccountingDAOThriftImpl.this.assetConverter.convert(assetGroup);
                }
                Result tResult = client.add(AccountingDAOThriftImpl.this.terminalId, sessionId, cardNumber, amount, AccountingDAOThriftImpl.this.getAdditionalAssetInfo(source, reason), assetGroupInner);
                return AccountingDAOThriftImpl.this.copyBaseResult(tResult);
            }
        });
        log.trace("result={}", (Object)res);
        return res;
    }

    @Override
    public AccountingResult sub(String sessionId, String cardNumber, long amount, String source, String reason) throws LocationNotFound {
        return this.sub(sessionId, cardNumber, amount, source, reason, null);
    }

    @Override
    public AccountingResult sub(final String sessionId, final String cardNumber, final long amount, final String source, final String reason, final AssetGroup assetGroup) throws LocationNotFound {
        log.trace("sessionId={} cardNumber={} amount={} assetGroup={}", new Object[]{sessionId, cardNumber, amount, assetGroup});
        this.prepareConnection();
        AccountingResult res = (AccountingResult)this.logicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingLogicService.Client>(){

            public Object doIt(AccountingLogicService.Client client) throws TException {
                su.artix.accounting.rpc.logic.thriftapi.AssetGroup assetGroupInner = null;
                if (assetGroup != null) {
                    assetGroupInner = AccountingDAOThriftImpl.this.assetConverter.convert(assetGroup);
                }
                Result tResult = client.sub(AccountingDAOThriftImpl.this.terminalId, sessionId, cardNumber, amount, AccountingDAOThriftImpl.this.getAdditionalAssetInfo(source, reason), assetGroupInner);
                return AccountingDAOThriftImpl.this.copyBaseResult(tResult);
            }
        });
        log.trace("result={}", (Object)res);
        return res;
    }

    @Override
    public AccountingResult createCard(final String cardNumber) throws LocationNotFound {
        log.trace("cardNumber={}", (Object)cardNumber);
        this.prepareConnection();
        AccountingResult res = (AccountingResult)this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

            public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                Card card = new Card();
                card.setCardNumber(cardNumber);
                AdminResult tResult = client.createCard(AccountingDAOThriftImpl.this.terminalId, card);
                return AccountingDAOThriftImpl.this.copyBaseResult(tResult);
            }
        });
        log.trace("result={}", (Object)res);
        return res;
    }

    @Override
    public AccountingResult cardExists(final String cardNumber) throws LocationNotFound {
        log.trace("cardNumber={}", (Object)cardNumber);
        this.prepareConnection();
        AccountingResult res = (AccountingResult)this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

            public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                Card card = new Card();
                card.setCardNumber(cardNumber);
                AdminResult tResult = client.cardExists(AccountingDAOThriftImpl.this.terminalId, card);
                return AccountingDAOThriftImpl.this.copyBaseResult(tResult);
            }
        });
        log.trace("result={}", (Object)res);
        return res;
    }

    @Override
    public AccountingResult balance(final String cardNumber) throws LocationNotFound {
        log.trace("cardNumber={}", (Object)cardNumber);
        this.prepareConnection();
        AccountingResult res = (AccountingResult)this.logicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingLogicService.Client>(){

            public Object doIt(AccountingLogicService.Client client) throws TException {
                Result tResult = client.balance(AccountingDAOThriftImpl.this.terminalId, cardNumber, false);
                return AccountingDAOThriftImpl.this.copyBaseResult(tResult);
            }
        });
        log.trace("result={}", (Object)res);
        return res;
    }

    protected Object copyBaseResult(Object tResult) {
        AccountingResult result = new AccountingResult();
        try {
            BeanUtils.copyProperties((Object)result, (Object)tResult);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isDisposedConnect() {
        return this.logicClient.findLocation();
    }

    @Override
    public su.artix.accounting.domain.CardStatus getCardStatus(final String cardNumber) throws LocationNotFound {
        log.trace("cardNumber={}", (Object)cardNumber);
        this.prepareConnection();
        su.artix.accounting.domain.CardStatus cardStatus = (su.artix.accounting.domain.CardStatus)this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

            public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                Card card = client.getCard(AccountingDAOThriftImpl.this.terminalId, cardNumber);
                if (card.getCardNumber() != null) {
                    return su.artix.accounting.domain.CardStatus.findByValue((int)card.getStatus().getValue());
                }
                return null;
            }
        });
        if (cardStatus == null) {
            log.warn("Accounting server didn't find card with cardNumber={}", (Object)cardNumber);
            throw new IllegalStateException("Card not found on accounting server!");
        }
        log.trace("cardStatus for card:{} = {}", (Object)cardNumber, (Object)cardStatus);
        return cardStatus;
    }

    @Override
    public AccountingResult setCardStatus(final String cardNumber, final su.artix.accounting.domain.CardStatus cardStatus) throws LocationNotFound {
        log.trace("set status {} for cardNumber={}", (Object)cardStatus, (Object)cardNumber);
        this.prepareConnection();
        AccountingResult res = (AccountingResult)this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

            public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                Card card = new Card();
                card.setCardNumber(cardNumber);
                AdminResult tResult = client.setCardStatus(AccountingDAOThriftImpl.this.terminalId, card, CardStatus.findByValue((int)cardStatus.getValue()), null);
                return AccountingDAOThriftImpl.this.copyBaseResult(tResult);
            }
        });
        log.trace("result={}", (Object)res);
        return res;
    }

    @Override
    public AccountingResult setTransactionReason(final String sessionId, final int transactionItem, final String reason) throws LocationNotFound {
        log.trace("set reason {} for sessionId={}", (Object)reason, (Object)sessionId);
        this.prepareConnection();
        AccountingResult res = (AccountingResult)this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

            public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                AdminResult tResult = client.setTransactionReason(AccountingDAOThriftImpl.this.terminalId, sessionId, transactionItem, reason);
                return AccountingDAOThriftImpl.this.copyBaseResult(tResult);
            }
        });
        log.trace("result={}", (Object)res);
        return res;
    }

    private AdditionalAssetInfo getAdditionalAssetInfo(String source, String reason) {
        AdditionalAssetInfo additionalAssetInfo = new AdditionalAssetInfo();
        additionalAssetInfo.setDateFromCash(new Date().getTime());
        additionalAssetInfo.setSource(source);
        additionalAssetInfo.setReason(reason);
        return additionalAssetInfo;
    }

    private SortAssetGroupsByField getAssetGroupSort(Object sourceFieldValue) {
        SortAssetGroupsByField result = null;
        if (sourceFieldValue != null) {
            if ("groupId".equals(sourceFieldValue)) {
                result = SortAssetGroupsByField.GROUPID;
            } else if ("begin".equals(sourceFieldValue)) {
                result = SortAssetGroupsByField.BEGINDATE;
            } else if ("end".equals(sourceFieldValue)) {
                result = SortAssetGroupsByField.ENDDATE;
            } else if ("weight".equals(sourceFieldValue)) {
                result = SortAssetGroupsByField.WEIGHT;
            }
        }
        return result;
    }

    @Override
    public List<AssetGroup> getAssetGroups(final Date dateBiggerThan, final Date dateLessThan, final int pageNumber, final int pageSize, String sortedByField, final boolean ascending) throws LocationNotFound {
        final SortAssetGroupsByField sortedField = this.getAssetGroupSort(sortedByField);
        this.prepareConnection();
        Object res = this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

            public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                ArrayList<AssetGroup> assetsGroups = new ArrayList<AssetGroup>();
                List inner = client.getAssetGroups(AccountingDAOThriftImpl.this.terminalId, dateBiggerThan == null ? 0L : dateBiggerThan.getTime(), dateLessThan == null ? 0L : dateLessThan.getTime(), pageNumber, pageSize, sortedField, ascending);
                for (su.artix.accounting.rpc.logic.thriftapi.AssetGroup tAssetGroup : inner) {
                    AssetGroup assetGroup = AccountingDAOThriftImpl.this.assetConverter.convert(tAssetGroup);
                    assetsGroups.add(assetGroup);
                }
                return assetsGroups;
            }
        });
        return (List)res;
    }

    @Override
    public long getAssetGroupsCount(final Date dateBiggerThan, final Date dateLessThan) throws LocationNotFound {
        long count = 0L;
        this.prepareConnection();
        count = (Long)this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

            public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                long innerCount = client.getAssetGroupsCount(AccountingDAOThriftImpl.this.terminalId, dateBiggerThan == null ? 0L : dateBiggerThan.getTime(), dateLessThan == null ? 0L : dateLessThan.getTime());
                return innerCount;
            }
        });
        return count;
    }

    @Override
    public AccountingResult changeAssetGroup(final String groupId, final long beginShift, final long endShift, final int newWeight) throws LocationNotFound {
        this.prepareConnection();
        AccountingResult result = (AccountingResult)this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

            public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                return AccountingDAOThriftImpl.this.copyBaseResult(client.changeAssetGroupParams(AccountingDAOThriftImpl.this.terminalId, groupId, beginShift, endShift, newWeight));
            }
        });
        return result;
    }

    @Override
    public List<String> getConnectParameters() {
        ArrayList<String> parametersList = new ArrayList<String>();
        parametersList.addAll(this.logicClient.getLocations());
        parametersList.addAll(this.adminLogicClient.getLocations());
        parametersList.add(this.terminalId);
        return parametersList;
    }

    @Override
    public boolean isBonusServerSpecified() {
        return PropertiesHolder.INSTANCE.getAccountingProperty("terminal.id") != null;
    }

    @Override
    public boolean isModernStatusOfCard() {
        Boolean result = false;
        if (this.modernStatusOfCard == null) {
            this.prepareConnection();
            Version ver = null;
            try {
                ver = (Version)this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

                    public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                        return client.version();
                    }
                });
            }
            catch (LocationNotFound e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
            if (ver == null) {
                result = false;
            } else {
                try {
                    result = Integer.valueOf(StringUtils.split((String)ver.getVersion(), (String)"-")[0]) > 160;
                }
                catch (RuntimeException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    result = false;
                }
            }
            this.modernStatusOfCard = result;
        }
        return this.modernStatusOfCard;
    }

    @Override
    public long getVersion() {
        Long result = 0L;
        try {
            result = (Long)this.adminLogicClient.doWork((AbstractAccountingClient.Work)new AbstractAccountingClient.Work<AccountingAdminLogicService.Client>(){

                public Object doIt(AccountingAdminLogicService.Client client) throws TException {
                    return Long.valueOf(client.version().getVersion().split("-")[0]);
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

