/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view;

import java.util.HashSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.security.GuiElementController;
import su.artix.discountmanager.views.PeriodicImpactsBonusSystemView;
import su.artix.yuki.directory.GuiActivator;

public enum ViewActivity {
    INSTANCE;

    private static final Logger log;
    private static final String activitySuffix = ".activityView";

    static {
        log = LoggerFactory.getLogger(ViewActivity.class);
    }

    public void activate(boolean isCS) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = activitySupport.getActivityManager();
        HashSet<String> enabledActivities = new HashSet<String>();
        for (Object oldId : activityManager.getEnabledActivityIds()) {
            if (((String)oldId).endsWith(activitySuffix)) continue;
            enabledActivities.add((String)oldId);
        }
        for (Object activityId : activityManager.getDefinedActivityIds()) {
            String id;
            if (!((String)activityId).endsWith(activitySuffix) || !this.isActivate(id = ((String)activityId).replaceAll(activitySuffix, ""), isCS)) continue;
            enabledActivities.add((String)activityId);
        }
        activitySupport.setEnabledActivityIds(enabledActivities);
    }

    private boolean isActivate(String securityObjectId, boolean isCS) {
        if (!isCS && PeriodicImpactsBonusSystemView.class.getCanonicalName().equals(securityObjectId)) {
            return false;
        }
        boolean result = ((GuiElementController)GuiActivator.getDefault().getBeanByClass(GuiElementController.class)).hasRightsPerspective(securityObjectId);
        log.trace("check activiti for view:{} result={}", (Object)securityObjectId, (Object)result);
        return result;
    }
}

