/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestOperations;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.rest.client.RestConnectionHolder;
import su.artix.cashserver.rest.client.RestInvoker;

public class RestConnectionHolderImpl
implements RestConnectionHolder {
    private static final int TIME_TO_LIVE_IN_SEC = 60;
    private final Cache<String, RestInvoker> cache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    private static final ThreadLocal<String> CONNECTION_IDS = new ThreadLocal();
    private static final ThreadLocal<WebUser> AUTH_INFO = new ThreadLocal();
    private WebUser authGlobal;
    private boolean useGlobalAuth;
    private String defaultHost = "localhost";
    private String defaultURLPrefix = "/CSrest/rest/";
    private String defaultPort = "8080";
    @Autowired
    private RestOperations restTemplate;

    @Override
    public boolean resetUserInfo() {
        this.cache.invalidateAll();
        AUTH_INFO.remove();
        this.authGlobal = null;
        return true;
    }

    @Override
    public boolean setUserInfo(String login, String password) {
        WebUser webUser = new WebUser();
        webUser.setName(login);
        webUser.setPassword(password);
        AUTH_INFO.set(webUser);
        this.authGlobal = webUser;
        return true;
    }

    public RestInvoker getRestInvoker() {
        RestInvoker invoker;
        String connectionId = this.getConnectionId();
        if (StringUtils.isEmpty((String)connectionId)) {
            connectionId = this.defaultHost;
        }
        StringBuilder cacheKey = new StringBuilder(connectionId);
        WebUser webUser = this.getAuth();
        if (webUser != null) {
            cacheKey.append(webUser.getName()).append(webUser.getPassword());
        }
        if ((invoker = (RestInvoker)this.cache.getIfPresent((Object)cacheKey.toString())) == null) {
            invoker = new RestInvoker();
            invoker.setRestTemplate(this.restTemplate);
            invoker.setHost(connectionId);
            invoker.setPort(this.defaultPort);
            invoker.setRestURL(this.defaultURLPrefix);
            invoker.setAuthInfo(webUser);
            invoker.init();
            this.cache.put((Object)cacheKey.toString(), (Object)invoker);
        }
        return invoker;
    }

    private WebUser getAuth() {
        if (this.useGlobalAuth) {
            return this.authGlobal;
        }
        return AUTH_INFO.get();
    }

    public String getConnectionId() {
        return CONNECTION_IDS.get();
    }

    public WebUser getUserInfo() {
        return this.getAuth();
    }

    public void setDefault(String host, String port) {
        this.defaultHost = host;
        this.defaultPort = port;
    }

    public void setUseGlobalAuth(boolean useGlobalAuth) {
        this.useGlobalAuth = useGlobalAuth;
    }

    public String getDefaultURLPrefix() {
        return this.defaultURLPrefix;
    }

    public void setDefaultURLPrefix(String defaultURLPrefix) {
        this.defaultURLPrefix = defaultURLPrefix;
    }
}

