/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.progressIndicator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ImageSequencer
extends Canvas {
    private final List<Image> imageSequence = new ArrayList<Image>();
    private final Timer timer = new Timer();
    private TimerTask imageSequenceTask;
    private int imgIndex = 0;
    private int period;
    private boolean wrap;
    private boolean forward = true;
    private boolean disposed = false;
    private boolean pulse = false;

    public ImageSequencer(Composite parent, int style, Image[] imageSequence, int periodMS, boolean wrap) {
        super(parent, style | 0x20000000);
        if (imageSequence == null || imageSequence.length < 2) {
            throw new IllegalArgumentException("A valid image sequence of atleast 2 images has to be specified");
        }
        if (periodMS <= 0) {
            throw new IllegalArgumentException("A valid positive period in milliseconds must be specified.");
        }
        this.imageSequence.addAll(Arrays.asList(imageSequence));
        this.period = periodMS;
        this.wrap = wrap;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ImageSequencer.this.imageSequence.get(ImageSequencer.this.imgIndex) != null) {
                    e.gc.drawImage((Image)ImageSequencer.this.imageSequence.get(ImageSequencer.this.imgIndex), 0, 0);
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ImageSequencer.this.stopSequence();
                ImageSequencer.this.disposed = true;
            }
        });
        this.startSequence();
    }

    public void setPeriod(int milliseconds) {
        this.checkWidget();
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("A valid positive period in milliseconds must be specified.");
        }
        this.period = milliseconds;
    }

    public void setWrap(boolean wrap) {
        this.checkWidget();
        this.wrap = wrap;
    }

    public void pulseSequence() {
        this.checkWidget();
        this.resetSequence();
        this.pulse = true;
        this.imageSequenceTask = new ImageSequenceTask();
        this.timer.schedule(this.imageSequenceTask, 0L, (long)this.period);
    }

    public void startSequence() {
        this.checkWidget();
        this.stopTask();
        this.imageSequenceTask = new ImageSequenceTask();
        this.timer.schedule(this.imageSequenceTask, 0L, (long)this.period);
    }

    public void stopSequence() {
        this.checkWidget();
        this.stopTask();
    }

    private void stopTask() {
        if (this.imageSequenceTask != null) {
            this.imageSequenceTask.cancel();
            this.timer.purge();
        }
    }

    public void resetSequence() {
        this.checkWidget();
        this.stopTask();
        this.imgIndex = 0;
        this.forward = true;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.imageSequence.get(0) != null && !this.imageSequence.get(0).isDisposed()) {
            Rectangle bounds = this.imageSequence.get(0).getBounds();
            width = bounds.width;
            height = bounds.height;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    private class ImageSequenceTask
    extends TimerTask {
        private ImageSequenceTask() {
        }

        @Override
        public void run() {
            int len = ImageSequencer.this.imageSequence.size();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ImageSequencer.this.disposed) {
                        return;
                    }
                    ImageSequencer.this.redraw();
                    ImageSequencer.this.update();
                }
            });
            if (ImageSequencer.this.wrap) {
                ImageSequencer imageSequencer = ImageSequencer.this;
                imageSequencer.imgIndex = imageSequencer.imgIndex + 1;
                if (ImageSequencer.this.imgIndex >= len) {
                    ImageSequencer.this.imgIndex = 0;
                    if (ImageSequencer.this.pulse) {
                        this.cancel();
                    }
                }
            } else if (ImageSequencer.this.forward) {
                ImageSequencer imageSequencer = ImageSequencer.this;
                imageSequencer.imgIndex = imageSequencer.imgIndex + 1;
                if (ImageSequencer.this.imgIndex > len - 1) {
                    ImageSequencer.this.imgIndex = len - 2;
                    ImageSequencer.this.forward = false;
                    if (ImageSequencer.this.pulse) {
                        this.cancel();
                    }
                }
            } else {
                ImageSequencer imageSequencer = ImageSequencer.this;
                imageSequencer.imgIndex = imageSequencer.imgIndex - 1;
                if (ImageSequencer.this.imgIndex < 0) {
                    ImageSequencer.this.imgIndex = 1;
                    ImageSequencer.this.forward = true;
                    if (ImageSequencer.this.pulse) {
                        this.cancel();
                    }
                }
            }
        }
    }
}

