/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.io.Serializable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageRequest
implements Pageable,
Serializable {
    private static final long serialVersionUID = 8280485938848398236L;
    private final int page;
    private final int size;
    private final Sort sort;

    public PageRequest(int page, int size) {
        this(page, size, null);
    }

    public PageRequest(int page, int size, Sort.Direction direction, String ... properties) {
        this(page, size, new Sort(direction, properties));
    }

    public PageRequest(int page, int size, Sort sort) {
        if (0 > page) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        if (0 >= size) {
            throw new IllegalArgumentException("Page size must not be less than or equal to zero!");
        }
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public int getPageSize() {
        return this.size;
    }

    public int getPageNumber() {
        return this.page;
    }

    public int getOffset() {
        return this.page * this.size;
    }

    public Sort getSort() {
        return this.sort;
    }

    public boolean equals(Object obj) {
        boolean sizeEqual;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageRequest)) {
            return false;
        }
        PageRequest that = (PageRequest)obj;
        boolean pageEqual = this.page == that.page;
        boolean bl = sizeEqual = this.size == that.size;
        boolean sortEqual = this.sort == null ? that.sort == null : this.sort.equals(that.sort);
        return pageEqual && sizeEqual && sortEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.page;
        result = 31 * result + this.size;
        result = 31 * result + (null == this.sort ? 0 : this.sort.hashCode());
        return result;
    }
}

