/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.RepositoryDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CdiRepositoryExtensionSupport
implements Extension {
    private static final Log LOGGER = LogFactory.getLog(CdiRepositoryExtensionSupport.class);
    private final Map<Class<?>, Set<Annotation>> repositoryTypes = new HashMap();

    protected <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Class repositoryType = annotatedType.getJavaClass();
        if (this.isRepository(repositoryType)) {
            Set<Annotation> qualifiers = this.getQualifiers(repositoryType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Discovered repository type '%s' with qualifiers %s.", repositoryType.getName(), qualifiers));
            }
            this.repositoryTypes.put(repositoryType, qualifiers);
        }
    }

    private boolean isRepository(Class<?> type) {
        boolean isInterface = type.isInterface();
        boolean extendsRepository = Repository.class.isAssignableFrom(type);
        boolean isAnnotated = type.isAnnotationPresent(RepositoryDefinition.class);
        boolean excludedByAnnotation = type.isAnnotationPresent(NoRepositoryBean.class);
        return isInterface && (extendsRepository || isAnnotated) && !excludedByAnnotation;
    }

    private Set<Annotation> getQualifiers(Class<?> type) {
        Annotation[] annotations;
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : annotations = type.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(Qualifier.class)) continue;
            qualifiers.add(annotation);
        }
        if (qualifiers.isEmpty()) {
            qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
        }
        qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        return qualifiers;
    }

    protected Iterable<Map.Entry<Class<?>, Set<Annotation>>> getRepositoryTypes() {
        return this.repositoryTypes.entrySet();
    }
}

