/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryFactoryBeanSupport<T extends Repository<S, ID>, S, ID extends Serializable>
implements InitializingBean,
RepositoryFactoryInformation<S, ID>,
FactoryBean<T> {
    private RepositoryFactorySupport factory;
    private QueryLookupStrategy.Key queryLookupStrategyKey;
    private Class<? extends T> repositoryInterface;
    private Object customImplementation;
    private NamedQueries namedQueries;

    @Required
    public void setRepositoryInterface(Class<? extends T> repositoryInterface) {
        Assert.notNull(repositoryInterface);
        this.repositoryInterface = repositoryInterface;
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key queryLookupStrategyKey) {
        this.queryLookupStrategyKey = queryLookupStrategyKey;
    }

    public void setCustomImplementation(Object customImplementation) {
        this.customImplementation = customImplementation;
    }

    public void setNamedQueries(NamedQueries namedQueries) {
        this.namedQueries = namedQueries;
    }

    @Override
    public EntityInformation<S, ID> getEntityInformation() {
        RepositoryMetadata repositoryMetadata = this.factory.getRepositoryMetadata(this.repositoryInterface);
        return this.factory.getEntityInformation(repositoryMetadata.getDomainType());
    }

    @Override
    public RepositoryInformation getRepositoryInformation() {
        RepositoryMetadata metadata = this.factory.getRepositoryMetadata(this.repositoryInterface);
        return this.factory.getRepositoryInformation(metadata, this.customImplementation == null ? null : this.customImplementation.getClass());
    }

    @Override
    public List<QueryMethod> getQueryMethods() {
        return this.factory.getQueryMethods();
    }

    public T getObject() {
        return (T)((Repository)this.factory.getRepository(this.repositoryInterface, this.customImplementation));
    }

    public Class<? extends T> getObjectType() {
        return null == this.repositoryInterface ? Repository.class : this.repositoryInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        this.factory = this.createRepositoryFactory();
        this.factory.setQueryLookupStrategyKey(this.queryLookupStrategyKey);
        this.factory.setNamedQueries(this.namedQueries);
    }

    protected abstract RepositoryFactorySupport createRepositoryFactory();
}

