/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import ru.ssa.cashadmin.domain.Catalog;
import ru.ssa.cashadmin.domain.Dept;
import ru.ssa.cashadmin.domain.Timerestrict;

@Entity
@Table(name="catalogrestrict")
@MappedSuperclass
public class Catalogrestrict
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @NotNull
    @GeneratedValue
    private Integer id;
    private Integer restrictid;
    private Integer catalogid;
    private Integer deptcode;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="catalogid", referencedColumnName="catalogid", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Catalog.class)
    private Catalog catalog;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="deptcode", referencedColumnName="code", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Dept.class)
    private Dept dept;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="restrictid", referencedColumnName="timerestrictid", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    private Timerestrict timerestrict;

    protected Catalogrestrict() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getRestrictid() {
        return this.restrictid;
    }

    public void setRestrictid(Integer restrictid) {
        this.restrictid = restrictid;
    }

    public Integer getCatalogid() {
        return this.catalogid;
    }

    public void setCatalogid(Integer catalogid) {
        this.catalogid = catalogid;
    }

    public Integer getDeptcode() {
        return this.deptcode;
    }

    public void setDeptcode(Integer deptcode) {
        this.deptcode = deptcode;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
        this.catalogid = catalog != null ? (catalog.getCatalogid() == null ? null : Integer.valueOf(catalog.getCatalogid())) : null;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setDept(Dept dept) {
        this.dept = dept;
        this.deptcode = dept != null ? dept.getCode() : null;
    }

    public Dept getDept() {
        return this.dept;
    }

    public void setTimerestrict(Timerestrict timerestrict) {
        this.timerestrict = timerestrict;
        this.restrictid = timerestrict != null ? timerestrict.getTimerestrictid() : null;
    }

    public Timerestrict getTimerestrict() {
        return this.timerestrict;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.catalogid == null ? 0 : this.catalogid.hashCode());
        result = 31 * result + (this.deptcode == null ? 0 : this.deptcode.hashCode());
        result = 31 * result + (this.restrictid == null ? 0 : this.restrictid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Catalogrestrict other = (Catalogrestrict)obj;
        if (this.catalogid == null ? other.catalogid != null : !this.catalogid.equals(other.catalogid)) {
            return false;
        }
        if (this.deptcode == null ? other.deptcode != null : !this.deptcode.equals(other.deptcode)) {
            return false;
        }
        return !(this.restrictid == null ? other.restrictid != null : !this.restrictid.equals(other.restrictid));
    }

    public String toString() {
        return "Catalogrestrict [id=" + this.id + ", restrictid=" + this.restrictid + ", catalogid=" + this.catalogid + ", deptcode=" + this.deptcode + "]";
    }
}

