/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.advanced;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.domain.Actionparameter;
import ru.ssa.cashadmin.domain.Cmaction;
import ru.ssa.cashadmin.domain.Command;
import ru.ssa.cashadmin.domain.Menu;
import ru.ssa.cashadmin.domain.Menuitem;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import ru.ssa.cashadmin.excep.MenuNotFoundException;
import ru.ssa.cashadmin.excep.SubMenuNotFoundException;

public class HierarchicalMenu
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalMenu.class);
    private static final long serialVersionUID = 1L;
    private List<HierarchicalMenuItem> roots = new ArrayList<HierarchicalMenuItem>();
    public static final String COMMAND_MENU = "COMMAND_MENU";
    private List<Cmaction> cmactionsList;
    private List<Menuitem> menuitemList;
    private List<Actionparameter> actionparameterList;
    private List<Menu> menuList;

    private void sort(List<HierarchicalMenuItem> list) {
        Collections.sort(list, new Comparator<HierarchicalMenuItem>(){

            @Override
            public int compare(HierarchicalMenuItem o1, HierarchicalMenuItem o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    private void prep() throws ExecuteQueryException {
        this.cmactionsList = DaoFactory.getDAO(this.getActual(Cmaction.class)).getList();
        this.menuitemList = DaoFactory.getDAO(this.getActual(Menuitem.class)).getList();
        this.actionparameterList = DaoFactory.getDAO(this.getActual(Actionparameter.class)).getList();
        this.menuList = DaoFactory.getDAO(this.getActual(Menu.class)).getList();
    }

    private void initRoots() throws ExecuteQueryException, MenuNotFoundException {
        for (Cmaction cm : this.getListCmactionByCommandcode(3)) {
            List<Menuitem> menuitems = this.getListMenuitemByCmactioncode(cm.getCmactioncode());
            log.debug("work with cm={} menuitems={}", (Object)cm, (Object)menuitems.size());
            if (!menuitems.isEmpty()) continue;
            log.trace("Getted root menu from 'Cmaction':{}", (Object)cm);
            List<Actionparameter> parameters = this.getListActionparameter(cm.getCmactioncode());
            if (parameters.isEmpty()) continue;
            log.trace("Getted root actionparameter from 'Actionparameter' [" + parameters.get(0).getCmactioncode() + ", " + parameters.get(0).getParametervalue() + "]");
            try {
                List<Menu> menues = this.getListMenu(Integer.valueOf(parameters.get(0).getParametervalue()));
                if (!menues.isEmpty()) {
                    log.trace("Getted root menu from 'Menu' [" + menues.get(0).getMenuname() + "]");
                    HierarchicalMenuItem rootItem = new HierarchicalMenuItem(menues.get(0).getMenuname(), 0);
                    rootItem.setCmaction(cm);
                    rootItem.setMenu(menues.get(0));
                    this.roots.add(rootItem);
                    log.trace("Added root menu [" + cm.toString() + "]");
                    continue;
                }
                throw new MenuNotFoundException(parameters.get(0).getParametervalue(), "Not found menu with code: \"" + parameters.get(0).getParametervalue() + "\"");
            }
            catch (NumberFormatException e) {
                log.error("Error convert string value: \"" + parameters.get(0).getParametervalue() + "\" to integer value");
                throw new MenuNotFoundException(parameters.get(0).getParametervalue(), "Not found menu with code: \"" + parameters.get(0).getParametervalue() + "\"", e);
            }
        }
    }

    private List<Menu> getListMenu(final Integer menucod) {
        Predicate<Menu> predicate = new Predicate<Menu>(){

            public boolean apply(Menu arg0) {
                return ObjectUtils.equals((Object)arg0.getMenucode(), (Object)menucod);
            }
        };
        return FluentIterable.from(this.menuList).filter((Predicate)predicate).toList();
    }

    private List<Actionparameter> getListActionparameter(final Integer code) {
        Predicate<Actionparameter> predicate = new Predicate<Actionparameter>(){

            public boolean apply(Actionparameter arg0) {
                return ObjectUtils.equals((Object)arg0.getCmactioncode(), (Object)code);
            }
        };
        return FluentIterable.from(this.actionparameterList).filter((Predicate)predicate).toList();
    }

    private List<Menuitem> getListMenuitemByCmactioncode(final Integer cmactioCode) {
        Predicate<Menuitem> predicate = new Predicate<Menuitem>(){

            public boolean apply(Menuitem arg0) {
                return ObjectUtils.equals((Object)arg0.getCmactioncodeInt(), (Object)cmactioCode);
            }
        };
        return FluentIterable.from(this.menuitemList).filter((Predicate)predicate).toList();
    }

    private List<Menuitem> getListMenuitemByMenucode(final Integer code) {
        Predicate<Menuitem> predicate = new Predicate<Menuitem>(){

            public boolean apply(Menuitem arg0) {
                return ObjectUtils.equals((Object)arg0.getMenucodeInt(), (Object)code);
            }
        };
        return FluentIterable.from(this.menuitemList).filter((Predicate)predicate).toList();
    }

    private List<Cmaction> getListCmaction(final Integer code) {
        Predicate<Cmaction> predicate = new Predicate<Cmaction>(){

            public boolean apply(Cmaction arg0) {
                return ObjectUtils.equals((Object)arg0.getCmactioncode(), (Object)code) && ObjectUtils.equals((Object)arg0.getCommandcode(), (Object)3);
            }
        };
        return FluentIterable.from(this.cmactionsList).filter((Predicate)predicate).toList();
    }

    private List<Cmaction> getListCmactionByCommandcode(final Integer code) {
        Predicate<Cmaction> predicate = new Predicate<Cmaction>(){

            public boolean apply(Cmaction arg0) {
                return ObjectUtils.equals((Object)arg0.getCommandcode(), (Object)code);
            }
        };
        return FluentIterable.from(this.cmactionsList).filter((Predicate)predicate).toList();
    }

    private <E> Class<E> getActual(Class<E> base) {
        return LibActivator.getDefault().getActualClassResolver().getActual(base);
    }

    public Command getCommandMenu() {
        try {
            Command state = LibActivator.getDefault().getActualClassResolver().getInstance(Command.class);
            state.setCommandname(COMMAND_MENU);
            List<Command> commands = DaoFactory.getDAO(this.getActual(Command.class)).getList(state);
            try {
                return commands.get(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                log.error("COMMAND_MENU not found");
                return null;
            }
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void initChilds(HierarchicalMenuItem root) throws ExecuteQueryException, SubMenuNotFoundException {
        List<Menuitem> menuitems = this.getListMenuitemByMenucode(root.getMenu().getMenucode());
        if (!menuitems.isEmpty()) {
            for (Menuitem item : menuitems) {
                Command command = LibActivator.getDefault().getActualClassResolver().getInstance(Command.class);
                command.setCommandname(COMMAND_MENU);
                Cmaction menuitemAction = item.getCmactioncode();
                if (menuitemAction == null) continue;
                log.trace("Getted child menu from 'Cmaction' [" + root.getName() + " " + item.toString() + "]");
                List<Cmaction> cmactions = this.getListCmaction(menuitemAction.getCmactioncode());
                if (cmactions.size() == 1) {
                    List<Actionparameter> parameters = this.getListActionparameter(cmactions.get(0).getCmactioncode());
                    if (parameters.isEmpty()) continue;
                    log.trace("Getted menu actionparameter from 'Actionparameter' [" + parameters.get(0).getCmactioncode() + ", " + parameters.get(0).getParametervalue() + "]");
                    try {
                        List<Menu> menues = this.getListMenu(Integer.valueOf(parameters.get(0).getParametervalue()));
                        if (menues.size() == 1) {
                            HierarchicalMenuItem child = new HierarchicalMenuItem(menues.get(0).getMenuname(), item.getMenuitemorder());
                            child.setCmaction(cmactions.get(0));
                            child.setMenu(menues.get(0));
                            child.setMenuitem(item);
                            child.setParent(root);
                            this.initChilds(child);
                            log.trace("Added child menu [" + root.getName() + "]");
                            root.getMenues().add(child);
                            continue;
                        }
                        throw new SubMenuNotFoundException(parameters.get(0).getParametervalue(), "Not found submenu with code: \"" + parameters.get(0).getParametervalue() + "\"");
                    }
                    catch (NumberFormatException e) {
                        log.info("parameters size={} list={}", (Object)parameters.size(), parameters);
                        log.error("Error convert string value: \"" + parameters.get(0).getParametervalue() + "\" to integer value");
                        throw new SubMenuNotFoundException(parameters.get(0).getParametervalue(), "Not found submenu with code: \"" + parameters.get(0).getParametervalue() + "\"", e);
                    }
                }
                HierarchicalMenuItem action = new HierarchicalMenuItem(item.getCmactioncode().getCmactionname(), item.getMenuitemorder());
                action.setCmaction(item.getCmactioncode());
                action.setMenu(null);
                action.setMenuitem(item);
                action.setParent(root);
                log.trace("Added action [" + action.getName() + "]");
                root.getActions().add(action);
            }
        }
    }

    private void createRootMenu(HierarchicalMenuItem parent, HierarchicalMenuItem element) throws ExecuteQueryException {
        Menu menu = LibActivator.getDefault().getActualClassResolver().getInstance(Menu.class);
        menu.setMenuname(element.getName());
        Object id = null;
        if (element.getMenu() != null && element.getMenu().getMenucode() != null && element.getMenu().getMenucode().equals(100500)) {
            id = element.getMenu().getMenucode();
            menu.setMenucode(Integer.parseInt(id.toString()));
        } else {
            id = DaoFactory.getDAO(this.getActual(Menu.class)).getById(1);
            if (id != null) {
                id = DaoFactory.getDAO(this.getActual(Menu.class)).getMaxId();
                menu.setMenucode(Integer.parseInt(id.toString()) + 1);
            } else {
                menu.setMenucode(1);
            }
        }
        DaoFactory.getDAO(this.getActual(Menu.class)).update(menu);
        Cmaction cmaction = LibActivator.getDefault().getActualClassResolver().getInstance(Cmaction.class);
        cmaction.setCmactionname(menu.getMenuname());
        cmaction.setLogmode(false);
        Command command = this.getCommandMenu();
        cmaction.setCommand(command);
        cmaction = DaoFactory.getDAO(this.getActual(Cmaction.class)).update(cmaction);
        Actionparameter actionparameter = LibActivator.getDefault().getActualClassResolver().getInstance(Actionparameter.class);
        actionparameter.setCmaction(cmaction);
        actionparameter.setParameterorder(1);
        actionparameter.setParametervalue(menu.getMenucode().toString());
        id = DaoFactory.getDAO(this.getActual(Actionparameter.class)).getMaxId();
        if (id != null) {
            actionparameter.setActionparametercode(Integer.parseInt(id.toString()) + 1);
        } else {
            actionparameter.setActionparametercode(1);
        }
        cmaction.getActionparameterCollection().add(actionparameter);
        DaoFactory.getDAO(this.getActual(Actionparameter.class)).save(actionparameter);
        element.setMenu(menu);
        element.setMenuitem(null);
        element.setCmaction(cmaction);
        element.setParent(parent);
    }

    private void createSubmenu(HierarchicalMenuItem parent, HierarchicalMenuItem element) throws ExecuteQueryException {
        this.createRootMenu(parent, element);
        Menuitem menuitem = LibActivator.getDefault().getActualClassResolver().getInstance(Menuitem.class);
        menuitem.setCmactioncode(element.getCmaction());
        menuitem.setMenucode(parent.getMenu());
        menuitem.setMenuitemorder(element.getOrder());
        DaoFactory.getDAO(this.getActual(Menuitem.class)).update(menuitem);
        element.setMenuitem(menuitem);
    }

    private boolean isExistedAction(HierarchicalMenuItem parent, HierarchicalMenuItem action) {
        if (action.getMenuitem() != null) {
            for (HierarchicalMenuItem menuItem : parent.getActions()) {
                if (!menuItem.getMenuitem().getMenuitemcode().equals(action.getMenuitem().getMenuitemcode())) continue;
                return true;
            }
        }
        return false;
    }

    private void createAction(HierarchicalMenuItem parent, HierarchicalMenuItem action) throws ExecuteQueryException {
        if (!this.isExistedAction(parent, action)) {
            this.crateCmaction(action);
            Menuitem menuitem = LibActivator.getDefault().getActualClassResolver().getInstance(Menuitem.class);
            menuitem.setCmactioncode(action.getCmaction());
            menuitem.setMenucode(parent.getMenu());
            menuitem.setMenuitemorder(action.getOrder());
            DaoFactory.getDAO(this.getActual(Menuitem.class)).update(menuitem);
            action.setMenuitem(menuitem);
            action.setParent(parent);
            parent.getActions().add(action);
        }
    }

    private void crateCmaction(HierarchicalMenuItem action) throws ExecuteQueryException {
        Cmaction cmaction = action.getCmaction();
        if (cmaction.getCmactioncode() == null) {
            cmaction.setLogmode(false);
            cmaction.setCmactionname(action.getName());
            DaoInterface<Cmaction> dao = DaoFactory.getDAO(this.getActual(Cmaction.class));
            List<Actionparameter> coll = cmaction.getActionparameterCollection();
            cmaction.setActionparameterCollection(null);
            dao.save(cmaction);
            for (Actionparameter param : coll) {
                param.setCmaction(cmaction);
            }
            cmaction.setActionparameterCollection(coll);
            dao.update(cmaction);
        }
    }

    private void deleteRootMenu(HierarchicalMenuItem element) throws ExecuteQueryException {
        this.deleteSubMenu(element, element);
    }

    private void deleteSubMenu(HierarchicalMenuItem parent, HierarchicalMenuItem element) throws ExecuteQueryException {
        int i;
        if (!element.getActions().isEmpty()) {
            i = 0;
            while (i < element.getActions().size()) {
                this.deleteAction(element.getActions().get(i).getParent(), element.getActions().get(i));
                ++i;
            }
            element.getActions().removeAll(element.getActions());
        }
        if (!element.getMenues().isEmpty()) {
            i = 0;
            while (i < element.getMenues().size()) {
                this.deleteSubMenu(element.getMenues().get(i).getParent(), element.getMenues().get(i));
                ++i;
            }
            element.getMenues().removeAll(element.getMenues());
        }
        log.trace("DELETING MENU [" + element.getName() + "] FROM [" + parent.getName() + "]");
        if (element.getMenuitem() != null) {
            DaoFactory.getDAO(this.getActual(Menuitem.class)).delete(element.getMenuitem());
        }
        DaoFactory.getDAO(this.getActual(Cmaction.class)).delete(element.getCmaction());
        DaoFactory.getDAO(this.getActual(Menu.class)).delete(element.getMenu());
        element.setParent(null);
    }

    private void deleteAction(HierarchicalMenuItem parent, HierarchicalMenuItem element) throws ExecuteQueryException {
        log.trace("DELETING ACTION [" + element.getName() + "] FROM [" + parent.getName() + "]");
        DaoFactory.getDAO(this.getActual(Menuitem.class)).delete(element.getMenuitem());
        element.setParent(null);
    }

    public void loadData() throws MenuNotFoundException, SubMenuNotFoundException {
        try {
            SessionManager.openSession(Menu.class);
            long delta = System.currentTimeMillis();
            this.roots = new ArrayList<HierarchicalMenuItem>();
            this.prep();
            this.initRoots();
            log.debug("roots size={}, delta={}", (Object)this.roots.size(), (Object)(System.currentTimeMillis() - delta));
            if (this.roots.size() > 0) {
                for (HierarchicalMenuItem parent : this.roots) {
                    this.initChilds(parent);
                }
            }
            this.sort(this.roots);
            SessionManager.closeSession(Menu.class);
        }
        catch (MenuNotFoundException e) {
            log.error(e.getMessage());
            throw new MenuNotFoundException(e.getMenuCode(), e.getMessage(), e);
        }
        catch (SubMenuNotFoundException e) {
            log.error(e.getMessage());
            throw new SubMenuNotFoundException(e.getSubMenuCode(), e.getMessage(), e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<HierarchicalMenuItem> getRoots() {
        return this.roots;
    }

    public void add(HierarchicalMenuItem parent, HierarchicalMenuItem element, boolean action) throws ExecuteQueryException {
        if (!action) {
            if (parent == null) {
                this.createRootMenu(null, element);
                this.roots.add(element);
            } else {
                this.createSubmenu(parent, element);
                parent.getMenues().add(element);
            }
        } else {
            this.createAction(parent, element);
        }
    }

    public void update(HierarchicalMenuItem element, boolean action) throws ExecuteQueryException {
        element.getCmaction().setCmactionname(element.getName());
        DaoFactory.getDAO(this.getActual(Cmaction.class)).update(element.getCmaction());
        if (element.getMenuitem() != null && element.getMenues() != null) {
            element.getMenuitem().setCmactioncode(element.getCmaction());
            element.getMenuitem().setMenuitemorder(element.getOrder());
            DaoFactory.getDAO(this.getActual(Menuitem.class)).update(element.getMenuitem());
        }
        if (!action) {
            element.getMenu().setMenuname(element.getName());
            DaoFactory.getDAO(this.getActual(Menu.class)).update(element.getMenu());
        }
        if (element.getParent() == null) {
            int index = this.roots.indexOf(element);
            this.roots.set(index, element);
        } else {
            HierarchicalMenuItem parent = element.getParent();
            if (!action) {
                int index = parent.getMenues().indexOf(element);
                parent.getMenues().set(index, element);
            } else {
                int index = parent.getActions().indexOf(element);
                parent.getActions().set(index, element);
            }
        }
    }

    public void delete(HierarchicalMenuItem parent, HierarchicalMenuItem element, boolean action) throws ExecuteQueryException {
        if (!action) {
            if (parent == null) {
                this.deleteRootMenu(element);
                this.roots.remove(element);
            } else {
                this.deleteSubMenu(parent, element);
                parent.getMenues().remove(element);
            }
        } else {
            this.deleteAction(parent, element);
            parent.getActions().remove(element);
        }
    }

    public void importRoot(HierarchicalMenuItem parent, HierarchicalMenuItem element, boolean action) throws ExecuteQueryException {
        if (!action) {
            if (parent == null) {
                this.importElement(null, element);
                this.roots.add(element);
            } else {
                this.importElement(parent, element);
                parent.getMenues().add(element);
            }
        } else {
            this.importElement(parent, element);
        }
    }

    private void importElement(HierarchicalMenuItem parent, HierarchicalMenuItem element) throws ExecuteQueryException {
        List<Actionparameter> list;
        if (element.getMenu() != null) {
            DaoFactory.getDAO(this.getActual(Menu.class)).update(element.getMenu());
        }
        log.info("insert {}", (Object)element.getCmaction());
        if (DaoFactory.getDAO(this.getActual(Cmaction.class)).getById(element.getCmaction().getCmactioncode()) != null) {
            list = element.getCmaction().getActionparameterCollection();
            element.getCmaction().setActionparameterCollection(null);
            DaoFactory.getDAO(this.getActual(Cmaction.class)).update(element.getCmaction());
            for (Actionparameter p : list) {
                if (DaoFactory.getDAO(this.getActual(Actionparameter.class)).getById(p.getActionparametercode()) != null) {
                    DaoFactory.getDAO(this.getActual(Actionparameter.class)).update(p);
                    continue;
                }
                DaoFactory.getDAO(this.getActual(Actionparameter.class)).save(p);
            }
        } else {
            list = element.getCmaction().getActionparameterCollection();
            element.getCmaction().setActionparameterCollection(null);
            DaoFactory.getDAO(this.getActual(Cmaction.class)).save(element.getCmaction());
            for (Actionparameter p : list) {
                if (DaoFactory.getDAO(this.getActual(Actionparameter.class)).getById(p.getActionparametercode()) != null) {
                    DaoFactory.getDAO(this.getActual(Actionparameter.class)).update(p);
                    continue;
                }
                DaoFactory.getDAO(this.getActual(Actionparameter.class)).save(p);
            }
        }
        for (Actionparameter parameter : element.getActionParameters()) {
            DaoFactory.getDAO(this.getActual(Actionparameter.class)).update(parameter);
        }
        if (parent != null) {
            if (DaoFactory.getDAO(this.getActual(Menuitem.class)).getById(element.getMenuitem().getMenuitemcode()) != null) {
                DaoFactory.getDAO(this.getActual(Menuitem.class)).update(element.getMenuitem());
            } else {
                DaoFactory.getDAO(this.getActual(Menuitem.class)).save(element.getMenuitem());
            }
        }
    }
}

