/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.AbstractCriteriaWorker;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.utils.AdditionalCriteria;
import ru.ssa.cashadmin.utils.FilterRestriction;

public class ArtixFilter<E> {
    private final List<FilterRestriction<E>> restrictions;
    private FilterRestriction<E> masterRestriction;
    private List<Projection> projections;
    private List<String> projectionProperties;
    private AdditionalCriteria additionalCriteria;
    private final Class<E> e;
    private static final Logger log = LoggerFactory.getLogger(ArtixFilter.class);
    private final AbstractCriteriaWorker<E> criteriaWorker;
    private Resolver resolver = new DefaultResolver();

    public ArtixFilter(Class<E> base) {
        Class<E> actual = LibActivator.getDefault().getActualClassResolver().getActual(base);
        this.e = actual;
        this.restrictions = new ArrayList<FilterRestriction<E>>();
        this.criteriaWorker = new AbstractCriteriaWorker<E>(this.e);
    }

    public void add(FilterRestriction<E> filterRestriction) {
        if (filterRestriction.getLogicOperation().equals((Object)FilterRestriction.LinkCondition.unique)) {
            this.clearNotFixed();
        }
        this.restrictions.add(filterRestriction);
    }

    public void clearAll() {
        this.restrictions.clear();
    }

    public void clearNotFixed() {
        Iterator<FilterRestriction<E>> iterator = this.restrictions.iterator();
        while (iterator.hasNext()) {
            FilterRestriction<E> restriction = iterator.next();
            if (restriction.getIsFixed().booleanValue()) continue;
            iterator.remove();
        }
    }

    public void clearFixed() {
        Iterator<FilterRestriction<E>> iterator = this.restrictions.iterator();
        while (iterator.hasNext()) {
            FilterRestriction<E> restriction = iterator.next();
            if (!restriction.getIsFixed().booleanValue()) continue;
            iterator.remove();
        }
    }

    void addMasterRestriction(FilterRestriction<E> filterRestriction) {
        this.setMasterRestriction(filterRestriction);
    }

    private SessionFactory getCurrentSession() {
        return DaoFactory.findAppropriateSessionFactory(this.e);
    }

    private Criterion getCriterion(Class clazz, String property, FilterRestriction.Condition condition, Object value) {
        SimpleExpression criterion = null;
        switch (condition) {
            case eq: {
                criterion = Restrictions.eq((String)property, (Object)value);
                break;
            }
            case gt: {
                criterion = Restrictions.gt((String)property, (Object)value);
                break;
            }
            case lt: {
                criterion = Restrictions.lt((String)property, (Object)value);
                break;
            }
            case ne: {
                criterion = Restrictions.ne((String)property, (Object)value);
                break;
            }
            case ge: {
                criterion = Restrictions.ge((String)property, (Object)value);
                break;
            }
            case le: {
                criterion = Restrictions.le((String)property, (Object)value);
                break;
            }
            case like: {
                if (value instanceof String) {
                    criterion = Restrictions.like((String)property, (String)((String)value), (MatchMode)MatchMode.ANYWHERE);
                    break;
                }
                String[] propertyNames = this.getPropertyNames(clazz, property);
                criterion = Restrictions.sqlRestriction((String)("cast(" + propertyNames[0] + " as CHAR) like (?)"), (Object)("%" + value + "%"), (Type)Hibernate.STRING);
                log.trace(criterion.toString());
                break;
            }
            case like_start: {
                if (value instanceof String) {
                    criterion = Restrictions.like((String)property, (String)((String)value), (MatchMode)MatchMode.START);
                    break;
                }
                String[] propertyNames = this.getPropertyNames(clazz, property);
                criterion = Restrictions.sqlRestriction((String)("cast(" + propertyNames[0] + " as CHAR) like (?)"), (Object)(value + "%"), (Type)Hibernate.STRING);
                break;
            }
            case like_end: {
                if (value instanceof String) {
                    criterion = Restrictions.like((String)property, (String)((String)value), (MatchMode)MatchMode.END);
                    break;
                }
                String[] propertyNames = this.getPropertyNames(clazz, property);
                criterion = Restrictions.sqlRestriction((String)("cast(" + propertyNames[0] + " as CHAR) like (?)"), (Object)("%" + value), (Type)Hibernate.STRING);
                break;
            }
        }
        return criterion;
    }

    private String[] getPropertyNames(Class<?> clazz, String property) {
        SessionFactory sessionFactory = this.getCurrentSession();
        String[] propertyNames = new String[]{property};
        SingleTableEntityPersister persister = null;
        try {
            persister = (SingleTableEntityPersister)sessionFactory.getClassMetadata(clazz);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (persister != null) {
            propertyNames = persister.getPropertyColumnNames(property);
        }
        return propertyNames;
    }

    public DetachedCriteria getDetachedCriteria() {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.e);
        if (this.projections != null && !this.projections.isEmpty()) {
            for (Projection projection : this.projections) {
                criteria.setProjection(projection);
            }
        }
        Object master = null;
        if (this.getMasterRestriction() != null) {
            master = this.getMasterRestriction().getState();
        }
        if (master != null) {
            Object state = this.getMasterRestriction().getState();
            criteria.add((Criterion)Example.create((Object)master));
            this.criteriaWorker.addAssociatedCriteria(state, criteria);
            this.criteriaWorker.addCollectionCriteria(state, criteria);
        }
        Criterion resultCriterion = null;
        if (this.restrictions.size() > 0) {
            for (FilterRestriction<E> r : this.restrictions) {
                Criterion criterion = null;
                Object state = r.getState();
                String propertyName = r.getProperty();
                if (this.resolver.hasNested(propertyName)) {
                    CriteriaImpl.Subcriteria subCriteria;
                    String subPropertyName = this.resolver.remove(propertyName);
                    propertyName = this.resolver.next(propertyName);
                    log.trace("sub property name={}", (Object)subPropertyName);
                    Object value = null;
                    value = state;
                    if (value == null) continue;
                    Class<?> entityClazz = value.getClass();
                    Boolean hasSubCriteria = false;
                    Criteria simpleCriteria = criteria.getExecutableCriteria((Session)this.getCurrentSession().getCurrentSession());
                    criterion = this.getCriterion(entityClazz, subPropertyName, r.getOpType(), value);
                    CriteriaImpl criteriaImpl = (CriteriaImpl)simpleCriteria;
                    Iterator it = criteriaImpl.iterateSubcriteria();
                    while (it.hasNext()) {
                        subCriteria = (CriteriaImpl.Subcriteria)it.next();
                        if (!subCriteria.getPath().equals(propertyName)) continue;
                        subCriteria.add(criterion);
                        hasSubCriteria = true;
                    }
                    if (hasSubCriteria.booleanValue()) continue;
                    subCriteria = criteria.createCriteria(propertyName);
                    subCriteria.add(criterion);
                    continue;
                }
                criterion = this.getCriterion(this.e, r.getProperty(), r.getOpType(), state);
                switch (r.getLogicOperation()) {
                    case and: {
                        resultCriterion = Restrictions.and((Criterion)resultCriterion, (Criterion)criterion);
                        break;
                    }
                    case or: {
                        resultCriterion = Restrictions.or((Criterion)resultCriterion, (Criterion)criterion);
                        break;
                    }
                    case unique: {
                        resultCriterion = criterion;
                        break;
                    }
                }
            }
            if (resultCriterion != null) {
                criteria.add(resultCriterion);
            }
        }
        if (this.additionalCriteria != null) {
            criteria.add(this.convert(this.additionalCriteria));
        }
        return criteria;
    }

    private Criterion convert(AdditionalCriteria additionalCriteria) {
        SimpleExpression criterion = null;
        switch (additionalCriteria.getType()) {
            case EQ: {
                criterion = Restrictions.eq((String)((String)additionalCriteria.getValues()[0]), (Object)additionalCriteria.getValues()[1]);
                break;
            }
            case EQ_PROPERTY: {
                criterion = Restrictions.eqProperty((String)((String)additionalCriteria.getValues()[0]), (String)((String)additionalCriteria.getValues()[1]));
                break;
            }
            case IN: {
                criterion = Restrictions.in((String)((String)additionalCriteria.getValues()[0]), (Object[])((Object[])additionalCriteria.getValues()[1]));
                break;
            }
            case LIKE_START: {
                criterion = Restrictions.like((String)((String)additionalCriteria.getValues()[0]), (String)((String)additionalCriteria.getValues()[1]), (MatchMode)MatchMode.START);
                break;
            }
            case LIKE_END: {
                criterion = Restrictions.like((String)((String)additionalCriteria.getValues()[0]), (String)((String)additionalCriteria.getValues()[1]), (MatchMode)MatchMode.END);
                break;
            }
            case LIKE_ANYWHERE: {
                criterion = Restrictions.like((String)((String)additionalCriteria.getValues()[0]), (String)((String)additionalCriteria.getValues()[1]), (MatchMode)MatchMode.ANYWHERE);
                break;
            }
        }
        return criterion;
    }

    public void setMasterRestriction(FilterRestriction<E> masterRestriction) {
        this.masterRestriction = masterRestriction;
    }

    public FilterRestriction<E> getMasterRestriction() {
        return this.masterRestriction;
    }

    public void setProjectionProperties(List<String> projectionProperties) {
        this.projectionProperties = projectionProperties;
        for (String string : projectionProperties) {
            this.projections.add((Projection)Projections.property((String)string));
        }
    }

    public List<String> getProjectionProperties() {
        return this.projectionProperties;
    }

    public AdditionalCriteria getAdditionalCriteria() {
        return this.additionalCriteria;
    }

    public void setAdditionalCriteria(AdditionalCriteria additionalCriteria) {
        this.additionalCriteria = additionalCriteria;
    }

    public final List<FilterRestriction<E>> getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ArtixFilter [e=");
        builder.append(this.e);
        builder.append("]");
        return builder.toString();
    }
}

